# How to reach reproducibility check 

This is about reproducibility of file 
`src/site/tex/paperFirFromIIRnotch.pdf`. 

It has already been moved 
from the TEX source directory `src/site/tex` 
to the diff directory `src/main/resources/docsCmp`, 
which is the first step of reproducibility check. 

The first problem `2024-07-01` is, that the project did not compile initially. 
This is because the version of the `latex` plugin is a snapshot version 
which is no longer available. 
In the future, we shall not keep snapshot versions too long. 
A reasonable reproducibility check will be available in version `2.1`, 
whereas now no more than `2.1-SNAPSHOT` is available. 
So, we have to update to `2.1-SNAPSHOT` release soon `2.1` and then update accordingly. 

This is not the only problem: 
Also compilation goes wrong. 
To recover and for hints to further steps, we collected the [metadata](#metadata) 
in a separate section. 




## Metadata

Looking at metadata 
with `pdfinfo` unveils the following: 

```
$ pdfinfo -isodates paperFirFromIIRnotch.pdf 

Title:           
Subject:         
Keywords:        
Author:          
Creator:         LaTeX with hyperref
Producer:        LuaTeX-1.15.0
CreationDate:    2023-01-27T22:15:48+01
ModDate:         2023-01-27T22:15:48+01
Custom Metadata: yes
Metadata Stream: no
Tagged:          no
UserProperties:  no
Suspects:        no
Form:            none
JavaScript:      no
Pages:           27
Encrypted:       no
Page size:       595.276 x 841.89 pts (A4)
Page rot:        0
File size:       1524612 bytes
Optimized:       no
PDF version:     1.7
```

The same with `exiftool`: 

```
$ exiftool  paperFirFromIIRnotch.pdf 
ExifTool Version Number         : 12.87
File Name                       : paperFirFromIIRnotch.pdf
Directory                       : .
File Size                       : 1525 kB
File Modification Date/Time     : 2024:07:01 17:03:46+02:00
File Access Date/Time           : 2024:07:01 17:10:26+02:00
File Inode Change Date/Time     : 2024:07:01 17:10:25+02:00
File Permissions                : -rw-r--r--
File Type                       : PDF
File Type Extension             : pdf
MIME Type                       : application/pdf
PDF Version                     : 1.7
Linearized                      : No
Page Count                      : 27
Page Mode                       : UseOutlines
Author                          : 
Title                           : 
Subject                         : 
Creator                         : LaTeX with hyperref
Producer                        : LuaTeX-1.15.0
Create Date                     : 2023:01:27 22:15:48+01:00
Modify Date                     : 2023:01:27 22:15:48+01:00
Trapped                         : False
PTEX Full Banner                : This is LuaHBTeX, Version 1.15.0 (TeX Live 2022/TeX Live for SUSE Linux)
```

## Make compile again with the same result 

One of the pieces of information from metadata is, 
that `paperFirFromIIRnotch.tex` has been compiled with `lualatex` 
which fits to `paperFirFromIIRnotch.tex` specifying 

```
\pdfvariable minorversion 7% chktex 1
\usepackage{fontspec}% lualatex
```

This is specific for `lualatex` and will not compile with `pdflatex`. 
This contradicts `pom.xml` which specifies 

```
<latex2pdfCommand>pdflatex</latex2pdfCommand>
```

Thus, we had to drop that line to fall back to the default `lualatex`. 

Still, the TEX file does not compile because `pythontex` lacks writing a log file. 
Thus, we must replace by the injection `pythontexW`. 
The new settings for `pythontex` we insert are: 

```
  <pythontexCommand>pythontexW:pythontex</pythontexCommand>
  <pythontexOptions>--rerun=always</pythontexOptions>
```

To make the injection `pythontexW` available we need `latex-maven-plugin` at least in version `2.0`. 
To enable recent reproducibility check, we use `2.1-SNAPSHOT` and add 

```
  <chkDiff>true</chkDiff>
```

In the long run, we require version `2.1` of course to stabilize reproducibility, 
but this release does not exist at time of this writing. 

With these settings, at least, `latexmk paperFirFromIIRnotch` compiles and yields a result 
which, according to `diff-pdf-visually` coincides with the original except the first two pages. 
Extraction of the according pages is done with 

```
pdftk A=paperFirFromIIRnotch.pdf cat A3- output paperFirFromIIRnotch3-.pdf 
```

To try the same with the latex plugin via 

```
mvn clean latex:pdf
```

is only possible after deleting 

```
src/main/resources/docsCmp/paperFirFromIIRnotch.pdf
```

Even then, the latex plugin fails in that it writes diagrams in headlines of tables. 
Only setting in the pom 

```
<latexmkUsage>AsBackend</latexmkUsage>
```

makes it run, so that the result is the same as in the original PDF file, 
except for the first two pages. 
The author checked visually and seemingly only minor shifts of frames from package `hyperref` seem to differ. 


Let us now check the metadata via `pdfinfo`: 

```
$ pdfinfo -isodates paperFirFromIIRnotch.pdf

Title:           
Subject:         
Keywords:        
Author:          
Creator:         LaTeX with hyperref
Producer:        LuaTeX-1.18.0
CreationDate:    2024-07-01T18:01:34Z
ModDate:         2024-07-01T18:01:34Z
Custom Metadata: yes
Metadata Stream: no
Tagged:          no
UserProperties:  no
Suspects:        no
Form:            none
JavaScript:      no
Pages:           27
Encrypted:       no
Page size:       595.276 x 841.89 pts (A4)
Page rot:        0
File size:       1524375 bytes
Optimized:       no
PDF version:     1.7
```

The differences are the versions of `LuaTeX`, the timestamps including the timezone 
and a minor deviation in file size. 

The same with `exiftool`: 

```
 $ exiftool  paperFirFromIIRnotch.pdf 
ExifTool Version Number         : 12.87
File Name                       : paperFirFromIIRnotch.pdf
Directory                       : .
File Size                       : 1524 kB
File Modification Date/Time     : 2024:07:01 20:01:39+02:00
File Access Date/Time           : 2024:07:01 20:01:39+02:00
File Inode Change Date/Time     : 2024:07:01 20:01:39+02:00
File Permissions                : -rw-r--r--
File Type                       : PDF
File Type Extension             : pdf
MIME Type                       : application/pdf
PDF Version                     : 1.7
Linearized                      : No
Page Count                      : 27
Page Mode                       : UseOutlines
Author                          : 
Title                           : 
Subject                         : 
Creator                         : LaTeX with hyperref
Producer                        : LuaTeX-1.18.0
Create Date                     : 2024:07:01 18:01:34Z
Modify Date                     : 2024:07:01 18:01:34Z
Trapped                         : False
PTEX Full Banner                : This is LuaHBTeX, Version 1.18.0 (TeX Live 2024/TeX Live for SUSE Linux)
```

Essentially the same, except that the banner unveils more information on `LuaTeX`. 

At this stage, it is possible to copy the newly created PDF file 
to turn it into the blueprint. 

## Suspicion 

Taking into account that the settings in the pom do not fit the metadata, 
it is likely that the article under consideration never worked with the latex plugin. 
Instead, it is very likely that it could be compiled with `latexmk` 
with appropriate `.latexmkrc` file. 

## Step towards compilation with the latex plugin 

As a first step, 



