/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.names;

import eu.simuline.names.CatGrammar;
import eu.simuline.names.Category;
import eu.simuline.names.Compartment;
import eu.simuline.names.RulesLexer;
import eu.simuline.names.RulesParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class Files {
    private static final String END_CAT = ".cat";
    private static final String END_CATD = ".cat$";
    final File rules;
    List<File> catFiles;
    CatGrammar catGr;

    public Files(File rules) {
        this.rules = rules;
        this.reload();
    }

    private static RulesParser getParser(File file) throws IOException {
        CharStream input = CharStreams.fromFileName((String)file.getPath());
        RulesLexer lexer = new RulesLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        return new RulesParser((TokenStream)tokens);
    }

    List<String> reload() {
        RulesParser rParser;
        if (!this.rules.isFile() || !this.rules.canRead()) {
            throw new IllegalArgumentException("File \"\" is no file or not readable. ");
        }
        File dir = this.rules.getParentFile();
        assert (dir.isDirectory());
        this.catFiles = Arrays.asList(dir.listFiles());
        HashMap<File, Category> catFile2cat = new HashMap<File, Category>();
        for (File catFile : this.catFiles) {
            String name = catFile.getName();
            if (!name.endsWith(END_CAT)) continue;
            name = name.replaceFirst(END_CATD, "");
            catFile2cat.put(catFile, new Category(name));
        }
        System.out.println("catFile2cat: " + catFile2cat);
        ArrayList<String> excMsgs = new ArrayList<String>();
        try {
            rParser = Files.getParser(this.rules);
            this.catGr = rParser.setCats(catFile2cat.values());
            rParser.parseRules();
            assert (this.catGr != null);
        }
        catch (IOException e) {
            excMsgs.add(e.getMessage());
        }
        catch (RecognitionException e) {
            excMsgs.add(e.getMessage());
        }
        for (File cand : catFile2cat.keySet()) {
            List<Compartment> lComp;
            System.out.println("cand: " + cand);
            try {
                rParser = Files.getParser(cand);
                rParser.parseCategory();
                lComp = rParser.getCategory();
                System.out.println("lComp: " + lComp);
            }
            catch (IOException e) {
                excMsgs.add(e.getMessage());
                continue;
            }
            catch (RecognitionException e) {
                excMsgs.add(e.getMessage());
                continue;
            }
            try {
                this.catGr.map((Category)catFile2cat.get(cand), lComp);
            }
            catch (IllegalStateException e) {
                excMsgs.add(e.getMessage());
            }
        }
        try {
            this.catGr.check();
        }
        catch (IllegalStateException e) {
            excMsgs.add(e.getMessage());
        }
        if (excMsgs.isEmpty()) {
            System.out.println("Successfully parsed grammar. ");
        } else {
            System.out.println("Parsing the grammar found failures: \n" + excMsgs);
        }
        return excMsgs;
    }
}

