/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.names;

import eu.simuline.names.Category;
import eu.simuline.names.Compartment;
import eu.simuline.names.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CatGrammar {
    public static final Category FREE_CAT = new Category("FREE_CAT");
    private final Collection<Category> cats;
    Map<Category, Collection<Category>> rules;
    Set<Category> starts;
    private final Set<Category> stops;
    private final Map<Category, List<Compartment>> cat2comps;

    public CatGrammar(Collection<Category> cats) {
        this.cats = cats;
        this.rules = new HashMap<Category, Collection<Category>>();
        this.starts = new HashSet<Category>();
        this.stops = new HashSet<Category>();
        this.cat2comps = new HashMap<Category, List<Compartment>>();
    }

    public void addStart(Category targetC) {
        if (!this.cats.contains(targetC)) {
            throw new ParseException("Target \"" + targetC + "\"is no valid category. ");
        }
        boolean added = this.starts.add(targetC);
        if (!added) {
            throw new ParseException("Added start category \"" + targetC + "\" more than once. ");
        }
    }

    public void addStop(Category sourceC) {
        if (!this.cats.contains(sourceC)) {
            throw new ParseException("Source \"" + sourceC + "\"is no valid category. ");
        }
        boolean added = this.stops.add(sourceC);
        if (!added) {
            throw new ParseException("Added stop category \"" + sourceC + "\" more than once. ");
        }
    }

    public void addRule(Category sourceC, Collection<Category> targets) {
        if (!this.cats.contains(sourceC)) {
            throw new ParseException("Source or target is no category. ");
        }
        if (!this.cats.containsAll(targets)) {
            throw new ParseException("At least one target is no category. ");
        }
        Collection<Category> overwritten = this.rules.put(sourceC, targets);
        if (overwritten != null) {
            throw new ParseException("Overwritten rule for source \"" + sourceC + "\". ");
        }
    }

    void check() {
        HashSet<Category> allTargets = new HashSet<Category>();
        for (Category source : this.rules.keySet()) {
            allTargets.addAll(this.rules.get(source));
        }
        allTargets.removeAll(this.rules.keySet());
        if (!allTargets.isEmpty()) {
            throw new IllegalStateException("Found no rule for categries" + allTargets + ". ");
        }
    }

    boolean isStart(Category cat) {
        return this.starts.contains(cat);
    }

    boolean isStop(Category cat) {
        return this.stops.contains(cat);
    }

    List<Compartment> comps(Category cat) {
        return this.cat2comps.get(cat);
    }

    public void map(Category cat, List<Compartment> comps) {
        List<Compartment> overwritten = this.cat2comps.put(cat, comps);
        if (overwritten != null) {
            throw new IllegalStateException("Reassigned compartments of category \"" + cat + "\". ");
        }
    }

    public List<Compartment> cat2comps(Category cat) {
        return this.cat2comps.get(cat);
    }

    public Collection<Category> nextCats(Category curr) {
        return this.rules.get(curr);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("<CatGr><Starts>");
        res.append(this.starts);
        res.append("</Starts><Rules>");
        res.append(this.rules);
        res.append("</Rules><Cat2comps>");
        res.append(this.cat2comps);
        res.append("</Cat2comps><Stops>");
        res.append(this.stops);
        res.append("</Stops></CatGr>");
        return res.toString();
    }
}

