/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.names;

import eu.simuline.names.Category;
import eu.simuline.names.Compartment;
import eu.simuline.names.Files;
import eu.simuline.names.NameAnalyzer;
import eu.simuline.names.NameCreator;
import eu.simuline.util.images.GifResource;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.javalobby.icons20x20.Magnify;
import org.javalobby.icons20x20.New;
import org.javalobby.icons20x20.RotCCLeft;

public class CreatorAnalyzerFrame
extends JFrame {
    private static final long serialVersionUID = -2479143000061671589L;
    private static final String STATE_COMPLETE = "Complete";
    private static final String STATE_NOT_COMPLETE = "Not Yet Complete";
    DefaultComboBoxModel<Category> combCat;
    DefaultComboBoxModel<Compartment> combComp;
    NameCreator creator;
    NameAnalyzer analyzer;
    Files files;
    JTextField nameField;
    JLabel creatorStatusLabel;
    JLabel structLabel;
    JLabel linearLabel;
    JLabel analyzerStatusLabel;

    public CreatorAnalyzerFrame(Files files) {
        super("Checker Frame");
        this.files = files;
        this.reloadGrammar();
        this.setDefaultCloseOperation(3);
        this.setMenuBar();
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        this.add(new JSeparator());
        Box partialNameB = Box.createHorizontalBox();
        partialNameB.add(new JLabel("partial name: "));
        this.nameField = new JTextField();
        partialNameB.add(this.nameField);
        this.add(partialNameB);
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalStrut(40));
        this.add(new JSeparator());
        Box headlineC = Box.createHorizontalBox();
        headlineC.add(new JLabel("Creator"));
        headlineC.add(Box.createHorizontalGlue());
        this.add(headlineC);
        Box catsCmptms = Box.createHorizontalBox();
        Box categories = Box.createVerticalBox();
        categories.add(new JLabel("categories"));
        this.combCat = new DefaultComboBoxModel();
        JComboBox<Category> comboBoxCat = new JComboBox<Category>(this.combCat);
        comboBoxCat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                switch (e.getStateChange()) {
                    case 1: {
                        System.out.println("1selected: " + e.getItem());
                        CreatorAnalyzerFrame.this.setCat((Category)e.getItem());
                        break;
                    }
                    case 2: {
                        System.out.println("1deselected: ");
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                System.out.println(": " + e.getItem());
            }
        });
        categories.add(comboBoxCat);
        catsCmptms.add(categories);
        Box compartments = Box.createVerticalBox();
        compartments.add(new JLabel("compartments"));
        this.combComp = new DefaultComboBoxModel();
        JComboBox<Compartment> comboBoxComp = new JComboBox<Compartment>(this.combComp);
        comboBoxComp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                switch (e.getStateChange()) {
                    case 1: {
                        if (e.getItem() instanceof String) {
                            return;
                        }
                        System.out.println("2selected-: " + e.getItem());
                        CreatorAnalyzerFrame.this.setComp((Compartment)e.getItem());
                        break;
                    }
                    case 2: {
                        System.out.println("3deselected: ");
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        compartments.add(comboBoxComp);
        catsCmptms.add(compartments);
        this.add(catsCmptms);
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalStrut(40));
        this.creatorStatusLabel = new JLabel();
        this.add(this.creatorStatusLabel);
        this.add(new JSeparator());
        Box headlineA = Box.createHorizontalBox();
        headlineA.add(new JLabel("Analyzer"));
        headlineA.add(Box.createHorizontalGlue());
        this.add(headlineA);
        Box structure = Box.createHorizontalBox();
        structure.add(new JLabel("Structure: "));
        this.structLabel = new JLabel();
        structure.add(this.structLabel);
        structure.add(Box.createHorizontalGlue());
        this.add(structure);
        Box linear = Box.createHorizontalBox();
        linear.add(new JLabel("Linear: "));
        this.linearLabel = new JLabel();
        linear.add(this.linearLabel);
        linear.add(Box.createHorizontalGlue());
        this.add(linear);
        Box analyzerStatus = Box.createHorizontalBox();
        analyzerStatus.add(new JLabel("Status: "));
        this.analyzerStatusLabel = new JLabel();
        analyzerStatus.add(this.analyzerStatusLabel);
        analyzerStatus.add(Box.createHorizontalGlue());
        this.add(analyzerStatus);
        this.resetCreator();
        this.setSize(800, 300);
        this.setVisible(true);
    }

    void setMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.add(new JMenuItem(new ActionCreate()));
        menubar.add(new JMenuItem(new ActionAnalyze()));
        menubar.add(new JMenuItem(new ActionReLoadGrammar()));
        this.setJMenuBar(menubar);
    }

    void reloadGrammar() {
        this.files.reload();
        this.creator = new NameCreator(this.files.catGr);
        this.analyzer = new NameAnalyzer(this.files.catGr);
    }

    void resetCreator() {
        this.nameField.setText(this.creator.reset());
        this.setCats(this.files.catGr.starts);
        this.creatorStatusLabel.setText(STATE_NOT_COMPLETE);
        this.structLabel.setText("");
        this.linearLabel.setText("");
        this.analyzerStatusLabel.setText("");
    }

    void analyze() {
        NameAnalyzer.State state = this.analyzer.analyze(this.nameField.getText());
        if (state != NameAnalyzer.State.Matches) {
            this.structLabel.setText("");
            this.linearLabel.setText("");
            this.analyzerStatusLabel.setText(state.toString());
            return;
        }
        this.structLabel.setText(this.analyzer.structure());
        if (this.analyzer.isLinear()) {
            this.linearLabel.setText(this.analyzer.linStructure());
        } else {
            this.linearLabel.setText("");
        }
        this.analyzerStatusLabel.setText((this.analyzer.isLinear() ? "linear " : "       ") + (this.analyzer.isAllComplete() ? "  complete" : "incomplete"));
    }

    void setCat(Category newCat) {
        List<Compartment> compsOfCat = this.creator.setNewCat(newCat);
        this.setComps(compsOfCat);
    }

    void setComp(Compartment comp) {
        this.nameField.setText(this.creator.add(comp));
        if (this.creator.isStop()) {
            this.creatorStatusLabel.setText(STATE_COMPLETE);
        } else {
            this.creatorStatusLabel.setText(STATE_NOT_COMPLETE);
        }
        Collection<Category> nextCats = this.creator.nextCats();
        if (nextCats.isEmpty()) {
            if (!this.creator.isStop()) {
                throw new IllegalStateException("Found category whithout successors which is no stopcat");
            }
            this.setCats(new HashSet<Category>());
            this.setComps(new ArrayList<Compartment>());
            return;
        }
        this.setCats(nextCats);
    }

    void setCats(Collection<Category> cats) {
        System.out.println("/////////////setCats(: " + cats);
        this.combCat.removeAllElements();
        for (Category cand : cats) {
            System.out.println("add: " + cand);
            this.combCat.addElement(cand);
        }
    }

    void setComps(List<Compartment> comps) {
        this.combComp.removeAllElements();
        for (Compartment cand : comps) {
            this.combComp.addElement(cand);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length != 1) {
            throw new IllegalArgumentException("Usage: the name of the rules file. ");
        }
        Files files = new Files(new File(args[0]));
        CreatorAnalyzerFrame frame = new CreatorAnalyzerFrame(files);
        System.out.println("finished");
    }

    class ActionAnalyze
    extends AbstractAction {
        private static final long serialVersionUID = -589L;

        ActionAnalyze() {
            super("Analyze", GifResource.getIcon(Magnify.class));
            this.putValue("ShortDescription", "analyzes given name. ");
            this.putValue("MnemonicKey", 65);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            System.out.println("analyze new name");
            CreatorAnalyzerFrame.this.analyze();
        }
    }

    class ActionCreate
    extends AbstractAction {
        private static final long serialVersionUID = -589L;

        ActionCreate() {
            super("Create", GifResource.getIcon(New.class));
            this.putValue("ShortDescription", "creates new name. ");
            this.putValue("MnemonicKey", 67);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            System.out.println("create new name");
            CreatorAnalyzerFrame.this.resetCreator();
        }
    }

    class ActionReLoadGrammar
    extends AbstractAction {
        private static final long serialVersionUID = -589L;

        ActionReLoadGrammar() {
            super("Reload Grammar", GifResource.getIcon(RotCCLeft.class));
            this.putValue("ShortDescription", "reloads the grammar. ");
            this.putValue("MnemonicKey", 82);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            System.out.println("(re)load grammar");
            CreatorAnalyzerFrame.this.reloadGrammar();
        }
    }
}

