/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.names;

import eu.simuline.names.CatGrammar;
import eu.simuline.names.Category;
import eu.simuline.names.Compartment;
import eu.simuline.names.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NameAnalyzer {
    private final CatGrammar catGr;
    private String name;
    private Pointer startPointer;

    public NameAnalyzer(CatGrammar catGr) {
        this.catGr = catGr;
    }

    State analyze(String name) {
        this.name = name;
        this.startPointer = new Pointer();
        return this.startPointer.evolve();
    }

    String structure() {
        return this.startPointer.toString();
    }

    String linStructure() {
        return this.startPointer.linString();
    }

    boolean isLinear() {
        return this.startPointer.isLinear();
    }

    boolean isAllComplete() {
        return this.startPointer.isAllComplete();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Usage: the name of the rules file and the name to be checked. ");
        }
        Files files = new Files(new File(args[0]));
        CatGrammar catGr = files.catGr;
        NameAnalyzer nCheck = new NameAnalyzer(catGr);
        nCheck.analyze(args[1]);
        System.out.println("structure: " + nCheck.structure());
        System.out.println("isLinear: " + nCheck.isLinear());
        System.out.println("isLinear: " + nCheck.linStructure());
        System.out.println("isAllComplete: " + nCheck.isAllComplete());
        System.out.println("finished");
    }

    final class Pointer {
        private final int index;
        private final Category cat;
        private final Compartment comp;
        private final Set<Pointer> successors;
        private final Pointer predecessor;

        Pointer(int index, Category cat, Compartment comp, Pointer predecessor) {
            this.index = index;
            this.cat = cat;
            this.comp = comp;
            this.successors = new HashSet<Pointer>();
            this.predecessor = predecessor;
        }

        Pointer() {
            this(0, null, null, null);
        }

        State evolve() {
            Pointer newPointer;
            Collection<Category> possCats = this.cat == null ? ((NameAnalyzer)NameAnalyzer.this).catGr.starts : ((NameAnalyzer)NameAnalyzer.this).catGr.rules.get(this.cat);
            for (Category catCand : possCats) {
                assert (catCand != null);
                List<Compartment> comps = NameAnalyzer.this.catGr.comps(catCand);
                for (Compartment comp : comps) {
                    int newIndex;
                    boolean matches = NameAnalyzer.this.name.startsWith(comp.shortName(), this.index);
                    if (!matches || State.Matches != (newPointer = new Pointer(newIndex = this.index + comp.shortName().length(), catCand, comp, this)).evolve()) continue;
                    this.successors.add(newPointer);
                }
            }
            if (this.successors.isEmpty()) {
                if (this.cat == null) {
                    return State.NoMatch;
                }
                if (!NameAnalyzer.this.catGr.isStop(this.cat)) {
                    return State.NoMatch;
                }
                newPointer = new Pointer(NameAnalyzer.this.name.length(), CatGrammar.FREE_CAT, null, this);
                this.successors.add(newPointer);
            }
            return State.Matches;
        }

        private Pointer getSingleSuccessor() {
            return this.successors.toArray(new Pointer[1])[0];
        }

        boolean isLinear() {
            switch (this.successors.size()) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.getSingleSuccessor().isLinear();
                    return true;
                }
            }
            return false;
        }

        private boolean isStop() {
            return NameAnalyzer.this.catGr.isStop(this.cat);
        }

        private boolean isFree() {
            return this.cat == CatGrammar.FREE_CAT;
        }

        boolean isAllComplete() {
            if (this.successors.size() == 0) {
                return this.isStop() || this.isFree() && this.predecessor != null && this.predecessor.isStop();
            }
            assert (this.successors.size() > 0);
            for (Pointer succ : this.successors) {
                if (succ.isAllComplete()) continue;
                return false;
            }
            return true;
        }

        String linString() {
            StringBuilder res = new StringBuilder();
            if (this.cat != null) {
                assert (this.predecessor != null);
                res.append('-');
                res.append(NameAnalyzer.this.name.substring(this.predecessor.index, this.index));
                if (NameAnalyzer.this.catGr.isStop(this.cat)) {
                    res.append('|');
                }
            } else {
                assert (this.predecessor == null);
                res.append(">-");
            }
            switch (this.successors.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    res.append(this.getSingleSuccessor().linString());
                    break;
                }
                default: {
                    throw new IllegalStateException("Potential structure is not linear. ");
                }
            }
            return res.toString();
        }

        public String toString() {
            StringBuilder res = new StringBuilder();
            if (this.cat != null) {
                assert (this.predecessor != null);
                res.append('(');
                res.append(this.cat);
                res.append(':');
                res.append(NameAnalyzer.this.name.substring(this.predecessor.index, this.index));
                res.append(')');
                if (NameAnalyzer.this.catGr.isStop(this.cat)) {
                    res.append('|');
                }
            } else assert (this.predecessor == null);
            res.append(this.successors);
            return res.toString();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    static enum State {
        Matches,
        Incomplete,
        NoMatch;

    }
}

