/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.debugger;

import java.util.ArrayList;
import java.util.List;

public class VariableHistory {
    private final String name;
    private final List<String[]> values;
    private boolean newvariable;
    private boolean changed;
    private boolean removed;

    public VariableHistory(String variable) {
        this.name = variable;
        this.values = new ArrayList<String[]>();
    }

    private void addComment(String value, String comment) {
        this.values.add(new String[]{value, comment});
    }

    public String getName() {
        return this.name;
    }

    public boolean isAvailable() {
        return !this.removed;
    }

    public void addValue(String value, String comment) {
        this.addComment(value, comment);
        if (this.values.size() == 1) {
            this.newvariable = true;
            this.changed = true;
        } else {
            this.changed = true;
        }
        this.removed = false;
    }

    public void removeValue(String comment) {
        this.addComment(null, comment);
        this.changed = true;
        this.removed = true;
    }

    public String[] getValueComment(int index) {
        return this.values.get(index);
    }

    public int getValuesCount() {
        return this.values.size();
    }

    public String getLastValue() {
        if (this.values.size() > 0) {
            String[] valuecomment = this.values.get(this.values.size() - 1);
            return valuecomment[0];
        }
        return "";
    }

    public boolean isNewvariable() {
        return this.newvariable;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void clearState() {
        this.newvariable = false;
        this.changed = false;
    }

    public String getValueHistoryDetails() {
        StringBuffer details = new StringBuffer();
        details.append("<html><body>");
        details.append("<h3>Details of <b>");
        details.append(this.name);
        details.append("</b></h3>");
        for (int i = this.values.size() - 1; i >= 0; --i) {
            String[] valuecomment = this.values.get(i);
            details.append(i + 1);
            details.append(". ");
            details.append(valuecomment[0]);
            details.append(" (");
            details.append(valuecomment[1]);
            details.append(")<br>");
        }
        details.append("</body></html>");
        return details.toString();
    }

    public String toString() {
        return this.getLastValue();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VariableHistory) {
            return this.name.equals(((VariableHistory)obj).name);
        }
        return false;
    }
}

