/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.config.spi;

import com.izforge.izpack.api.config.Config;
import com.izforge.izpack.api.config.InvalidFileFormatException;
import com.izforge.izpack.api.config.spi.AbstractParser;
import com.izforge.izpack.api.config.spi.HandlerBase;
import com.izforge.izpack.api.config.spi.IniSource;
import com.izforge.izpack.api.config.spi.OptionsHandler;
import com.izforge.izpack.api.config.spi.ServiceFinder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

public class OptionsParser
extends AbstractParser {
    private static final String COMMENTS = "!#";
    private static final String OPERATORS = ":=";

    public OptionsParser() {
        super(OPERATORS, COMMENTS);
    }

    public static OptionsParser newInstance() {
        return ServiceFinder.findService(OptionsParser.class);
    }

    public static OptionsParser newInstance(Config config) {
        OptionsParser instance = OptionsParser.newInstance();
        instance.setConfig(config);
        return instance;
    }

    public void parse(InputStream input, OptionsHandler handler) throws IOException, InvalidFileFormatException {
        this.parse(this.newIniSource(input, (HandlerBase)handler), handler);
    }

    public void parse(Reader input, OptionsHandler handler) throws IOException, InvalidFileFormatException {
        this.parse(this.newIniSource(input, (HandlerBase)handler), handler);
    }

    public void parse(URL input, OptionsHandler handler) throws IOException, InvalidFileFormatException {
        this.parse(this.newIniSource(input, (HandlerBase)handler), handler);
    }

    private void parse(IniSource source, OptionsHandler handler) throws IOException, InvalidFileFormatException {
        handler.startOptions();
        String line = source.readLine();
        while (line != null) {
            this.parseOptionLine(line, source, handler);
            line = source.readLine();
        }
        handler.endOptions();
    }
}

