/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.MatchResult;
import eu.simuline.m2latex.core.Auxiliary;
import eu.simuline.m2latex.core.FileId;
import eu.simuline.m2latex.core.LatexMainParameterNames;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

class LatexMainDesc
implements Comparable<LatexMainDesc> {
    final File texFile;
    final File pdfFile;
    final File dviFile;
    final File xdvFile;
    final File logFile;
    final File idxFile;
    final File indFile;
    final File ilgFile;
    final File glsFile;
    final File glgFile;
    final File xxxFile;
    final File parentDir;
    final Map<Auxiliary, FileId> aux2fileId;
    private final MatchResult matchRes;

    LatexMainDesc(File texFile, MatchResult matchRes) {
        this.matchRes = matchRes;
        this.texFile = texFile;
        this.xxxFile = TexFileUtils.replaceSuffix(texFile, "");
        this.pdfFile = this.withSuffix(".pdf");
        this.dviFile = this.withSuffix(".dvi");
        this.xdvFile = this.withSuffix(".xdv");
        this.logFile = this.withSuffix(".log");
        this.idxFile = this.withSuffix(".idx");
        this.indFile = this.withSuffix(".ind");
        this.ilgFile = this.withSuffix(".ilg");
        this.glsFile = this.withSuffix(".gls");
        this.glgFile = this.withSuffix(".glg");
        this.parentDir = this.texFile.getParentFile();
        this.aux2fileId = new EnumMap<Auxiliary, FileId>(Auxiliary.class);
    }

    Optional<String> groupMatch(LatexMainParameterNames groupName) {
        return Optional.ofNullable(this.matchRes.group(groupName.toString()));
    }

    boolean groupMatches(LatexMainParameterNames groupName) {
        return this.matchRes.group(groupName.toString()) != null;
    }

    String getDocClass() {
        String res = this.matchRes.group(LatexMainParameterNames.docClass.toString());
        assert (res != null);
        return res;
    }

    File withSuffix(String suffix) {
        return TexFileUtils.appendSuffix(this.xxxFile, suffix);
    }

    @Override
    public int compareTo(LatexMainDesc other) {
        return this.texFile.compareTo(other.texFile);
    }

    public String toString() {
        return "<LatexMainDesc texFile='" + this.texFile.getName() + "'>" + String.valueOf(this.matchRes) + "</LatexMainDesc>";
    }
}

