/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.FileId;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexProcessor;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class Auxiliary
extends Enum<Auxiliary> {
    public static final /* enum */ Auxiliary BibTex = new Auxiliary(){

        @Override
        String extension() {
            return ".aux";
        }

        @Override
        boolean doesFitAuxiliary(File file) {
            return this.doesFitAuxiliary(file, PATTERN_NEED_BIBTEX_RUN);
        }

        @Override
        int numRunsAfter() {
            return 2;
        }

        @Override
        FileId getIdent(File file) throws IOException {
            return this.updateIdentInclude(file, new FileId(), PATTERN_BIBTEX);
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runBibtex(desc);
        }
    };
    public static final /* enum */ Auxiliary Idx = new Auxiliary(){

        @Override
        String extension() {
            return ".idx";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeSplitIndex(desc);
        }
    };
    public static final /* enum */ Auxiliary Glo = new Auxiliary(){

        @Override
        String extension() {
            return ".aux";
        }

        @Override
        boolean doesFitAuxiliary(File file) {
            return this.doesFitAuxiliary(file, PATTERN_NEED_MAKEGLOSSARIES_RUN);
        }

        @Override
        FileId getIdent(File file) throws IOException {
            return this.updateIdentGls(file, new FileId());
        }

        FileId updateIdentGls(File file, FileId fileId) throws IOException {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    Matcher matcher = PATTERN_INPUT_GLOSSARY.matcher((CharSequence)line);
                    if (matcher.find()) {
                        fileId.update(line);
                        File glossFile = TexFileUtils.replaceSuffix(file, "." + matcher.group(Auxiliary.GRP_EXT_GLOSS));
                        System.out.println("gloss File: " + glossFile);
                        this.updateIdent(glossFile, fileId);
                    }
                    line = bufferedReader.readLine();
                }
            }
            return fileId;
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeGlossary(desc);
        }
    };
    public static final /* enum */ Auxiliary Pyt = new Auxiliary(){

        @Override
        String extension() {
            return ".pytxcode";
        }

        @Override
        boolean mayBeEntryInToc() {
            return false;
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runPythontex(desc);
        }
    };
    private static final Pattern PATTERN_NEED_BIBTEX_RUN;
    private static final Pattern PATTERN_NEED_MAKEGLOSSARIES_RUN;
    private static final Pattern PATTERN_INPUT;
    private static final String GRP_INPUT = "fileName";
    private static final Pattern PATTERN_INPUT_GLOSSARY;
    private static final String GRP_EXT_GLOSS = "fileExt";
    static final Pattern PATTERN_BIBTEX;
    private static final /* synthetic */ Auxiliary[] $VALUES;

    public static Auxiliary[] values() {
        return (Auxiliary[])$VALUES.clone();
    }

    public static Auxiliary valueOf(String name) {
        return Enum.valueOf(Auxiliary.class, name);
    }

    abstract String extension();

    boolean doesFitAuxiliary(File file) {
        return file.exists();
    }

    boolean mayBeEntryInToc() {
        return true;
    }

    int numRunsAfter() {
        return 1;
    }

    abstract boolean process(LatexMainDesc var1, LatexProcessor var2) throws BuildFailureException;

    FileId getIdent(File file) throws IOException {
        return this.updateIdent(file, new FileId());
    }

    FileId updateIdent(File file, FileId fileId) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line = bufferedReader.readLine();
            while (line != null) {
                fileId.update(line);
                line = bufferedReader.readLine();
            }
        }
        return fileId;
    }

    FileId updateIdentInclude(File file, FileId fileId, Pattern patternAux) throws IOException {
        File parent = file.getParentFile();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line = bufferedReader.readLine();
            while (line != null) {
                if (patternAux.matcher((CharSequence)line).find()) {
                    fileId.update(line);
                } else {
                    Matcher matcher = PATTERN_INPUT.matcher((CharSequence)line);
                    if (matcher.find()) {
                        String inFile = matcher.group(GRP_INPUT);
                        assert (inFile.endsWith(this.extension()));
                        this.updateIdentInclude(new File(parent, inFile), fileId, patternAux);
                    }
                }
                line = bufferedReader.readLine();
            }
        }
        return fileId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doesFitAuxiliary(File file, Pattern pattern) {
        if (!file.exists()) {
            return false;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line = bufferedReader.readLine();
            while (line != null) {
                if (pattern.matcher((CharSequence)line).find()) {
                    boolean bl = true;
                    return bl;
                }
                line = bufferedReader.readLine();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    private static /* synthetic */ Auxiliary[] $values() {
        return new Auxiliary[]{BibTex, Idx, Glo, Pyt};
    }

    static {
        $VALUES = Auxiliary.$values();
        PATTERN_NEED_BIBTEX_RUN = Pattern.compile((String)"^\\\\bibdata");
        PATTERN_NEED_MAKEGLOSSARIES_RUN = Pattern.compile((String)"^\\\\@istfilename");
        PATTERN_INPUT = Pattern.compile((String)"^\\\\@input\\{(?<fileName>.*)\\}");
        PATTERN_INPUT_GLOSSARY = Pattern.compile((String)"\\\\@newglossary\\{.+\\}\\{.+\\}\\{.+\\}\\{(?<fileExt>.*)\\}");
        PATTERN_BIBTEX = Pattern.compile((String)"^\\\\(citation|bibstyle|bibdata)");
    }
}

