/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.FileId;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum Auxiliary {
    BibTex{

        @Override
        String extension() {
            return ".aux";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean doesFitAuxiliary(File file) {
            if (!file.exists()) {
                return false;
            }
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    if (PATTERN_NEED_BIBTEX_RUN.matcher((CharSequence)line).find()) {
                        boolean bl = true;
                        return bl;
                    }
                    line = bufferedReader.readLine();
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                return true;
            }
        }

        @Override
        int numRunsAfter() {
            return 2;
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runBibtex(desc);
        }

        @Override
        FileId update(File file) throws IOException {
            return this.update(file, new FileId(), PATTERN_BIBTEX);
        }

        private FileId update(File file, FileId fileId, Pattern patternAux) throws IOException {
            File parent = file.getParentFile();
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    if (patternAux.matcher((CharSequence)line).find()) {
                        fileId.update(line);
                    } else {
                        Matcher matcher = PATTERN_INPUT.matcher((CharSequence)line);
                        if (matcher.find()) {
                            String inFile = matcher.group(Auxiliary.GRP_INPUT);
                            assert (inFile.endsWith(this.extension()));
                            this.update(new File(parent, inFile), fileId, patternAux);
                        }
                    }
                    line = bufferedReader.readLine();
                }
            }
            return fileId;
        }
    }
    ,
    Idx{

        @Override
        String extension() {
            return ".idx";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeSplitIndex(desc);
        }
    }
    ,
    Glo{

        @Override
        String extension() {
            return ".glo";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeGlossary(desc);
        }
    }
    ,
    Pyt{

        @Override
        String extension() {
            return ".pytxcode";
        }

        @Override
        boolean mayBeEntryInToc() {
            return false;
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runPythontex(desc);
        }
    };

    private static final Pattern PATTERN_NEED_BIBTEX_RUN;
    private static final Pattern PATTERN_INPUT;
    private static final String GRP_INPUT = "fileName";
    static final Pattern PATTERN_BIBTEX;

    abstract String extension();

    boolean doesFitAuxiliary(File file) {
        return file.exists();
    }

    boolean mayBeEntryInToc() {
        return true;
    }

    int numRunsAfter() {
        return 1;
    }

    abstract boolean process(LatexMainDesc var1, LatexProcessor var2) throws BuildFailureException;

    FileId update(File file) throws IOException {
        FileId fileId = new FileId();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line = bufferedReader.readLine();
            while (line != null) {
                fileId.update(line);
                line = bufferedReader.readLine();
            }
        }
        return fileId;
    }

    static {
        PATTERN_NEED_BIBTEX_RUN = Pattern.compile((String)"^\\\\bibdata");
        PATTERN_INPUT = Pattern.compile((String)"^\\\\@input\\{(?<fileName>.*)\\}");
        PATTERN_BIBTEX = Pattern.compile((String)"^\\\\(citation|bibstyle|bibdata)");
    }
}

