/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileId {
    private static final String ALGORITHM = "MD5";
    private int numLines;
    private MessageDigest md;

    FileId() {
        try {
            this.md = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Algorithm MD5 should be known. ");
        }
        this.numLines = 0;
    }

    void update(String line) {
        ++this.numLines;
        this.md.update(line.getBytes());
    }

    FileId finalizFileId() {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileId)) {
            return false;
        }
        FileId other = (FileId)obj;
        return this.numLines == other.numLines && new String(this.md.digest()).equals(new String(other.md.digest()));
    }

    public String toString() {
        return new String(this.md.digest()) + " " + this.numLines;
    }
}

