/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.Auxiliary;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicInteger;

public class FileId {
    private static final String ALGORITHM = "MD5";
    private int numLines;
    private String hash;
    private MessageDigest md;

    FileId() {
        try {
            this.md = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Algorithm MD5 should be known. ");
        }
        this.numLines = 0;
    }

    void update(String line) {
        ++this.numLines;
        this.md.update(line.getBytes());
    }

    FileId(File file, Auxiliary aux) {
        assert (!file.isDirectory());
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            AtomicInteger numLines = new AtomicInteger(0);
            try {
                aux.update(file, md, numLines);
                this.hash = new String(md.digest());
                this.numLines = numLines.get();
            }
            catch (IOException ioe) {
                System.out.println("Risk to drop necessary rerun is augmented. ");
                this.hash = "";
                this.numLines = 0;
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Algorithm MD5 should be known. ");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileId)) {
            return false;
        }
        FileId other = (FileId)obj;
        return this.numLines == other.numLines && new String(this.md.digest()).equals(new String(other.md.digest()));
    }

    public String toString() {
        return this.hash + " " + this.numLines;
    }
}

