/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.Auxiliary;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicInteger;

public class FileId {
    final AtomicInteger numLines;
    final String hash;

    FileId(File file, Auxiliary aux) {
        assert (!file.isDirectory());
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            this.numLines = new AtomicInteger(0);
            if (aux.update(file, md, this.numLines)) {
                this.hash = new String(md.digest());
            } else {
                System.out.println("EMPTY HASH IO");
                this.hash = "";
                this.numLines.setPlain(0);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Algorithm should be known. ");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileId)) {
            return false;
        }
        FileId other = (FileId)obj;
        return this.numLines == other.numLines && this.hash.equals(other.hash);
    }

    public String toString() {
        return this.hash + " " + this.numLines;
    }
}

