/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.Auxiliary;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileId {
    final long length;
    final String hash;

    FileId(File file, Auxiliary aux) {
        assert (!file.isDirectory());
        this.length = file.length();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (aux.update(file, md)) {
                this.hash = new String(md.digest());
            } else {
                System.out.println("EMPTY HASH IO");
                this.hash = "";
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Algorithm should be known. ");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileId)) {
            return false;
        }
        FileId other = (FileId)obj;
        return this.length == other.length && this.hash.equals(other.hash);
    }

    public String toString() {
        return this.hash + " " + this.length;
    }
}

