/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileId {
    final long length;
    final String hash;

    FileId(File file) {
        assert (!file.isDirectory());
        this.length = file.length();
        String firstHash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    md.update(line.getBytes());
                    line = bufferedReader.readLine();
                }
                firstHash = new String(md.digest());
            }
            catch (IOException e) {
                System.out.println("EMPTY HASH IO");
                firstHash = "";
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Algorithm should be known. ");
        }
        this.hash = firstHash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileId)) {
            return false;
        }
        FileId other = (FileId)obj;
        return this.length == other.length && this.hash.equals(other.hash);
    }

    public String toString() {
        return this.hash + " " + this.length;
    }
}

