/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileId {
    final long length;
    final String hash;

    FileId(File file) {
        assert (!file.isDirectory());
        this.length = file.length();
        String firstHash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (FileInputStream fis = new FileInputStream(file);){
                byte[] dataBytes = new byte[1024];
                int nread = 0;
                while ((nread = fis.read(dataBytes)) != -1) {
                    md.update(dataBytes, 0, nread);
                }
                firstHash = md.toString();
            }
            catch (IOException e) {
                firstHash = "";
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            firstHash = "";
        }
        this.hash = firstHash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileId)) {
            return false;
        }
        FileId other = (FileId)obj;
        return this.length == other.length && this.hash.equals(other.hash);
    }
}

