/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum Auxiliary {
    BibTex{

        @Override
        String extension() {
            return ".aux";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean doesFitAuxiliary(File file) {
            boolean exists = file.exists();
            if (!exists) {
                return false;
            }
            Pattern pattern = Pattern.compile((String)"^\\\\bibdata", (int)8);
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    Matcher matcher = pattern.matcher((CharSequence)line);
                    if (matcher.find()) {
                        boolean bl = true;
                        return bl;
                    }
                    line = bufferedReader.readLine();
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                return true;
            }
        }

        @Override
        int numRunsAfter() {
            return 2;
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runBibtex(desc);
        }
    }
    ,
    Idx{

        @Override
        String extension() {
            return ".idx";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeSplitIndex(desc);
        }
    }
    ,
    Glo{

        @Override
        String extension() {
            return ".glo";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeGlossary(desc);
        }
    }
    ,
    Pyt{

        @Override
        String extension() {
            return ".pytxcode";
        }

        @Override
        boolean mayBeEntryInToc() {
            return false;
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runPythontex(desc);
        }
    };


    abstract String extension();

    boolean doesFitAuxiliary(File file) {
        return file.exists();
    }

    boolean mayBeEntryInToc() {
        return true;
    }

    int numRunsAfter() {
        return 1;
    }

    abstract boolean process(LatexMainDesc var1, LatexProcessor var2) throws BuildFailureException;
}

