/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexProcessor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum Auxiliary {
    BibTex{

        @Override
        String extension() {
            return ".aux";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runBibtex(desc);
        }
    }
    ,
    Idx{

        @Override
        String extension() {
            return ".idx";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeSplitIndex(desc);
        }
    }
    ,
    Glo{

        @Override
        String extension() {
            return ".glo";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runMakeGlossary(desc);
        }
    }
    ,
    Pyt{

        @Override
        String extension() {
            return ".pytxcode";
        }

        @Override
        boolean process(LatexMainDesc desc, LatexProcessor proc) throws BuildFailureException {
            return proc.runPythontex(desc);
        }
    };


    abstract String extension();

    abstract boolean process(LatexMainDesc var1, LatexProcessor var2) throws BuildFailureException;
}

