/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import eu.simuline.m2latex.core.AbstractLatexProcessor;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.Converter;
import eu.simuline.m2latex.core.ConverterCategory;
import eu.simuline.m2latex.core.DirNode;
import eu.simuline.m2latex.core.FileMatch;
import eu.simuline.m2latex.core.Injection;
import eu.simuline.m2latex.core.LatexDev;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexMainParameterNames;
import eu.simuline.m2latex.core.LatexPreProcessor;
import eu.simuline.m2latex.core.LogWrapper;
import eu.simuline.m2latex.core.MetaInfo;
import eu.simuline.m2latex.core.ParameterAdapter;
import eu.simuline.m2latex.core.Settings;
import eu.simuline.m2latex.core.Target;
import eu.simuline.m2latex.core.TargetsContext;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class LatexProcessor
extends AbstractLatexProcessor {
    static final String PATTERN_NEED_BIBTEX_RUN = "^\\\\bibdata";
    static final String PATTERN_OUFULL_HVBOX = "^(Ov|Und)erfull \\\\[hv]box \\(";
    static final String SUFFIX_TOC = ".toc";
    static final String SUFFIX_LOF = ".lof";
    static final String SUFFIX_LOT = ".lot";
    static final String SUFFIX_LOL = ".lol";
    static final String SUFFIX_AUX = ".aux";
    static final String SUFFIX_DVI = ".dvi";
    static final String SUFFIX_XDV = ".xdv";
    static final String SUFFIX_BLG = ".blg";
    static final String SUFFIX_BBL = ".bbl";
    static final String SUFFIX_IDX = ".idx";
    static final String SUFFIX_IND = ".ind";
    static final String SUFFIX_ILG = ".ilg";
    static final String SUFFIX_GLO = ".glo";
    static final String SUFFIX_GLS = ".gls";
    static final String SUFFIX_GLG = ".glg";
    static final String SUFFIX_PYC = ".pytxcode";
    static final String SUFFIX_PLG = ".plg";
    private static final String SUFFIX_PYTXMCR = ".pytxmcr";
    private static final String SUFFIX_RTF = ".rtf";
    private static final String SUFFIX_ODT = ".odt";
    static final String SUFFIX_HTML = ".html";
    private static final String SUFFIX_TXT = ".txt";
    private static final String SUFFIX_CLG = ".clg";
    private static final String IDX_EXPL = "^(\\\\indexentry)\\[([^]]*)\\](.*)$";
    private static final int GRP_IDENT_IDX = 2;
    private static final String IMPL_IDENT_IDX = "idx";
    private static final String SEP_IDENT_IDX = "-";
    private final ParameterAdapter paramAdapt;
    private final LatexPreProcessor preProc;
    private final MetaInfo metaInfo;
    private Optional<String> latex2PdfCmdMagic = Optional.empty();
    private static final String FOLDER_INJ = "injections/";

    LatexProcessor(Settings settings, CommandExecutor executor, LogWrapper log, TexFileUtils fileUtils, ParameterAdapter paramAdapt) {
        super(settings, executor, log, fileUtils);
        this.paramAdapt = paramAdapt;
        this.preProc = new LatexPreProcessor(this.settings, this.executor, this.log, this.fileUtils);
        this.metaInfo = new MetaInfo(this.executor, this.log);
        this.latex2PdfCmdMagic = Optional.empty();
    }

    public LatexProcessor(Settings settings, LogWrapper log, ParameterAdapter paramAdapt) {
        this(settings, new CommandExecutor(log), log, new TexFileUtils(log), paramAdapt);
    }

    Set<Target> getTargetsForBuild(LatexMainDesc desc, Map<String, Set<Target>> docClasses2Targets, SortedSet<Target> targetSet) throws BuildFailureException {
        Optional<String> targetsMagic = desc.groupMatch(LatexMainParameterNames.targetsMagic);
        if (targetsMagic.isPresent()) {
            this.log.info("Magic comment 'targets=" + targetsMagic.get() + "' overrides settings. ");
            return Settings.getTargets(targetsMagic.get(), TargetsContext.targetsMagic);
        }
        String docClass = desc.getDocClass();
        Set<Target> possibleTargets = docClasses2Targets.get(docClass);
        if (possibleTargets == null) {
            this.log.warn("WLP09: For file '" + desc.texFile + "' targets are not restricted by document class '" + docClass + "'. ");
            return targetSet;
        }
        TreeSet<Target> unreachableTargets = new TreeSet<Target>(targetSet);
        unreachableTargets.removeAll(possibleTargets);
        if (!unreachableTargets.isEmpty()) {
            this.log.info("Skipping targets " + unreachableTargets + ". ");
        }
        TreeSet<Target> reachableTargets = new TreeSet<Target>(targetSet);
        reachableTargets.retainAll(possibleTargets);
        return reachableTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(SortedSet<Target> targetSet) throws BuildFailureException {
        Object object;
        this.paramAdapt.initialize();
        this.log.info("-----------create-------------");
        this.log.debug("Settings: " + this.settings.toString());
        Map<String, Set<Target>> docClasses2Targets = this.settings.getDocClassesToTargets();
        File texDir = this.settings.getTexSrcDirectoryFile();
        assert (texDir.exists() && texDir.isDirectory()) : "Expected existing tex folder " + texDir;
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texDir;
        DirNode node = new DirNode(texProcDir, this.fileUtils);
        try {
            Collection<LatexMainDesc> latexMainDescs = this.preProc.processGraphicsSelectMain(texProcDir, node, this.settings.getLatexmkUsage().preProcessInternally());
            for (LatexMainDesc desc : latexMainDescs) {
                File texFile = desc.texFile;
                this.log.info("Processing  LaTeX file '" + desc.texFile + "'. ");
                File targetDir = this.fileUtils.getTargetDirectory(texFile, texDir, this.settings.getOutputDirectoryFile());
                assert (!targetDir.exists() || targetDir.isDirectory()) : "Expected target folder " + targetDir + " folder if exists. ";
                Set<Target> targetsForBuild = this.getTargetsForBuild(desc, docClasses2Targets, targetSet);
                this.latex2PdfCmdMagic = desc.groupMatch(LatexMainParameterNames.programMagic);
                if (this.latex2PdfCmdMagic.isPresent() && !this.latex2PdfCmdMagic.get().equals(this.settings.getCommand(ConverterCategory.LaTeX))) {
                    this.log.info("Magic comment 'program=" + this.latex2PdfCmdMagic.get() + "' overrides settings.");
                }
                for (Target target : targetsForBuild) {
                    Optional<Object> pdfFileCmpOpt = Optional.empty();
                    Optional<MetadataDesc> metaDataDescOpt = Optional.empty();
                    if (target.hasDiffTool() && this.isChkDiff(desc)) {
                        File pdfFileCmp = TexFileUtils.getPdfFileDiff(desc.pdfFile, this.settings.getTexSrcDirectoryFile(), this.settings.getDiffDirectoryFile().getAbsoluteFile());
                        this.log.debug(String.format("cmp file %s", pdfFileCmp));
                        if (pdfFileCmp.exists()) {
                            long ts = this.runPdfInfo(pdfFileCmp);
                            System.out.println("++pdf TS meta: " + ts);
                            System.out.println("++pdf TS file: " + pdfFileCmp.lastModified() / 1000L);
                            pdfFileCmpOpt = Optional.of(pdfFileCmp);
                            metaDataDescOpt = Optional.of(new MetadataDesc(pdfFileCmp));
                            assert (pdfFileCmpOpt.isPresent());
                        } else {
                            metaDataDescOpt = Optional.of(new MetadataDesc());
                        }
                    }
                    target.processSource(this, desc, metaDataDescOpt, pdfFileCmpOpt.flatMap(file -> Optional.of(file.lastModified())));
                    FileFilter fileFilter = TexFileUtils.getFileFilter(texFile, target.getPatternOutputFiles(this.settings), false);
                    Set<File> targetFiles = this.fileUtils.copyOutputToTargetFolder(texFile, fileFilter, targetDir);
                    if (pdfFileCmpOpt.isEmpty()) {
                        this.log.debug("no artifact diff specified.");
                        continue;
                    }
                    File pdfFileCmp = (File)pdfFileCmpOpt.get();
                    if (!pdfFileCmp.exists()) {
                        this.log.warn("XXXXTLP02: No file '" + pdfFileCmp + "' to compare with artifact from '" + texFile + "'. ");
                    }
                    this.log.debug("Prepare verification by diffing: ");
                    assert (targetFiles.size() == 1) : "Expected one target file, found " + targetFiles + ". ";
                    File pdfFileAct = targetFiles.iterator().next();
                    this.log.debug(String.format("act file %s", pdfFileAct));
                    assert (pdfFileAct.exists());
                    boolean coincide = this.runDiffPdf((File)pdfFileCmpOpt.get(), pdfFileAct);
                    if (coincide) {
                        this.log.info("Checked result: coincides with expected artifact. ");
                        continue;
                    }
                    throw new BuildFailureException("TLP01: Artifact '" + pdfFileAct.getName() + "' from '" + texFile + "' could not be reproduced. ");
                }
            }
            if (this.settings.isCleanUp()) {
                this.fileUtils.cleanUp(node, texProcDir);
            }
            object = this.settings.isCleanUp() ? "cleanup: " + texProcDir : "No cleanup";
        }
        catch (Throwable throwable) {
            if (this.settings.isCleanUp()) {
                this.fileUtils.cleanUp(node, texProcDir);
            }
            this.log.debug((String)(this.settings.isCleanUp() ? "cleanup: " + texProcDir : "No cleanup"));
            this.latex2PdfCmdMagic = Optional.empty();
            throw throwable;
        }
        this.log.debug((String)object);
        this.latex2PdfCmdMagic = Optional.empty();
    }

    private boolean isChkDiff(LatexMainDesc desc) {
        boolean chkDiff;
        boolean chkDiffSetting = this.settings.isChkDiff();
        if (!desc.groupMatches(LatexMainParameterNames.chkDiffMagic)) {
            return chkDiffSetting;
        }
        Optional<String> chkDiffValue = desc.groupMatch(LatexMainParameterNames.chkDiffMagicVal);
        boolean bl = chkDiff = chkDiffValue.isEmpty() ? true : Boolean.parseBoolean(chkDiffValue.get());
        if (chkDiff != chkDiffSetting) {
            this.log.info("Magic comment 'chkDiff=" + chkDiff + "' overrides setting.");
        }
        return chkDiff;
    }

    private boolean isCompileWithLatexmk(LatexMainDesc desc) {
        boolean runLatexmk;
        boolean runLatexmkSetting = this.settings.getLatexmkUsage().runLatexmk();
        if (!desc.groupMatches(LatexMainParameterNames.latexmkMagic)) {
            return runLatexmkSetting;
        }
        Optional<String> runLatexmkValue = desc.groupMatch(LatexMainParameterNames.latexmkMagicVal);
        boolean bl = runLatexmk = runLatexmkValue.isEmpty() ? true : Boolean.parseBoolean(runLatexmkValue.get());
        if (runLatexmk != runLatexmkSetting) {
            this.log.info("Magic comment 'latexmk=" + runLatexmk + "' overrides settings. ");
        }
        return runLatexmk;
    }

    public void processGraphics() throws BuildFailureException {
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texProcDir;
        DirNode node = new DirNode(texProcDir, this.fileUtils);
        this.preProc.processGraphicsSelectMain(texProcDir, node, true);
    }

    public void clearAll() throws BuildFailureException {
        this.paramAdapt.initialize();
        this.log.debug("Settings: " + this.settings.toString());
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texProcDir;
        this.preProc.clearCreated(texProcDir);
        this.clearInjFiles();
    }

    public String getLatex2pdfCommand() throws BuildFailureException {
        return this.latex2PdfCmdMagic.orElse(this.settings.getCommand(ConverterCategory.LaTeX));
    }

    private String getDvi2pdfCommand() throws BuildFailureException {
        return this.settings.getCommand(ConverterCategory.Dvi2Pdf);
    }

    private int preProcessLatex2dev(LatexMainDesc desc, LatexDev dev, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        this.runLatex2dev(desc, dev, metaDataDescOpt, timestampOpt);
        boolean hasBib = this.runBibtexByNeed(desc);
        boolean hasIdxGls = this.runMakeIndexByNeed(desc) | this.runMakeGlossaryByNeed(desc);
        boolean hasPyCode = this.runPythontexByNeed(desc);
        if (hasBib) {
            return 2;
        }
        boolean hasToc = desc.withSuffix(SUFFIX_TOC).exists();
        if (hasIdxGls) {
            return hasToc ? 2 : 1;
        }
        boolean needLatexReRun = hasToc || hasPyCode || desc.withSuffix(SUFFIX_LOF).exists() || desc.withSuffix(SUFFIX_LOT).exists() || desc.withSuffix(SUFFIX_LOL).exists();
        return needLatexReRun ? 1 : 0;
    }

    private void processLatex2devCore(LatexMainDesc desc, LatexDev dev, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        int numLatexReRuns = this.preProcessLatex2dev(desc, dev, metaDataDescOpt, timestampOpt);
        String latexCmd = this.getLatex2pdfCommand();
        assert (numLatexReRuns == 0 || numLatexReRuns == 1 || numLatexReRuns == 2);
        if (numLatexReRuns > 0) {
            this.log.debug("Rerun " + latexCmd + " to update table of contents, ... bibliography, index, or that like. ");
            this.runLatex2dev(desc, dev, metaDataDescOpt, timestampOpt);
            --numLatexReRuns;
        }
        assert (numLatexReRuns == 0 || numLatexReRuns == 1);
        boolean needLatexReRun = numLatexReRuns == 1 || this.needRun(true, latexCmd, desc.logFile, this.settings.getPatternReRunLatex());
        int maxNumReruns = this.settings.getMaxNumReRunsLatex();
        for (int num = 0; maxNumReruns == -1 || num < maxNumReruns; ++num) {
            boolean needMakeIndexReRun = this.needRun(true, this.settings.getCommand(ConverterCategory.MakeIndex), desc.logFile, this.settings.getPatternReRunMakeIndex());
            if (!(needLatexReRun |= needMakeIndexReRun)) {
                return;
            }
            this.log.debug("Latex must be rerun. ");
            if (needMakeIndexReRun) {
                this.runMakeIndexByNeed(desc);
            }
            this.runLatex2dev(desc, dev, metaDataDescOpt, timestampOpt);
            needLatexReRun = this.needRun(true, latexCmd, desc.logFile, this.settings.getPatternReRunLatex());
        }
        this.log.warn("WLP01: LaTeX requires rerun but maximum number " + maxNumReruns + " reached. ");
    }

    private boolean needRun(boolean another, String cmdStr, File logAuxFile, String pattern) {
        FileMatch fileMatch = this.fileUtils.getMatchInFile(logAuxFile, pattern);
        if (fileMatch.isFileReadable()) {
            return fileMatch.doesExprMatch();
        }
        this.log.warn("WLP02: Cannot read " + TexFileUtils.getSuffix(logAuxFile, false) + " file '" + logAuxFile.getName() + "'; " + cmdStr + " may require " + (another ? "re" : "") + "run. ");
        return false;
    }

    private void processLatex2dev(LatexMainDesc desc, LatexDev dev, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        this.processLatex2devCore(desc, dev, metaDataDescOpt, timestampOpt);
        this.logWarns(desc.logFile, this.getLatex2pdfCommand());
    }

    void processLatex2dvi(LatexMainDesc desc, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        this.log.info("Converting into dvi/xdv format. ");
        this.processLatex2dev(desc, LatexDev.dvips, metaDataDescOpt, timestampOpt);
    }

    void processLatex2pdf(LatexMainDesc desc, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        this.log.info("Converting into pdf format. ");
        if (this.isCompileWithLatexmk(desc)) {
            this.runLatexmk(desc, metaDataDescOpt, timestampOpt);
            return;
        }
        LatexDev dev = this.settings.getPdfViaDvi();
        this.processLatex2dev(desc, dev, metaDataDescOpt, timestampOpt);
        if (dev.isViaDvi()) {
            this.runDvi2pdf(desc, metaDataDescOpt, timestampOpt);
        }
    }

    private void logErrs(File logFile, String command) {
        this.logErrs(logFile, command, this.settings.getPatternErrLatex());
    }

    private void logWarns(File logFile, String command) {
        if (!logFile.exists()) {
            return;
        }
        if (this.settings.getDebugBadBoxes() && this.hasErrsWarns(logFile, PATTERN_OUFULL_HVBOX)) {
            this.log.warn("WLP03: Running " + command + " created bad boxes logged in '" + logFile.getName() + "'. ");
        }
        if (this.settings.getDebugWarnings() && this.hasErrsWarns(logFile, this.settings.getPatternWarnLatex())) {
            this.logWarn(logFile, command);
        }
    }

    void processLatex2html(LatexMainDesc desc, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        this.log.info("Converting into html format. ");
        this.preProcessLatex2dev(desc, LatexDev.devViaDvi(true), metaDataDescOpt, timestampOpt);
        this.runLatex2html(desc);
    }

    void processLatex2odt(LatexMainDesc desc, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        this.log.info("Converting into odt format. ");
        this.preProcessLatex2dev(desc, this.settings.getPdfViaDvi(), metaDataDescOpt, timestampOpt);
        this.runLatex2odt(desc);
    }

    void processLatex2docx(LatexMainDesc desc, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        this.log.info("Converting into doc(x) format. ");
        this.preProcessLatex2dev(desc, this.settings.getPdfViaDvi(), metaDataDescOpt, timestampOpt);
        this.runLatex2odt(desc);
        this.runOdt2doc(desc);
    }

    void processLatex2rtf(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into rtf format. ");
        this.runLatex2rtf(desc.texFile);
    }

    void processLatex2txt(LatexMainDesc desc, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestamp) throws BuildFailureException {
        this.log.info("Converting into txt format. ");
        LatexDev dev = this.settings.getPdfViaDvi();
        this.processLatex2devCore(desc, dev, metaDataDescOpt, timestamp);
        if (dev.isViaDvi()) {
            this.runDvi2pdf(desc, metaDataDescOpt, timestamp);
        }
        this.runPdf2txt(desc);
    }

    public boolean printMetaInfo(boolean includeVersionInfo) throws BuildFailureException {
        SortedSet<Converter> convertersExcluded = this.settings.getConvertersExcluded();
        return this.metaInfo.printMetaInfo(includeVersionInfo, convertersExcluded);
    }

    private boolean runBibtexByNeed(LatexMainDesc desc) throws BuildFailureException {
        File auxFile = desc.withSuffix(SUFFIX_AUX);
        String command = this.settings.getCommand(ConverterCategory.BibTeX);
        if (!this.needRun(false, command, auxFile, PATTERN_NEED_BIBTEX_RUN)) {
            return false;
        }
        this.log.debug("Running " + command + " on '" + auxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getBibtexOptions(), auxFile, new String[0]);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_BBL));
        File logFile = desc.withSuffix(SUFFIX_BLG);
        this.logErrs(logFile, command, this.settings.getPatternErrBibtex());
        this.logWarns(logFile, command, this.settings.getPatternWarnBibtex());
        return true;
    }

    private boolean runMakeIndexByNeed(LatexMainDesc desc) throws BuildFailureException {
        boolean needRun = desc.idxFile.exists();
        this.log.debug("MakeIndex run required? " + needRun);
        Collection<String> explIdxIdent = null;
        if (needRun && (explIdxIdent = this.fileUtils.collectMatches(desc.idxFile, IDX_EXPL, 2)) == null) {
            this.log.warn("WLP04: Cannot read idx file '" + desc.idxFile.getName() + "'; skip creation of index. ");
            return false;
        }
        assert (explIdxIdent != null == needRun);
        FileFilter filter = this.fileUtils.getFileFilterReplace(desc.idxFile, "-.+");
        File[] idxFilesExtInDir = this.fileUtils.listFilesOrWarn(desc.idxFile.getParentFile(), filter);
        assert (explIdxIdent != null == needRun);
        if (idxFilesExtInDir != null && idxFilesExtInDir.length > 0 && (explIdxIdent == null || explIdxIdent.isEmpty())) {
            this.log.warn("WLP05: Use package 'splitidx' without option 'split' in '" + desc.texFile.getName() + "'. ");
        }
        if (explIdxIdent != null) {
            if (explIdxIdent.isEmpty()) {
                this.runMakeIndex(desc);
            } else {
                this.runSplitIndex(desc, explIdxIdent);
            }
        }
        return needRun;
    }

    private void runMakeIndex(LatexMainDesc desc) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.MakeIndex);
        File idxFile = desc.idxFile;
        this.log.debug("Running " + command + " on '" + idxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getMakeIndexOptions(), idxFile, new String[0]);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.indFile);
        this.logErrs(desc.ilgFile, command, this.settings.getPatternErrMakeIndex());
        this.logWarns(desc.ilgFile, command, this.settings.getPatternWarnMakeIndex());
    }

    private File[] files(String filePrefix, Collection<String> variant, String suffix) {
        File[] res = new File[variant.size()];
        int idx = 0;
        for (String idxIdent : variant) {
            StringBuilder strb = new StringBuilder();
            strb.append(filePrefix);
            strb.append(idxIdent);
            strb.append(suffix);
            res[idx++] = new File(strb.toString());
        }
        return res;
    }

    private void runSplitIndex(LatexMainDesc desc, Collection<String> explIdxIdent) throws BuildFailureException {
        String splitInxCmd = this.settings.getCommand(ConverterCategory.SplitIndex);
        File idxFile = desc.idxFile;
        this.log.debug("Running " + splitInxCmd + " on '" + idxFile.getName() + "'. ");
        String[] argsDefault = new String[]{"-m " + this.settings.getCommand(ConverterCategory.MakeIndex), "-i ^(\\\\indexentry)\\[([^]]*)\\](.*)$", "-r $1$3", "-s -$2"};
        String argsOption = this.settings.getMakeIndexOptions();
        String[] args = argsOption.isEmpty() ? new String[argsDefault.length + 1] : new String[argsDefault.length + 2];
        System.arraycopy(argsDefault, 0, args, 0, argsDefault.length);
        if (!argsOption.isEmpty()) {
            args[args.length - 2] = argsOption;
        }
        args[args.length - 1] = desc.xxxFile.getName();
        String optionsMakeIndex = this.settings.getMakeIndexOptions();
        if (!optionsMakeIndex.isEmpty()) {
            String[] optionsMake_IndexArr = optionsMakeIndex.split(" ");
            String[] optionsSplitIndexArr = args;
            args = new String[optionsMake_IndexArr.length + 1 + optionsSplitIndexArr.length];
            System.arraycopy(optionsSplitIndexArr, 0, args, 0, optionsSplitIndexArr.length);
            args[optionsSplitIndexArr.length] = "--";
            System.arraycopy(optionsMake_IndexArr, 0, args, optionsSplitIndexArr.length + 1, optionsMake_IndexArr.length);
        }
        explIdxIdent.add(IMPL_IDENT_IDX);
        String filePrefix = desc.xxxFile.toString() + SEP_IDENT_IDX;
        File[] indFiles = this.files(filePrefix, explIdxIdent, SUFFIX_IND);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), splitInxCmd, args, indFiles);
        File[] ilgFiles = this.files(filePrefix, explIdxIdent, SUFFIX_ILG);
        splitInxCmd = this.settings.getCommand(ConverterCategory.MakeIndex);
        for (int idx = 0; idx < explIdxIdent.size(); ++idx) {
            this.logErrs(ilgFiles[idx], splitInxCmd, this.settings.getPatternErrMakeIndex());
            this.logWarns(ilgFiles[idx], splitInxCmd, this.settings.getPatternWarnMakeIndex());
        }
    }

    private boolean runMakeGlossaryByNeed(LatexMainDesc desc) throws BuildFailureException {
        boolean needRun = desc.gloFile.exists();
        this.log.debug("MakeGlossaries run required? " + needRun);
        if (!needRun) {
            return false;
        }
        File xxxFile = desc.xxxFile;
        String command = this.settings.getCommand(ConverterCategory.MakeGlossaries);
        this.log.debug("Running " + command + " on '" + xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getMakeGlossariesOptions(), xxxFile, new String[0]);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.glsFile);
        File glgFile = desc.glgFile;
        this.logErrs(glgFile, command, this.settings.getPatternErrMakeGlossaries());
        this.logWarns(glgFile, command, this.settings.getPatternWarnMakeIndex() + "|" + this.settings.getPatternWarnXindy());
        return true;
    }

    private boolean runPythontexByNeed(LatexMainDesc desc) throws BuildFailureException {
        boolean isDel;
        File pycFile = desc.withSuffix(SUFFIX_PYC);
        boolean needRun = pycFile.exists();
        this.log.debug("Pythontex run required? " + needRun);
        if (!needRun) {
            return false;
        }
        String command = this.settings.getCommand(ConverterCategory.Pythontex);
        this.log.debug("Running " + command + " on '" + pycFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getPythontexOptions(), desc.xxxFile, new String[0]);
        File outFolder = TexFileUtils.replacePrefix("pythontex-files-", desc.xxxFile);
        String repOutFileName = desc.xxxFile.getName() + SUFFIX_PYTXMCR;
        File repOutFile = new File(outFolder, repOutFileName);
        if (repOutFile.exists() && !(isDel = repOutFile.delete())) {
            this.log.warn("Preliminary warning: Could not delete '" + repOutFile + "'; this may cause further warnings/errors. ");
        }
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, repOutFile);
        File logFile = desc.withSuffix(SUFFIX_PLG);
        this.logErrs(logFile, command, this.settings.getPatternErrPyTex());
        this.logWarns(logFile, command, this.settings.getPatternWarnPyTex());
        return true;
    }

    private void runLatexmk(LatexMainDesc desc, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getLatexmkCommand();
        String[] args = LatexProcessor.buildLatexmkArguments(this.settings, desc);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        this.executor.executeBuild(desc.parentDir, this.settings.getTexPath(), command, args, desc.pdfFile);
    }

    protected static String[] buildLatexmkArguments(Settings settings, LatexMainDesc desc) throws BuildFailureException {
        ArrayList addArgs = new ArrayList();
        return LatexProcessor.buildArguments(settings.getLatexmkOptions(), desc.texFile, addArgs.toArray(new String[addArgs.size()]));
    }

    private void runLatex2dev(LatexMainDesc desc, LatexDev dev, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.getLatex2pdfCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        boolean isTypeXelatex = Converter.XeLatex.getCommand().equals(command);
        String[] args = LatexProcessor.buildLatexArguments(this.settings, dev, texFile, isTypeXelatex);
        this.executor.setTimestamp(metaDataDescOpt, timestampOpt);
        File latexTargetFile = dev.latexTargetFile(desc, isTypeXelatex);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, latexTargetFile);
        this.logErrs(desc.logFile, command);
        if (dev.setModTime()) {
            this.setModificationTime(latexTargetFile, metaDataDescOpt, timestampOpt);
        }
    }

    protected static String[] buildLatexArguments(Settings settings, LatexDev dev, File texFile, boolean isTypeXelatex) throws BuildFailureException {
        String options = settings.getLatex2pdfOptions();
        if (dev.isDefault()) {
            return LatexProcessor.buildArguments(options, texFile, new String[0]);
        }
        return LatexProcessor.buildArguments(options, texFile, new String[]{isTypeXelatex ? "-no-pdf" : "-output-format=" + dev.getLatexOutputFormat()});
    }

    private void runDvi2pdf(LatexMainDesc desc, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        assert (this.settings.getPdfViaDvi().isViaDvi());
        String command = this.getDvi2pdfCommand();
        if (desc.dviFile.exists() && desc.xdvFile.exists()) {
            this.log.warn("WLP07: Found both '" + desc.dviFile + "' and '" + desc.xdvFile + "'; convert the latter. ");
        }
        this.log.debug("Running " + command + " on '" + desc.xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getDvi2pdfOptions(), desc.xxxFile, new String[0]);
        this.executor.setTimestamp(metaDataDescOpt, timestampOpt);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.pdfFile);
        this.setModificationTime(desc.pdfFile, metaDataDescOpt, timestampOpt);
    }

    void setModificationTime(File file, Optional<MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) throws BuildFailureException {
        assert (timestampOpt.isEmpty() == metaDataDescOpt.isEmpty());
        if (!file.exists() || metaDataDescOpt.isEmpty()) {
            return;
        }
        MetadataDesc metadataDesc = metaDataDescOpt.get();
        long timestampMs = metadataDesc.hasTimestamp() ? metadataDesc.getLastModifiedTimeMs() : this.runPdfInfo(file) * 1000L;
        this.fileUtils.setModificationTime(file, timestampMs);
    }

    private void runLatex2html(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getTex4htCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildHtlatexArguments(this.settings, texFile);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_HTML));
        this.logErrs(desc.logFile, command);
        this.logWarns(desc.logFile, command);
    }

    protected static String[] buildHtlatexArguments(Settings settings, File texFile) {
        return new String[]{texFile.getName(), settings.getTex4htStyOptions(), settings.getTex4htOptions(), settings.getT4htOptions(), settings.getLatex2pdfOptions()};
    }

    private void runLatex2rtf(File texFile) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.LaTeX2Rtf);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getLatex2rtfOptions(), texFile, new String[0]);
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(texFile, SUFFIX_RTF));
    }

    private void runLatex2odt(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getTex4htCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = new String[]{texFile.getName(), "xhtml,ooffice", "ooffice/! -cmozhtf", "-coo -cvalidate"};
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_ODT));
        this.logErrs(desc.logFile, command);
        this.logWarns(desc.logFile, command);
    }

    private void runOdt2doc(LatexMainDesc desc) throws BuildFailureException {
        File odtFile = desc.withSuffix(SUFFIX_ODT);
        String command = this.settings.getCommand(ConverterCategory.Odt2Doc);
        this.log.debug("Running " + command + " on '" + odtFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getOdt2docOptions(), odtFile, new String[0]);
        String suffix = null;
        for (int idx = 0; idx < args.length - 1; ++idx) {
            if (!args[idx].startsWith("-f")) continue;
            assert (suffix == null);
            suffix = args[idx].substring(2, args[idx].length());
        }
        assert (suffix != null);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(suffix));
    }

    private void runPdf2txt(LatexMainDesc desc) throws BuildFailureException {
        File pdfFile = desc.withSuffix(".pdf");
        String command = this.settings.getCommand(ConverterCategory.Pdf2Txt);
        this.log.debug("Running " + command + " on '" + pdfFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getPdf2txtOptions(), pdfFile, new String[0]);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_TXT));
    }

    void processCheck(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Checking source. ");
        this.runCheck(desc);
    }

    private void runCheck(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        File clgFile = desc.withSuffix(SUFFIX_CLG);
        String command = this.settings.getCommand(ConverterCategory.LatexChk);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildChkTexArguments(this.settings.getChkTexOptions(), texFile, clgFile);
        CommandExecutor.CmdResult res = this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, CommandExecutor.ReturnCodeChecker.IsOne, args, clgFile);
        switch (res.returnCode) {
            case 0: {
                if (!clgFile.exists() || clgFile.length() == 0L) break;
                this.log.info("Checker '" + command + "' logged a message in '" + clgFile.getName() + "'. ");
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.log.error("ELP02: Checker '" + command + "' logged an error in '" + clgFile.getName() + "'. ");
                break;
            }
            case 2: {
                this.log.warn("WLP08: Checker '" + command + "' logged a warning in '" + clgFile.getName() + "'. ");
                break;
            }
            default: {
                this.log.error("ELP01: For command '" + command + "' found unexpected return code " + res.returnCode + ". ");
            }
        }
    }

    protected static String[] buildChkTexArguments(String options, File texFile, File clgFile) {
        return LatexProcessor.buildArguments(options, texFile, "-o", clgFile.getName());
    }

    boolean runDiffPdf(File pdfFileCmp, File pdfFileAct) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.DiffPdf);
        this.log.debug("Running " + command + " diffing '" + pdfFileCmp.getName() + "' and '" + pdfFileAct.getName() + "''. ");
        String[] args = new String[]{pdfFileCmp.toString(), pdfFileAct.toString()};
        int returnCode = this.executor.execute(null, (File)this.settings.getTexPath(), (String)command, (CommandExecutor.ReturnCodeChecker)CommandExecutor.ReturnCodeChecker.IsNotZeroOrOne, (String[])args, (File[])new File[0]).returnCode;
        return returnCode == 0;
    }

    long runPdfInfo(File pdfFile) throws BuildFailureException {
        System.out.println("pdfinfo on " + pdfFile);
        String command = this.settings.getCommand(ConverterCategory.MetaInfoPdf);
        this.log.debug("Running " + command + " extracting metainformation from '" + pdfFile.getName() + "''. ");
        String[] args = new String[]{this.settings.getPdfMetainfoOptions(), pdfFile.toString()};
        CommandExecutor.CmdResult res = this.executor.execute(null, this.settings.getTexPath(), command, CommandExecutor.ReturnCodeChecker.IsNonZero, args, new File[0]);
        System.out.println("pdfinfo yields\n" + res.output);
        Pattern pattern = Pattern.compile((String)"CreationDate:\\s*(?<creationDate>.*)\\R");
        Matcher matcher = pattern.matcher((CharSequence)res.output);
        if (!matcher.find()) {
            throw new RuntimeException("Found no creation date");
        }
        String creationDateIso8601 = matcher.group("creationDate");
        long epochTimeSec = Instant.parse(creationDateIso8601).getEpochSecond();
        return epochTimeSec;
    }

    public void processFileInjections(Set<Injection> injections) throws BuildFailureException {
        for (Injection inj : injections) {
            String fileName = inj.getFileName();
            InputStream inStream = MetaInfo.getStream(FOLDER_INJ + fileName);
            File outFile = this.settings.rcResourceToFile(fileName);
            try {
                if (!outFile.exists() || this.fileUtils.isCreatedByMyself(outFile, inj)) {
                    PrintStream writer = new PrintStream(outFile);
                    String version = this.metaInfo.getCoordinates().version;
                    this.settings.filterInjection(inStream, writer, version, inj);
                }
                inStream.close();
            }
            catch (IOException ioe) {
                throw new BuildFailureException("TLP03 Failure while writing file '" + fileName + "' or closing in-stream. ", ioe);
            }
            boolean success = outFile.setExecutable(inj.setExecutable(), false);
            assert (success || !inj.setExecutable());
        }
    }

    private void clearInjFiles() {
        for (Injection inj : Injection.values()) {
            File outFile = this.settings.rcResourceToFile(inj.getFileName());
            if (!outFile.exists() || !this.fileUtils.isCreatedByMyself(outFile, inj)) continue;
            this.fileUtils.deleteOrError(outFile, false);
        }
    }

    static class MetadataDesc {
        private final Optional<File> pdfFileCmpOpt;

        MetadataDesc(File pdfFileCmp) {
            this.pdfFileCmpOpt = Optional.of(pdfFileCmp);
        }

        MetadataDesc() {
            this.pdfFileCmpOpt = Optional.empty();
        }

        boolean hasTimestamp() {
            return this.pdfFileCmpOpt.isPresent();
        }

        long getLastModifiedTimeMs() {
            return this.pdfFileCmpOpt.get().lastModified();
        }
    }
}

