/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.LatexProcessor;
import eu.simuline.m2latex.core.LogWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

class CommandExecutor {
    private static final Map<String, String> TIMESTAMP_ENV = new TreeMap<String, String>();
    private static final String DATE_EPOCH = "SOURCE_DATE_EPOCH";
    private Optional<Long> timestampOpt = Optional.empty();
    private Optional<LatexProcessor.MetadataDesc> metaDataDescOpt = Optional.empty();
    private final LogWrapper log;

    CommandExecutor(LogWrapper log) {
        this.log = log;
    }

    CmdResult execute(File workingDir, File pathToExecutable, String command, String[] args, File ... resFiles) throws BuildFailureException {
        return this.execute(workingDir, pathToExecutable, command, ReturnCodeChecker.IsNonZero, args, resFiles);
    }

    CmdResult executeBuild(File workingDir, File pathToExecutable, String command, String[] args, File resFile) throws BuildFailureException {
        CmdResult res = this.execute(workingDir, pathToExecutable, command, args, new File[0]);
        this.existsOrErr(command, resFile);
        return res;
    }

    CmdResult execute(File workingDir, File pathToExecutable, String command, ReturnCodeChecker checker, String[] args, File ... resFiles) throws BuildFailureException {
        boolean[] existsTarget = new boolean[resFiles.length];
        Long[] lastModifiedTargetMs = new Long[resFiles.length];
        long currentTimeMs = System.currentTimeMillis();
        long minTimePastMs = Long.MAX_VALUE;
        for (int idx = 0; idx < resFiles.length; ++idx) {
            Long modTimeOrNull;
            existsTarget[idx] = resFiles[idx].exists();
            if (!existsTarget[idx]) continue;
            lastModifiedTargetMs[idx] = modTimeOrNull = this.modTimeOrNull(resFiles[idx]);
            if (modTimeOrNull == null) continue;
            assert (modTimeOrNull <= currentTimeMs);
            minTimePastMs = Math.min(minTimePastMs, currentTimeMs - modTimeOrNull);
        }
        if (minTimePastMs < 1001L) {
            try {
                Thread.sleep(1001L - minTimePastMs);
            }
            catch (InterruptedException ie) {
                this.log.warn("WEX05: Update control may emit false warnings. ");
            }
        }
        if (workingDir == null && resFiles.length != 0) {
            throw new IllegalStateException("Working directory shall be determined but was null. ");
        }
        CmdResult res = this.execute(workingDir, pathToExecutable, command, checker, args);
        for (int idx = 0; idx < resFiles.length; ++idx) {
            this.isUpdatedOrWarn(command, resFiles[idx], existsTarget[idx], lastModifiedTargetMs[idx]);
        }
        return res;
    }

    Long modTimeOrNull(File file) {
        try {
            FileTime fTime = Files.getLastModifiedTime(file.toPath(), LinkOption.NOFOLLOW_LINKS);
            return fTime.to(TimeUnit.MILLISECONDS);
        }
        catch (IOException ioe) {
            this.log.warn("WEX04: Cannot read target file '" + file.getName() + "'; may be outdated. ");
            return null;
        }
    }

    private boolean existsOrErr(String command, File target) {
        if (!target.exists()) {
            this.log.error("EEX02: Running " + command + " failed: No target file '" + target.getName() + "' written. ");
            return false;
        }
        return true;
    }

    private boolean isUpdatedOrWarn(String command, File target, boolean existedBefore, Long lastModifiedBefore) {
        if (!this.existsOrErr(command, target)) {
            return false;
        }
        assert (target.exists());
        if (!existedBefore) {
            return true;
        }
        assert (existedBefore && target.exists());
        if (lastModifiedBefore == null) {
            return false;
        }
        Long lastModifiedAfter = this.modTimeOrNull(target);
        if (lastModifiedAfter == null) {
            return false;
        }
        if (lastModifiedAfter <= lastModifiedBefore) {
            assert (lastModifiedAfter == lastModifiedBefore);
            this.log.error("EEX03: Running " + command + " failed: Target file '" + target.getName() + "' is not updated. ");
            return false;
        }
        return true;
    }

    void setTimestamp(Optional<LatexProcessor.MetadataDesc> metaDataDescOpt, Optional<Long> timestampOpt) {
        this.metaDataDescOpt = metaDataDescOpt;
        this.timestampOpt = timestampOpt;
    }

    private CmdResult execute(File workingDir, File pathToExecutable, String command, ReturnCodeChecker checker, String[] args) throws BuildFailureException {
        String executable = new File(pathToExecutable, command).getPath();
        Commandline cl = new Commandline(executable);
        cl.getShell().setQuotedArgumentsEnabled(true);
        assert (this.timestampOpt.isPresent() == this.metaDataDescOpt.isPresent());
        if (this.timestampOpt.isPresent()) {
            long timestampMs = this.timestampOpt.get();
            this.log.info("Run with timestamp " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss UTC").format(new Date(timestampMs)) + "(" + timestampMs + "ms)");
            TIMESTAMP_ENV.put(DATE_EPOCH, Long.toString(timestampMs / 1000L));
            for (Map.Entry<String, String> entry : TIMESTAMP_ENV.entrySet()) {
                cl.addEnvironment(entry.getKey(), entry.getValue());
            }
            this.timestampOpt = Optional.empty();
        }
        cl.addArguments(args);
        if (workingDir != null) {
            cl.setWorkingDirectory(workingDir.getPath());
        }
        CommandLineUtils.StringStreamConsumer output = new CommandLineUtils.StringStreamConsumer();
        this.log.debug("Executing: " + cl + " in: " + workingDir + ". ");
        int returnCode = -1;
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)output, (StreamConsumer)output);
            if (checker.hasFailed(returnCode)) {
                this.log.error("EEX01: Running " + command + " failed with return code " + returnCode + ". ");
            }
        }
        catch (CommandLineException e) {
            throw new BuildFailureException("TEX01: Error running " + command + ". ", e);
        }
        this.log.debug("Output:\n" + output.getOutput() + "\n");
        return new CmdResult(output.getOutput(), checker, returnCode);
    }

    static {
        TIMESTAMP_ENV.put("FORCE_SOURCE_DATE", "1");
        TIMESTAMP_ENV.put("TZ", "utc");
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum ReturnCodeChecker {
        Never{

            @Override
            boolean hasFailed(int returnCode) {
                return false;
            }
        }
        ,
        IsNonZero{

            @Override
            boolean hasFailed(int returnCode) {
                return returnCode != 0;
            }
        }
        ,
        IsOne{

            @Override
            boolean hasFailed(int returnCode) {
                return returnCode == 1;
            }
        }
        ,
        IsNotZeroOrOne{

            @Override
            boolean hasFailed(int returnCode) {
                return returnCode == 1;
            }
        };


        abstract boolean hasFailed(int var1);
    }

    static class CmdResult {
        final String output;
        private final ReturnCodeChecker checker;
        final int returnCode;

        CmdResult(String output, ReturnCodeChecker checker, int returnCode) {
            this.output = output;
            this.checker = checker;
            this.returnCode = returnCode;
        }

        boolean getSuccess() {
            return !this.checker.hasFailed(this.returnCode);
        }

        public String toString() {
            StringBuilder res = new StringBuilder();
            res.append("<CmdResult>");
            res.append("\nreturnCode" + this.returnCode);
            res.append("\nsuccess" + this.getSuccess());
            res.append("\n</CmdResult>");
            return res.toString();
        }
    }
}

