/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexProcessor;
import eu.simuline.m2latex.core.Settings;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Target {
    chk{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc, Optional<Long> timestamp) throws BuildFailureException {
            latexProcessor.processCheck(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return Target.NO_OUTPUT_FILES;
        }
    }
    ,
    dvi{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc, Optional<Long> timestamp) throws BuildFailureException {
            latexProcessor.processLatex2dvi(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^(T$T\\.(dvi|xdv)|.+(\\.(ptx|eps|jpg|png)|\\d+\\.mps))$";
        }
    }
    ,
    pdf{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc, Optional<Long> timestamp) throws BuildFailureException {
            latexProcessor.processLatex2pdf(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.pdf$";
        }

        @Override
        public boolean hasDiffTool() {
            return true;
        }
    }
    ,
    html{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc, Optional<Long> timestamp) throws BuildFailureException {
            latexProcessor.processLatex2html(desc, timestamp);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return settings.getPatternT4htOutputFiles();
        }
    }
    ,
    odt{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc, Optional<Long> timestamp) throws BuildFailureException {
            latexProcessor.processLatex2odt(desc, timestamp);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.(odt|fodt|uot|uot)$";
        }
    }
    ,
    docx{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc, Optional<Long> timestamp) throws BuildFailureException {
            latexProcessor.processLatex2docx(desc, timestamp);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.(doc(|6|.95|.x|.x7)|rtf)$";
        }
    }
    ,
    rtf{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc, Optional<Long> timestamp) throws BuildFailureException {
            latexProcessor.processLatex2rtf(desc, timestamp);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.rtf$";
        }
    }
    ,
    txt{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc, Optional<Long> timestamp) throws BuildFailureException {
            latexProcessor.processLatex2txt(desc, timestamp);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.txt$";
        }
    };

    private static final String NO_OUTPUT_FILES = ".^";

    public abstract void processSource(LatexProcessor var1, LatexMainDesc var2, Optional<Long> var3) throws BuildFailureException;

    public abstract String getPatternOutputFiles(Settings var1);

    public boolean hasDiffTool() {
        return false;
    }
}

