/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.FileMatch;
import eu.simuline.m2latex.core.LogWrapper;
import eu.simuline.m2latex.core.Settings;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.util.Arrays;

abstract class AbstractLatexProcessor {
    static final String SUFFIX_FLS = ".fls";
    static final String SUFFIX_LOG = ".log";
    static final String SUFFIX_PDF = ".pdf";
    static final String SUFFIX_VOID = "";
    protected final Settings settings;
    protected final CommandExecutor executor;
    protected final LogWrapper log;
    protected final TexFileUtils fileUtils;

    public AbstractLatexProcessor(Settings settings, CommandExecutor executor, LogWrapper log, TexFileUtils fileUtils) {
        this.settings = settings;
        this.log = log;
        this.executor = executor;
        this.fileUtils = fileUtils;
    }

    protected void logErrs(File logFile, String command, String pattern) {
        if (logFile.exists()) {
            if (this.hasErrsWarns(logFile, pattern)) {
                this.log.error("EAP01: Running " + command + " failed. Errors logged in '" + logFile.getName() + "'. ");
            }
        } else {
            this.log.error("EAP02: Running " + command + " failed: No log file '" + logFile.getName() + "' written. ");
        }
    }

    protected void logWarns(File logFile, String command, String pattern) {
        if (logFile.exists() && this.hasErrsWarns(logFile, pattern)) {
            this.logWarn(logFile, command);
        }
    }

    protected void logWarn(File logFile, String command) {
        this.log.warn("WAP03: Running " + command + " emitted warnings logged in '" + logFile.getName() + "'. ");
    }

    protected boolean hasErrsWarns(File logFile, String pattern) {
        assert (logFile.exists() && !logFile.isDirectory()) : "Expected existing (regular) log file " + logFile;
        FileMatch fileMatch = this.fileUtils.getMatchInFile(logFile, pattern);
        if (fileMatch.isFileReadable()) {
            return fileMatch.doesExprMatch();
        }
        this.log.warn("WAP04: Cannot read log file '" + logFile.getName() + "'; may hide warnings/errors. ");
        return false;
    }

    protected boolean update(File source, File target) {
        if (!target.exists()) {
            return true;
        }
        assert (source.exists() && !source.isDirectory()) : "Expected existing (regular) source " + source;
        return source.lastModified() > target.lastModified();
    }

    protected static String[] buildArguments(String options, File file, String ... addArgs) {
        String[] optionsArr = options.isEmpty() ? new String[]{} : options.split(" ");
        String[] args = Arrays.copyOf(optionsArr, optionsArr.length + addArgs.length + 1);
        System.arraycopy(addArgs, 0, args, optionsArr.length, addArgs.length);
        args[args.length - 1] = file.getName();
        System.out.println(Arrays.asList(args));
        return args;
    }
}

