/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.AbstractLatexProcessor;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.Converter;
import eu.simuline.m2latex.core.ConverterCategory;
import eu.simuline.m2latex.core.DirNode;
import eu.simuline.m2latex.core.FileMatch;
import eu.simuline.m2latex.core.Injection;
import eu.simuline.m2latex.core.LatexDev;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexMainParameterNames;
import eu.simuline.m2latex.core.LatexPreProcessor;
import eu.simuline.m2latex.core.LatexmkUsage;
import eu.simuline.m2latex.core.LogWrapper;
import eu.simuline.m2latex.core.MetaInfo;
import eu.simuline.m2latex.core.ParameterAdapter;
import eu.simuline.m2latex.core.Settings;
import eu.simuline.m2latex.core.Target;
import eu.simuline.m2latex.core.TargetsContext;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class LatexProcessor
extends AbstractLatexProcessor {
    static final String PATTERN_NEED_BIBTEX_RUN = "^\\\\bibdata";
    static final String PATTERN_OUFULL_HVBOX = "^(Ov|Und)erfull \\\\[hv]box \\(";
    static final String SUFFIX_TOC = ".toc";
    static final String SUFFIX_LOF = ".lof";
    static final String SUFFIX_LOT = ".lot";
    static final String SUFFIX_LOL = ".lol";
    static final String SUFFIX_AUX = ".aux";
    static final String SUFFIX_DVI = ".dvi";
    static final String SUFFIX_XDV = ".xdv";
    static final String SUFFIX_BLG = ".blg";
    static final String SUFFIX_BBL = ".bbl";
    static final String SUFFIX_IDX = ".idx";
    static final String SUFFIX_IND = ".ind";
    static final String SUFFIX_ILG = ".ilg";
    static final String SUFFIX_GLO = ".glo";
    static final String SUFFIX_GLS = ".gls";
    static final String SUFFIX_GLG = ".glg";
    static final String SUFFIX_PYC = ".pytxcode";
    static final String SUFFIX_PLG = ".plg";
    private static final String SUFFIX_PYTXMCR = ".pytxmcr";
    private static final String SUFFIX_RTF = ".rtf";
    private static final String SUFFIX_ODT = ".odt";
    static final String SUFFIX_HTML = ".html";
    private static final String SUFFIX_TXT = ".txt";
    private static final String SUFFIX_CLG = ".clg";
    private static final String IDX_EXPL = "^(\\\\indexentry)\\[([^]]*)\\](.*)$";
    private static final int GRP_IDENT_IDX = 2;
    private static final String IMPL_IDENT_IDX = "idx";
    private static final String SEP_IDENT_IDX = "-";
    private final ParameterAdapter paramAdapt;
    private final LatexPreProcessor preProc;
    private final MetaInfo metaInfo;
    private Optional<String> latex2PdfCmdMagic = Optional.empty();
    private static final String FOLDER_INJ = "injections/";

    LatexProcessor(Settings settings, CommandExecutor executor, LogWrapper log, TexFileUtils fileUtils, ParameterAdapter paramAdapt) {
        super(settings, executor, log, fileUtils);
        this.paramAdapt = paramAdapt;
        this.preProc = new LatexPreProcessor(this.settings, this.executor, this.log, this.fileUtils);
        this.metaInfo = new MetaInfo(this.executor, this.log);
        this.latex2PdfCmdMagic = Optional.empty();
    }

    public LatexProcessor(Settings settings, LogWrapper log, ParameterAdapter paramAdapt) {
        this(settings, new CommandExecutor(log), log, new TexFileUtils(log), paramAdapt);
    }

    Set<Target> getTargetsForBuild(LatexMainDesc desc, Map<String, Set<Target>> docClasses2Targets, SortedSet<Target> targetSet) throws BuildFailureException {
        Optional<String> targetsMagic = desc.groupMatch(LatexMainParameterNames.targetsMagic);
        if (targetsMagic.isPresent()) {
            this.log.info("Found targets " + targetsMagic.get() + " for document '" + desc.texFile + "' in magic comment. ");
            return Settings.getTargets(targetsMagic.get(), TargetsContext.targetsMagic);
        }
        String docClass = desc.getDocClass();
        Set<Target> possibleTargets = docClasses2Targets.get(docClass);
        if (possibleTargets == null) {
            this.log.warn("WLP09: For file '" + desc.texFile + "' targets are not restricted by document class '" + docClass + "'. ");
            return targetSet;
        }
        TreeSet<Target> unreachableTargets = new TreeSet<Target>(targetSet);
        unreachableTargets.removeAll(possibleTargets);
        if (!unreachableTargets.isEmpty()) {
            this.log.info("Skipping targets " + unreachableTargets + " for document '" + desc.texFile + "'. ");
        }
        TreeSet<Target> reachableTargets = new TreeSet<Target>(targetSet);
        reachableTargets.retainAll(possibleTargets);
        return reachableTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(SortedSet<Target> targetSet) throws BuildFailureException {
        Object object;
        this.paramAdapt.initialize();
        this.log.info("-----------create-------------");
        this.log.debug("Settings: " + this.settings.toString());
        Map<String, Set<Target>> docClasses2Targets = this.settings.getDocClassesToTargets();
        File texDir = this.settings.getTexSrcDirectoryFile();
        assert (texDir.exists() && texDir.isDirectory()) : "Expected existing tex folder " + texDir;
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texDir;
        DirNode node = new DirNode(texProcDir, this.fileUtils);
        try {
            Collection<LatexMainDesc> latexMainDescs = this.preProc.processGraphicsSelectMain(texProcDir, node);
            for (LatexMainDesc desc : latexMainDescs) {
                File texFile = desc.texFile;
                File targetDir = this.fileUtils.getTargetDirectory(texFile, texDir, this.settings.getOutputDirectoryFile());
                assert (!targetDir.exists() || targetDir.isDirectory()) : "Expected target folder " + targetDir + " folder if exists. ";
                Set<Target> targetsForBuild = this.getTargetsForBuild(desc, docClasses2Targets, targetSet);
                this.latex2PdfCmdMagic = desc.groupMatch(LatexMainParameterNames.programMagic);
                if (this.latex2PdfCmdMagic.isPresent()) {
                    this.log.info("Using " + this.latex2PdfCmdMagic.get() + " to process '" + desc.texFile + "'. ");
                }
                for (Target target : targetsForBuild) {
                    target.processSource(this, desc);
                    FileFilter fileFilter = TexFileUtils.getFileFilter(texFile, target.getPatternOutputFiles(this.settings), false);
                    Set<File> targetFiles = this.fileUtils.copyOutputToTargetFolder(texFile, fileFilter, targetDir);
                    this.log.debug(String.format("target %s has difftool %s", new Object[]{target, target.hasDiffTool()}));
                    if (!target.hasDiffTool()) {
                        this.log.debug(String.format("target %s has no difftool", new Object[]{target}));
                        continue;
                    }
                    if (!this.settings.isChkDiff()) {
                        this.log.debug("no artifact diff specified.");
                        continue;
                    }
                    this.log.debug("Preprare verification by diffing: ");
                    File diffRootDir = this.settings.getDiffDirectoryFile().getAbsoluteFile();
                    File artifactBaseDir = this.settings.getOutputDirectoryFile();
                    assert (targetFiles.size() == 1) : "Expected one target file, found " + targetFiles + ". ";
                    File pdfFileAct = targetFiles.iterator().next();
                    this.log.debug(String.format("act file %s", pdfFileAct));
                    File pdfFileCmp = TexFileUtils.getPdfFileDiff(pdfFileAct, artifactBaseDir, diffRootDir);
                    this.log.debug(String.format("cmp file %s", pdfFileCmp));
                    if (!pdfFileCmp.exists()) {
                        throw new BuildFailureException("TLP02: No file '" + pdfFileCmp + "' to compare with artifact from '" + texFile + "'. ");
                    }
                    assert (pdfFileCmp.exists());
                    assert (pdfFileAct.exists());
                    boolean coincide = this.runDiffPdf(pdfFileCmp, pdfFileAct);
                    if (coincide) {
                        this.log.info("checked: coincides with expected artifact. ");
                        continue;
                    }
                    throw new BuildFailureException("TLP01: Artifact '" + pdfFileAct.getName() + "' from '" + texFile + "' could not be reproduced. ");
                }
            }
            if (this.settings.isCleanUp()) {
                this.fileUtils.cleanUp(node, texProcDir);
            }
            object = this.settings.isCleanUp() ? "cleanup: " + texProcDir : "No cleanup";
        }
        catch (Throwable throwable) {
            if (this.settings.isCleanUp()) {
                this.fileUtils.cleanUp(node, texProcDir);
            }
            this.log.debug((String)(this.settings.isCleanUp() ? "cleanup: " + texProcDir : "No cleanup"));
            this.latex2PdfCmdMagic = Optional.empty();
            throw throwable;
        }
        this.log.debug((String)object);
        this.latex2PdfCmdMagic = Optional.empty();
    }

    public void processGraphics() throws BuildFailureException {
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texProcDir;
        DirNode node = new DirNode(texProcDir, this.fileUtils);
        this.preProc.processGraphicsSelectMain(texProcDir, node);
    }

    public void clearAll() throws BuildFailureException {
        this.paramAdapt.initialize();
        this.log.debug("Settings: " + this.settings.toString());
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texProcDir;
        this.preProc.clearCreated(texProcDir);
        this.clearInjFiles();
    }

    public String getLatex2pdfCommand() throws BuildFailureException {
        return this.latex2PdfCmdMagic.orElse(this.settings.getCommand(ConverterCategory.LaTeX));
    }

    private String getDvi2pdfCommand() throws BuildFailureException {
        return this.settings.getCommand(ConverterCategory.Dvi2Pdf);
    }

    private int preProcessLatex2dev(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        this.runLatex2dev(desc, dev);
        boolean hasBib = this.runBibtexByNeed(desc);
        boolean hasIdxGls = this.runMakeIndexByNeed(desc) | this.runMakeGlossaryByNeed(desc);
        boolean hasPyCode = this.runPythontexByNeed(desc);
        if (hasBib) {
            return 2;
        }
        boolean hasToc = desc.withSuffix(SUFFIX_TOC).exists();
        if (hasIdxGls) {
            return hasToc ? 2 : 1;
        }
        boolean needLatexReRun = hasToc || hasPyCode || desc.withSuffix(SUFFIX_LOF).exists() || desc.withSuffix(SUFFIX_LOT).exists() || desc.withSuffix(SUFFIX_LOL).exists();
        return needLatexReRun ? 1 : 0;
    }

    private void processLatex2devCore(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        int numLatexReRuns = this.preProcessLatex2dev(desc, dev);
        String latexCmd = this.getLatex2pdfCommand();
        assert (numLatexReRuns == 0 || numLatexReRuns == 1 || numLatexReRuns == 2);
        if (numLatexReRuns > 0) {
            this.log.debug("Rerun " + latexCmd + " to update table of contents, ... bibliography, index, or that like. ");
            this.runLatex2dev(desc, dev);
            --numLatexReRuns;
        }
        assert (numLatexReRuns == 0 || numLatexReRuns == 1);
        boolean needLatexReRun = numLatexReRuns == 1 || this.needRun(true, latexCmd, desc.logFile, this.settings.getPatternReRunLatex());
        int maxNumReruns = this.settings.getMaxNumReRunsLatex();
        for (int num = 0; maxNumReruns == -1 || num < maxNumReruns; ++num) {
            boolean needMakeIndexReRun = this.needRun(true, this.settings.getCommand(ConverterCategory.MakeIndex), desc.logFile, this.settings.getPatternReRunMakeIndex());
            if (!(needLatexReRun |= needMakeIndexReRun)) {
                return;
            }
            this.log.debug("Latex must be rerun. ");
            if (needMakeIndexReRun) {
                this.runMakeIndexByNeed(desc);
            }
            this.runLatex2dev(desc, dev);
            needLatexReRun = this.needRun(true, latexCmd, desc.logFile, this.settings.getPatternReRunLatex());
        }
        this.log.warn("WLP01: LaTeX requires rerun but maximum number " + maxNumReruns + " reached. ");
    }

    private boolean needRun(boolean another, String cmdStr, File logAuxFile, String pattern) {
        FileMatch fileMatch = this.fileUtils.getMatchInFile(logAuxFile, pattern);
        if (fileMatch.isFileReadable()) {
            return fileMatch.doesExprMatch();
        }
        this.log.warn("WLP02: Cannot read " + TexFileUtils.getSuffix(logAuxFile, false) + " file '" + logAuxFile.getName() + "'; " + cmdStr + " may require " + (another ? "re" : "") + "run. ");
        return false;
    }

    private void processLatex2dev(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        if (dev == LatexDev.pdf && this.settings.getLatexmkUsage() != LatexmkUsage.NotAtAll) {
            this.log.info("Running latexmk bypassing direct compilation. ");
            this.runLatexmk(desc);
            return;
        }
        this.log.info("No latexmk because target=" + dev + " and usage=" + this.settings.getLatexmkUsage());
        this.processLatex2devCore(desc, dev);
        this.logWarns(desc.logFile, this.getLatex2pdfCommand());
    }

    void processLatex2dvi(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into dvi/xdv:  LaTeX file '" + desc.texFile + "'. ");
        this.processLatex2dev(desc, LatexDev.dvips);
    }

    void processLatex2pdf(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into pdf:  LaTeX file '" + desc.texFile + "'. ");
        LatexDev dev = this.settings.getPdfViaDvi();
        this.processLatex2dev(desc, dev);
        if (dev.isViaDvi()) {
            this.runDvi2pdf(desc);
        }
    }

    private void logErrs(File logFile, String command) {
        this.logErrs(logFile, command, this.settings.getPatternErrLatex());
    }

    private void logWarns(File logFile, String command) {
        if (!logFile.exists()) {
            return;
        }
        if (this.settings.getDebugBadBoxes() && this.hasErrsWarns(logFile, PATTERN_OUFULL_HVBOX)) {
            this.log.warn("WLP03: Running " + command + " created bad boxes logged in '" + logFile.getName() + "'. ");
        }
        if (this.settings.getDebugWarnings() && this.hasErrsWarns(logFile, this.settings.getPatternWarnLatex())) {
            this.logWarn(logFile, command);
        }
    }

    void processLatex2html(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into html: LaTeX file '" + desc.texFile + "'. ");
        this.preProcessLatex2dev(desc, LatexDev.devViaDvi(true));
        this.runLatex2html(desc);
    }

    void processLatex2odt(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into odt:  LaTeX file '" + desc.texFile + "'. ");
        this.preProcessLatex2dev(desc, this.settings.getPdfViaDvi());
        this.runLatex2odt(desc);
    }

    void processLatex2docx(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into doc(x): LaTeX file '" + desc.texFile + "'. ");
        this.preProcessLatex2dev(desc, this.settings.getPdfViaDvi());
        this.runLatex2odt(desc);
        this.runOdt2doc(desc);
    }

    void processLatex2rtf(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into rtf:  LaTeX file '" + desc.texFile + "'. ");
        this.runLatex2rtf(desc.texFile);
    }

    void processLatex2txt(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Converting into txt:  LaTeX file '" + desc.texFile + "'. ");
        LatexDev dev = this.settings.getPdfViaDvi();
        this.processLatex2devCore(desc, dev);
        if (dev.isViaDvi()) {
            this.runDvi2pdf(desc);
        }
        this.runPdf2txt(desc);
    }

    public boolean printMetaInfo(boolean includeVersionInfo) throws BuildFailureException {
        SortedSet<Converter> convertersExcluded = this.settings.getConvertersExcluded();
        return this.metaInfo.printMetaInfo(includeVersionInfo, convertersExcluded);
    }

    private boolean runBibtexByNeed(LatexMainDesc desc) throws BuildFailureException {
        File auxFile = desc.withSuffix(SUFFIX_AUX);
        String command = this.settings.getCommand(ConverterCategory.BibTeX);
        if (!this.needRun(false, command, auxFile, PATTERN_NEED_BIBTEX_RUN)) {
            return false;
        }
        this.log.debug("Running " + command + " on '" + auxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getBibtexOptions(), auxFile);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_BBL));
        File logFile = desc.withSuffix(SUFFIX_BLG);
        this.logErrs(logFile, command, this.settings.getPatternErrBibtex());
        this.logWarns(logFile, command, this.settings.getPatternWarnBibtex());
        return true;
    }

    private boolean runMakeIndexByNeed(LatexMainDesc desc) throws BuildFailureException {
        boolean needRun = desc.idxFile.exists();
        this.log.debug("MakeIndex run required? " + needRun);
        Collection<String> explIdxIdent = null;
        if (needRun && (explIdxIdent = this.fileUtils.collectMatches(desc.idxFile, IDX_EXPL, 2)) == null) {
            this.log.warn("WLP04: Cannot read idx file '" + desc.idxFile.getName() + "'; skip creation of index. ");
            return false;
        }
        assert (explIdxIdent != null == needRun);
        FileFilter filter = this.fileUtils.getFileFilterReplace(desc.idxFile, "-.+");
        File[] idxFilesExtInDir = this.fileUtils.listFilesOrWarn(desc.idxFile.getParentFile(), filter);
        assert (explIdxIdent != null == needRun);
        if (idxFilesExtInDir != null && idxFilesExtInDir.length > 0 && (explIdxIdent == null || explIdxIdent.isEmpty())) {
            this.log.warn("WLP05: Use package 'splitidx' without option 'split' in '" + desc.texFile.getName() + "'. ");
        }
        if (explIdxIdent != null) {
            if (explIdxIdent.isEmpty()) {
                this.runMakeIndex(desc);
            } else {
                this.runSplitIndex(desc, explIdxIdent);
            }
        }
        return needRun;
    }

    private void runMakeIndex(LatexMainDesc desc) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.MakeIndex);
        File idxFile = desc.idxFile;
        this.log.debug("Running " + command + " on '" + idxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getMakeIndexOptions(), idxFile);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.indFile);
        this.logErrs(desc.ilgFile, command, this.settings.getPatternErrMakeIndex());
        this.logWarns(desc.ilgFile, command, this.settings.getPatternWarnMakeIndex());
    }

    private File[] files(String filePrefix, Collection<String> variant, String suffix) {
        File[] res = new File[variant.size()];
        int idx = 0;
        for (String idxIdent : variant) {
            StringBuilder strb = new StringBuilder();
            strb.append(filePrefix);
            strb.append(idxIdent);
            strb.append(suffix);
            res[idx++] = new File(strb.toString());
        }
        return res;
    }

    private void runSplitIndex(LatexMainDesc desc, Collection<String> explIdxIdent) throws BuildFailureException {
        String splitInxCmd = this.settings.getCommand(ConverterCategory.SplitIndex);
        File idxFile = desc.idxFile;
        this.log.debug("Running " + splitInxCmd + " on '" + idxFile.getName() + "'. ");
        String[] argsDefault = new String[]{"-m " + this.settings.getCommand(ConverterCategory.MakeIndex), "-i ^(\\\\indexentry)\\[([^]]*)\\](.*)$", "-r $1$3", "-s -$2"};
        String argsOption = this.settings.getMakeIndexOptions();
        String[] args = argsOption.isEmpty() ? new String[argsDefault.length + 1] : new String[argsDefault.length + 2];
        System.arraycopy(argsDefault, 0, args, 0, argsDefault.length);
        if (!argsOption.isEmpty()) {
            args[args.length - 2] = argsOption;
        }
        args[args.length - 1] = desc.xxxFile.getName();
        String optionsMakeIndex = this.settings.getMakeIndexOptions();
        if (!optionsMakeIndex.isEmpty()) {
            String[] optionsMake_IndexArr = optionsMakeIndex.split(" ");
            String[] optionsSplitIndexArr = args;
            args = new String[optionsMake_IndexArr.length + 1 + optionsSplitIndexArr.length];
            System.arraycopy(optionsSplitIndexArr, 0, args, 0, optionsSplitIndexArr.length);
            args[optionsSplitIndexArr.length] = "--";
            System.arraycopy(optionsMake_IndexArr, 0, args, optionsSplitIndexArr.length + 1, optionsMake_IndexArr.length);
        }
        explIdxIdent.add(IMPL_IDENT_IDX);
        String filePrefix = desc.xxxFile.toString() + SEP_IDENT_IDX;
        File[] indFiles = this.files(filePrefix, explIdxIdent, SUFFIX_IND);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), splitInxCmd, args, indFiles);
        File[] ilgFiles = this.files(filePrefix, explIdxIdent, SUFFIX_ILG);
        splitInxCmd = this.settings.getCommand(ConverterCategory.MakeIndex);
        for (int idx = 0; idx < explIdxIdent.size(); ++idx) {
            this.logErrs(ilgFiles[idx], splitInxCmd, this.settings.getPatternErrMakeIndex());
            this.logWarns(ilgFiles[idx], splitInxCmd, this.settings.getPatternWarnMakeIndex());
        }
    }

    private boolean runMakeGlossaryByNeed(LatexMainDesc desc) throws BuildFailureException {
        boolean needRun = desc.gloFile.exists();
        this.log.debug("MakeGlossaries run required? " + needRun);
        if (!needRun) {
            return false;
        }
        File xxxFile = desc.xxxFile;
        String command = this.settings.getCommand(ConverterCategory.MakeGlossaries);
        this.log.debug("Running " + command + " on '" + xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getMakeGlossariesOptions(), xxxFile);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.glsFile);
        File glgFile = desc.glgFile;
        this.logErrs(glgFile, command, this.settings.getPatternErrMakeGlossaries());
        this.logWarns(glgFile, command, this.settings.getPatternWarnMakeIndex() + "|" + this.settings.getPatternWarnXindy());
        return true;
    }

    private boolean runPythontexByNeed(LatexMainDesc desc) throws BuildFailureException {
        boolean isDel;
        File pycFile = desc.withSuffix(SUFFIX_PYC);
        boolean needRun = pycFile.exists();
        this.log.debug("Pythontex run required? " + needRun);
        if (!needRun) {
            return false;
        }
        String command = this.settings.getCommand(ConverterCategory.Pythontex);
        this.log.debug("Running " + command + " on '" + pycFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getPythontexOptions(), desc.xxxFile);
        File outFolder = TexFileUtils.replacePrefix("pythontex-files-", desc.xxxFile);
        String repOutFileName = desc.xxxFile.getName() + SUFFIX_PYTXMCR;
        File repOutFile = new File(outFolder, repOutFileName);
        if (repOutFile.exists() && !(isDel = repOutFile.delete())) {
            this.log.warn("Preliminary warning: Could not delete '" + repOutFile + "'; this may cause further warnings/errors. ");
        }
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, repOutFile);
        File logFile = desc.withSuffix(SUFFIX_PLG);
        this.logErrs(logFile, command, this.settings.getPatternErrPyTex());
        this.logWarns(logFile, command, this.settings.getPatternWarnPyTex());
        return true;
    }

    private void runLatex2dev(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.getLatex2pdfCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        boolean isTypeXelatex = Converter.XeLatex.getCommand().equals(command);
        String[] args = LatexProcessor.buildLatexArguments(this.settings, dev, texFile, isTypeXelatex);
        if (this.settings.isChkDiff()) {
            this.executor.setIsTimeless();
        }
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, dev.latexTargetFile(desc, isTypeXelatex));
        this.logErrs(desc.logFile, command);
    }

    private void runLatexmk(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getLatexmkCommand();
        Optional<String> programMagic = desc.groupMatch(LatexMainParameterNames.programMagic);
        Object options = this.settings.getLatexmkOptions();
        if (programMagic.isPresent()) {
            if (!((String)options).isEmpty()) {
                options = (String)options + " ";
            }
            options = (String)options + "-e $programMagic=q/" + programMagic.get() + "/";
        }
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments((String)options, texFile);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.pdfFile);
    }

    protected static String[] buildLatexArguments(Settings settings, LatexDev dev, File texFile, boolean isTypeXelatex) throws BuildFailureException {
        Object options = settings.getLatex2pdfOptions();
        if (!dev.isDefault()) {
            options = (String)options + (String)(isTypeXelatex ? " -no-pdf" : " -output-format=" + dev.getLatexOutputFormat());
        }
        return LatexProcessor.buildArguments((String)options, texFile);
    }

    private void runDvi2pdf(LatexMainDesc desc) throws BuildFailureException {
        assert (this.settings.getPdfViaDvi().isViaDvi());
        String command = this.getDvi2pdfCommand();
        if (desc.dviFile.exists() && desc.xdvFile.exists()) {
            this.log.warn("WLP07: Found both '" + desc.dviFile + "' and '" + desc.xdvFile + "'; convert the latter. ");
        }
        this.log.debug("Running " + command + " on '" + desc.xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getDvi2pdfOptions(), desc.xxxFile);
        if (this.settings.isChkDiff()) {
            this.executor.setIsTimeless();
        }
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.pdfFile);
    }

    private void runLatex2html(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getTex4htCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildHtlatexArguments(this.settings, texFile);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_HTML));
        this.logErrs(desc.logFile, command);
        this.logWarns(desc.logFile, command);
    }

    protected static String[] buildHtlatexArguments(Settings settings, File texFile) {
        return new String[]{texFile.getName(), settings.getTex4htStyOptions(), settings.getTex4htOptions(), settings.getT4htOptions(), settings.getLatex2pdfOptions()};
    }

    private void runLatex2rtf(File texFile) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.LaTeX2Rtf);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getLatex2rtfOptions(), texFile);
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(texFile, SUFFIX_RTF));
    }

    private void runLatex2odt(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getTex4htCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = new String[]{texFile.getName(), "xhtml,ooffice", "ooffice/! -cmozhtf", "-coo -cvalidate"};
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_ODT));
        this.logErrs(desc.logFile, command);
        this.logWarns(desc.logFile, command);
    }

    private void runOdt2doc(LatexMainDesc desc) throws BuildFailureException {
        File odtFile = desc.withSuffix(SUFFIX_ODT);
        String command = this.settings.getCommand(ConverterCategory.Odt2Doc);
        this.log.debug("Running " + command + " on '" + odtFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getOdt2docOptions(), odtFile);
        String suffix = null;
        for (int idx = 0; idx < args.length - 1; ++idx) {
            if (!args[idx].startsWith("-f")) continue;
            assert (suffix == null);
            suffix = args[idx].substring(2, args[idx].length());
        }
        assert (suffix != null);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(suffix));
    }

    private void runPdf2txt(LatexMainDesc desc) throws BuildFailureException {
        File pdfFile = desc.withSuffix(".pdf");
        String command = this.settings.getCommand(ConverterCategory.Pdf2Txt);
        this.log.debug("Running " + command + " on '" + pdfFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getPdf2txtOptions(), pdfFile);
        this.executor.execute(desc.parentDir, this.settings.getTexPath(), command, args, desc.withSuffix(SUFFIX_TXT));
    }

    void processCheck(LatexMainDesc desc) throws BuildFailureException {
        this.log.info("Checking:  LaTeX file '" + desc.texFile + "'. ");
        this.runCheck(desc);
    }

    private void runCheck(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        File clgFile = desc.withSuffix(SUFFIX_CLG);
        String command = this.settings.getCommand(ConverterCategory.LatexChk);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildChkTexArguments(this.settings.getChkTexOptions(), texFile, clgFile);
        CommandExecutor.CmdResult res = this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, CommandExecutor.ReturnCodeChecker.IsOne, args, clgFile);
        switch (res.returnCode) {
            case 0: {
                if (!clgFile.exists() || clgFile.length() == 0L) break;
                this.log.info("Checker '" + command + "' logged a message in '" + clgFile.getName() + "'. ");
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.log.error("ELP02: Checker '" + command + "' logged an error in '" + clgFile.getName() + "'. ");
                break;
            }
            case 2: {
                this.log.warn("WLP08: Checker '" + command + "' logged a warning in '" + clgFile.getName() + "'. ");
                break;
            }
            default: {
                this.log.error("ELP01: For command '" + command + "' found unexpected return code " + res.returnCode + ". ");
            }
        }
    }

    protected static String[] buildChkTexArguments(String options, File texFile, File clgFile) {
        if (options.isEmpty()) {
            return new String[]{"-o", clgFile.getName(), texFile.getName()};
        }
        String[] optionsArr = options.split(" ");
        String[] args = Arrays.copyOf(optionsArr, optionsArr.length + 3);
        args[optionsArr.length] = "-o";
        args[optionsArr.length + 1] = clgFile.getName();
        args[optionsArr.length + 2] = texFile.getName();
        return args;
    }

    boolean runDiffPdf(File pdfFileCmp, File pdfFileAct) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.DiffPdf);
        this.log.debug("Running " + command + " diffing '" + pdfFileCmp.getName() + "' and '" + pdfFileAct.getName() + "''. ");
        String[] args = new String[]{pdfFileCmp.toString(), pdfFileAct.toString()};
        int returnCode = this.executor.execute(null, (File)this.settings.getTexPath(), (String)command, (CommandExecutor.ReturnCodeChecker)CommandExecutor.ReturnCodeChecker.IsNotZeroOrOne, (String[])args, (File[])new File[0]).returnCode;
        return returnCode == 0;
    }

    public void processFileInjections(Set<Injection> injections) throws BuildFailureException {
        for (Injection inj : injections) {
            String fileName = inj.getFileName();
            InputStream inStream = MetaInfo.getStream(FOLDER_INJ + fileName);
            File outFile = this.settings.rcResourceToFile(fileName);
            try {
                if (!outFile.exists() || this.fileUtils.isCreatedByMyself(outFile, inj)) {
                    PrintStream writer = new PrintStream(outFile);
                    String version = this.metaInfo.getCoordinates().version;
                    this.settings.filterInjection(inStream, writer, version, inj);
                }
                inStream.close();
            }
            catch (IOException ioe) {
                throw new BuildFailureException("TLP03 Failure while writing file '" + fileName + "' or closing in-stream. ", ioe);
            }
            boolean success = outFile.setExecutable(inj.setExecutable(), false);
            assert (success || !inj.setExecutable());
        }
    }

    private void clearInjFiles() {
        for (Injection inj : Injection.values()) {
            File outFile = this.settings.rcResourceToFile(inj.getFileName());
            if (!outFile.exists() || !this.fileUtils.isCreatedByMyself(outFile, inj)) continue;
            this.fileUtils.deleteOrError(outFile, false);
        }
    }
}

