/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import com.florianingerl.util.regex.MatchResult;

public class FileMatch {
    private static final FileMatch UNREADABLE = new FileMatch();
    private static final FileMatch NO_MATCH = new FileMatchReadableNoMatch();

    private FileMatch() {
    }

    static FileMatch unreadable() {
        return UNREADABLE;
    }

    static FileMatch noMatch() {
        return NO_MATCH;
    }

    static FileMatch matches(MatchResult matchRes) {
        return new FileMatchWithMatcher(matchRes);
    }

    boolean isFileReadable() {
        return false;
    }

    boolean doesExprMatch() {
        throw new IllegalStateException("Unreadable cannot be asked for match. ");
    }

    MatchResult getMatchResult() {
        throw new IllegalStateException("No group matched. ");
    }

    static class FileMatchWithMatcher
    extends FileMatch {
        private final MatchResult matchRes;

        FileMatchWithMatcher(MatchResult matchRes) {
            this.matchRes = matchRes;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return true;
        }

        @Override
        MatchResult getMatchResult() {
            return this.matchRes;
        }
    }

    static class FileMatchReadableNoMatch
    extends FileMatch {
        private FileMatchReadableNoMatch() {
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return false;
        }
    }
}

