/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.AbstractLatexProcessor;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.ConverterCategory;
import eu.simuline.m2latex.core.DirNode;
import eu.simuline.m2latex.core.FileMatch;
import eu.simuline.m2latex.core.LatexDev;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LogWrapper;
import eu.simuline.m2latex.core.Settings;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class LatexPreProcessor
extends AbstractLatexProcessor {
    private static final Map<String, SuffixHandler> SUFFIX2HANDLER = new TreeMap<String, SuffixHandler>();
    private static final String SUFFIX_TEX = ".tex";
    static final String SUFFIX_PTX = ".ptx";
    static final String SUFFIX_PDFTEX = ".pdf_tex";
    static final String SUFFIX_EPSTEX = ".eps_tex";
    private static final String SUFFIX_FIG = ".fig";
    private static final String SUFFIX_SVG = ".svg";
    private static final String SUFFIX_GP = ".gp";
    private static final String SUFFIX_MP = ".mp";
    private static final String SUFFIX_MPS = ".mps";
    private static final String SUFFIX_MPX = ".mpx";
    private static final String SUFFIX_JPG = ".jpg";
    private static final String SUFFIX_PNG = ".png";
    private static final String SUFFIX_BIB = ".bib";
    static final String SUFFIX_EPS = ".eps";
    private static final String SUFFIX_XBB = ".xbb";
    private static final String SUFFIX_BB = ".bb";
    private static final String XFIG_TEX_LANGUAGE = "pdftex_t";

    LatexPreProcessor(Settings settings, CommandExecutor executor, LogWrapper log, TexFileUtils fileUtils) {
        super(settings, executor, log, fileUtils);
    }

    private void runFig2Dev(File figFile) throws BuildFailureException {
        this.log.info("Processing fig-file '" + figFile + "'. ");
        this.runFig2DevInTex(figFile, LatexDev.pdf);
        this.runFig2DevInTex(figFile, LatexDev.dvips);
        this.runFig2TexInclDev(figFile);
    }

    private void runFig2DevInTex(File figFile, LatexDev dev) throws BuildFailureException {
        File figInTexFile = TexFileUtils.replaceSuffix(figFile, dev.getGraphicsInTexSuffix());
        String command = this.settings.getCommand(ConverterCategory.Fig2Dev);
        String[] args = this.buildArgumentsFig2PdfEps(dev.getXFigInTexLanguage(), this.settings.getFig2devGenOptions(), this.settings.getFig2devPdfEpsOptions(), figFile, figInTexFile);
        this.log.debug("Running " + command + " -L pdftex/pstex  ... on '" + figFile.getName() + "'. ");
        this.executor.execute(figFile.getParentFile(), this.settings.getTexPath(), command, args, figInTexFile);
    }

    private String[] buildArgumentsFig2PdfEps(String language, String optionsGen, String optionsPdfEps, File figFile, File grpFile) {
        String[] optionsGenArr = optionsGen.isEmpty() ? new String[]{} : optionsGen.split(" ");
        String[] optionsPdfEpsArr = optionsPdfEps.isEmpty() ? new String[]{} : optionsPdfEps.split(" ");
        int lenSum = optionsGenArr.length + optionsPdfEpsArr.length;
        String[] args = new String[lenSum + 4];
        args[0] = "-L";
        args[1] = language;
        System.arraycopy(optionsGenArr, 0, args, 2, optionsGenArr.length);
        System.arraycopy(optionsPdfEpsArr, 0, args, 2 + optionsGenArr.length, optionsPdfEpsArr.length);
        args[2 + lenSum] = figFile.getName();
        args[3 + lenSum] = grpFile.getName();
        return args;
    }

    private void runFig2TexInclDev(File figFile) throws BuildFailureException {
        File ptxFile = TexFileUtils.replaceSuffix(figFile, SUFFIX_PTX);
        String command = this.settings.getCommand(ConverterCategory.Fig2Dev);
        String[] args = this.buildArgumentsFig2Ptx(this.settings.getFig2devGenOptions(), this.settings.getFig2devPtxOptions(), figFile, ptxFile);
        this.log.debug("Running " + command + " -L (pdf/ps)tex_t... on '" + figFile.getName() + "'. ");
        this.executor.execute(figFile.getParentFile(), this.settings.getTexPath(), command, args, ptxFile);
    }

    private String[] buildArgumentsFig2Ptx(String optionsGen, String optionsPtx, File figFile, File ptxFile) {
        String[] optionsGenArr = optionsGen.isEmpty() ? new String[]{} : optionsGen.split(" ");
        String[] optionsPtxArr = optionsPtx.isEmpty() ? new String[]{} : optionsPtx.split(" ");
        int lenSum = optionsGenArr.length + optionsPtxArr.length;
        String[] args = new String[lenSum + 6];
        args[0] = "-L";
        args[1] = XFIG_TEX_LANGUAGE;
        System.arraycopy(optionsGenArr, 0, args, 2, optionsGenArr.length);
        System.arraycopy(optionsPtxArr, 0, args, 2 + optionsGenArr.length, optionsPtxArr.length);
        args[2 + lenSum] = "-p";
        args[3 + lenSum] = TexFileUtils.replaceSuffix(figFile, "").getName();
        args[4 + lenSum] = figFile.getName();
        args[5 + lenSum] = ptxFile.getName();
        return args;
    }

    private void clearTargetPtxPdfEps(File grpFile) {
        this.log.info("Deleting targets of file '" + grpFile + "'. ");
        this.deleteIfExists(grpFile, SUFFIX_PTX);
        this.deleteIfExists(grpFile, LatexDev.pdf.getGraphicsInTexSuffix());
        this.deleteIfExists(grpFile, LatexDev.dvips.getGraphicsInTexSuffix());
    }

    private void runGnuplot2Dev(File gpFile) throws BuildFailureException {
        this.log.info("Processing gnuplot-file '" + gpFile + "'. ");
        this.runGnuplot2Dev(gpFile, LatexDev.dvips);
        this.runGnuplot2Dev(gpFile, LatexDev.pdf);
    }

    private void runGnuplot2Dev(File gpFile, LatexDev dev) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.Gnuplot2Dev);
        File grpFile = TexFileUtils.replaceSuffix(gpFile, dev.getGraphicsInTexSuffix());
        File ptxFile = TexFileUtils.replaceSuffix(gpFile, SUFFIX_PTX);
        String[] args = new String[]{"-e", "set terminal cairolatex " + dev.getGnuplotInTexLanguage() + " " + this.settings.getGnuplotOptions() + ";set output '" + ptxFile.getName() + "';load '" + gpFile.getName() + "'"};
        this.log.debug("Running " + command + " -e...  on '" + gpFile.getName() + "'. ");
        this.executor.execute(gpFile.getParentFile(), this.settings.getTexPath(), command, args, grpFile, ptxFile);
    }

    private void runMetapost2mps(File mpFile) throws BuildFailureException {
        this.log.info("Processing metapost-file '" + mpFile + "'. ");
        String command = this.settings.getCommand(ConverterCategory.MetaPost);
        File workingDir = mpFile.getParentFile();
        String[] args = LatexPreProcessor.buildArguments(this.settings.getMetapostOptions(), mpFile);
        this.log.debug("Running " + command + " on '" + mpFile.getName() + "'. ");
        this.executor.execute(workingDir, this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(mpFile, SUFFIX_MPS));
        File logFile = TexFileUtils.replaceSuffix(mpFile, ".log");
        this.logErrs(logFile, command, this.settings.getPatternErrMPost());
        this.logWarns(logFile, command, this.settings.getPatternWarnMPost());
    }

    private void clearTargetMp(File mpFile) {
        this.log.info("Deleting targets of graphic-file '" + mpFile + "'. ");
        this.deleteIfExists(mpFile, ".log");
        this.deleteIfExists(mpFile, ".fls");
        this.deleteIfExists(mpFile, SUFFIX_MPX);
        this.deleteIfExists(mpFile, SUFFIX_MPS);
    }

    private void runSvg2Dev(File svgFile) throws BuildFailureException {
        this.log.info("Processing svg-file '" + svgFile + "'. ");
        this.runSvg2Dev(svgFile, LatexDev.pdf, false);
        this.runSvg2Dev(svgFile, LatexDev.dvips, true);
    }

    private void runSvg2Dev(File svgFile, LatexDev dev, boolean filterTex) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.Svg2Dev);
        File grpFile = TexFileUtils.replaceSuffix(svgFile, dev.getGraphicsInTexSuffix());
        File texFile = TexFileUtils.replaceSuffix(svgFile, dev.getInkscapeTexSuffix());
        String[] args = LatexPreProcessor.buildArgumentsInkscp(grpFile, this.settings.getSvg2devOptions(), svgFile);
        this.log.debug("Running " + command + " on '" + svgFile.getName() + "'. ");
        this.executor.execute(svgFile.getParentFile(), this.settings.getTexPath(), command, args, grpFile, texFile);
        if (filterTex) {
            String suffix = TexFileUtils.getSuffix(texFile);
            assert (SUFFIX_EPSTEX.equals(suffix)) : "Expected suffix '.eps_tex' found '" + suffix + "'";
            File destFile = TexFileUtils.replaceSuffix(texFile, SUFFIX_PTX);
            File bareFile = TexFileUtils.replaceSuffix(texFile, "");
            this.fileUtils.filterInkscapeIncludeFile(texFile, destFile, bareFile.getName(), SUFFIX_EPS);
        }
        this.fileUtils.deleteOrError(texFile, false);
    }

    protected static String[] buildArgumentsInkscp(File grpFile, String options, File file) {
        String optExp = "--export-filename=" + grpFile.getName();
        if (options.isEmpty()) {
            return new String[]{optExp, file.getName()};
        }
        String[] optionsArr = options.split(" ");
        String[] args = new String[optionsArr.length + 2];
        System.arraycopy(optionsArr, 0, args, 1, optionsArr.length);
        args[args.length - 1] = file.getName();
        args[0] = optExp;
        return args;
    }

    private void runEbbByConfig(File file) throws BuildFailureException {
        if (!this.settings.getCreateBoundingBoxes()) {
            String suffix = TexFileUtils.getSuffix(file).substring(1);
            this.log.info(suffix.toUpperCase() + "-file '" + file + "' needs no processing. ");
            return;
        }
        String command = this.settings.getCommand(ConverterCategory.EbbCmd);
        File workingDir = file.getParentFile();
        String[] args = LatexPreProcessor.buildNullArguments(this.settings.getEbbOptions(), file);
        args[0] = "-x";
        File resFile = TexFileUtils.replaceSuffix(file, SUFFIX_XBB);
        this.log.debug("Running " + command + " twice on '" + file.getName() + "'. ");
        this.executor.execute(workingDir, this.settings.getTexPath(), command, args, resFile);
        args[0] = "-m";
        resFile = TexFileUtils.replaceSuffix(file, SUFFIX_BB);
        this.executor.execute(workingDir, this.settings.getTexPath(), command, args, resFile);
    }

    protected static String[] buildNullArguments(String options, File file) {
        if (options.isEmpty()) {
            return new String[]{null, file.getName()};
        }
        String[] optionsArr = options.split(" ");
        String[] args = new String[optionsArr.length + 2];
        System.arraycopy(optionsArr, 0, args, 1, optionsArr.length);
        args[args.length - 1] = file.getName();
        assert (args[0] == null);
        return args;
    }

    private void clearTargetJpgPng(File file) {
        this.log.info("Deleting bounding boxes of file '" + file + "' if present. ");
        this.deleteIfExists(file, SUFFIX_XBB);
        this.deleteIfExists(file, SUFFIX_BB);
    }

    private void deleteIfExists(File file, String suffix) {
        File delFile = TexFileUtils.replaceSuffix(file, suffix);
        if (!delFile.exists()) {
            return;
        }
        this.fileUtils.deleteOrError(delFile, false);
    }

    private Optional<LatexMainDesc> optLatexMainFile(File texFile) {
        assert (texFile.exists() && !texFile.isDirectory()) : "Expected existing regular tex file " + texFile;
        FileMatch fileMatch = this.fileUtils.getMatchInFile(texFile, this.settings.getPatternLatexMainFile());
        if (!fileMatch.isFileReadable()) {
            this.log.warn("WPP02: Cannot read tex file '" + texFile + "'; may bear latex main file. ");
            return Optional.empty();
        }
        System.out.println("readable and match: " + fileMatch.doesExprMatch() + " " + texFile);
        return fileMatch.doesExprMatch() ? Optional.of(new LatexMainDesc(texFile, fileMatch.getMatcher())) : Optional.empty();
    }

    private void addIfLatexMain(File texFile, Collection<LatexMainDesc> latexMainDescs) {
        Optional<LatexMainDesc> optTexFileDesc = this.optLatexMainFile(texFile);
        if (optTexFileDesc.isPresent()) {
            LatexMainDesc desc = optTexFileDesc.get();
            this.log.info("Detected " + desc.getDocClass() + "-file '" + texFile + "'. ");
            latexMainDescs.add(desc);
        }
    }

    private boolean clearTargetTexIfLatexMain(File texFile) {
        if (this.optLatexMainFile(texFile).isEmpty()) {
            return false;
        }
        this.log.info("Deleting targets of latex main file '" + texFile + "'. ");
        boolean allowsDir = true;
        FileFilter filter = TexFileUtils.getFileFilter(texFile, this.settings.getPatternCreatedFromLatexMain(), allowsDir);
        this.fileUtils.deleteX(texFile, filter, true);
        return true;
    }

    private void clearIfTexNoLatexMain(File texFile) {
        this.log.info("Deleting aux file of tex file '" + texFile + "' if present (included). ");
        this.deleteIfExists(texFile, ".aux");
    }

    Collection<LatexMainDesc> processGraphicsSelectMain(File dir, DirNode node) throws BuildFailureException {
        Set<String> mainFilesExcluded;
        TreeSet<String> skippedSuffixes = new TreeSet<String>();
        TreeSet<LatexMainDesc> latexMainDescs = new TreeSet<LatexMainDesc>();
        if (this.settings.getReadTexSrcProcDirRec()) {
            this.processGraphicsSelectMainRec(dir, node, skippedSuffixes, latexMainDescs);
        } else {
            this.processGraphicsSelectMain(dir, node, skippedSuffixes, latexMainDescs);
        }
        if (!skippedSuffixes.isEmpty()) {
            this.log.warn("WPP03: Skipped processing of files with suffixes " + skippedSuffixes + ". ");
        }
        HashMap<String, LatexMainDesc> name2desc = new HashMap<String, LatexMainDesc>();
        HashSet<String> keysOverwritten = new HashSet<String>();
        for (LatexMainDesc mainDesc : latexMainDescs) {
            String key = mainDesc.xxxFile.getName();
            LatexMainDesc oldValue = name2desc.put(key, mainDesc);
            if (oldValue == null) continue;
            keysOverwritten.add(key);
        }
        HashSet keySetOrg = new HashSet(name2desc.keySet());
        Set<String> mainFilesIncluded = this.settings.getMainFilesIncluded();
        if (!mainFilesIncluded.isEmpty()) {
            if (!keySetOrg.containsAll(mainFilesIncluded)) {
                HashSet<String> includedNotMainFiles = new HashSet<String>(mainFilesIncluded);
                includedNotMainFiles.removeAll(keySetOrg);
                assert (!includedNotMainFiles.isEmpty());
                this.log.warn("WPP05: Included latex files which are not latex main files: " + includedNotMainFiles + ". ");
            }
            name2desc.keySet().retainAll(mainFilesIncluded);
        }
        if (!keySetOrg.containsAll(mainFilesExcluded = this.settings.getMainFilesExcluded())) {
            HashSet<String> excludedNotMainFiles = new HashSet<String>(mainFilesExcluded);
            excludedNotMainFiles.removeAll(keySetOrg);
            assert (!excludedNotMainFiles.isEmpty());
            this.log.warn("WPP06: Excluded latex files which are not latex main files: " + excludedNotMainFiles + ". ");
        }
        name2desc.keySet().removeAll(mainFilesExcluded);
        if (!mainFilesIncluded.isEmpty() || !mainFilesExcluded.isEmpty()) {
            HashSet<String> inclExcl = new HashSet<String>(mainFilesIncluded);
            inclExcl.addAll(mainFilesExcluded);
            inclExcl.retainAll(keysOverwritten);
            if (!inclExcl.isEmpty()) {
                this.log.warn("WPP07: Included/Excluded latex main files not identified by their name: " + inclExcl + ". ");
            }
            this.log.info("After inclusion/exclusion latex main files are " + name2desc.keySet() + ". ");
        }
        return name2desc.values();
    }

    private void processGraphicsSelectMain(File dir, DirNode node, Collection<String> skippedSuffixes, Collection<LatexMainDesc> latexMainDescs) throws BuildFailureException {
        assert (node.isValid());
        TreeSet<LatexMainDesc> latexMainDescsLocal = new TreeSet<LatexMainDesc>();
        TreeMap<File, SuffixHandler> file2handler = new TreeMap<File, SuffixHandler>();
        for (String fileName : node.getRegularFileNames()) {
            File file = new File(dir, fileName);
            if (file.isHidden()) {
                this.log.debug("Skipping hidden file '" + file + "'. ");
                continue;
            }
            String suffix = TexFileUtils.getSuffix(file);
            SuffixHandler handler = SUFFIX2HANDLER.get(suffix);
            if (handler == null) {
                this.log.debug("Skipping file '" + file + "' without handler. ");
                skippedSuffixes.add(suffix);
                continue;
            }
            handler.scheduleProcSrc(file, file2handler, this, latexMainDescsLocal);
        }
        latexMainDescs.addAll(latexMainDescsLocal);
        for (LatexMainDesc latexMainDesc : latexMainDescsLocal) {
            File lmFile = latexMainDesc.texFile;
            FileFilter filter = TexFileUtils.getFileFilter(lmFile, this.settings.getPatternCreatedFromLatexMain(), false);
            Iterator iter = file2handler.keySet().iterator();
            while (iter.hasNext()) {
                File src = (File)iter.next();
                if (!filter.accept(src)) continue;
                this.log.warn("WPP04: Skip processing '" + src + "': interpreted as target of '" + lmFile + "'. ");
                iter.remove();
            }
        }
        for (Map.Entry entry : file2handler.entrySet()) {
            ((SuffixHandler)((Object)entry.getValue())).procSrc((File)entry.getKey(), this);
        }
    }

    private void processGraphicsSelectMainRec(File dir, DirNode node, Collection<String> skipped, Collection<LatexMainDesc> latexMainDescs) throws BuildFailureException {
        this.processGraphicsSelectMain(dir, node, skipped, latexMainDescs);
        for (Map.Entry<String, DirNode> entry : node.getSubdirs().entrySet()) {
            this.processGraphicsSelectMainRec(new File(dir, entry.getKey()), entry.getValue(), skipped, latexMainDescs);
        }
    }

    void clearCreated(File texDir) {
        this.clearCreated(texDir, new DirNode(texDir, this.fileUtils));
    }

    private void clearCreated(File dir, DirNode node) {
        File file;
        assert (dir.isDirectory()) : "Expected existing directory " + dir + " to be cleared. ";
        TreeMap<File, SuffixHandler> file2handler = new TreeMap<File, SuffixHandler>();
        for (String string : node.getRegularFileNames()) {
            file = new File(dir, string);
            SuffixHandler handler = SUFFIX2HANDLER.get(TexFileUtils.getSuffix(file));
            if (handler == null) continue;
            handler.clearTarget(file, this, file2handler);
        }
        for (Map.Entry entry : file2handler.entrySet()) {
            file = (File)entry.getKey();
            if (!file.exists()) continue;
            ((SuffixHandler)((Object)entry.getValue())).clearTarget(file, this);
        }
        for (Map.Entry entry : node.getSubdirs().entrySet()) {
            this.clearCreated(new File(dir, (String)entry.getKey()), (DirNode)entry.getValue());
        }
    }

    static {
        for (SuffixHandler handler : SuffixHandler.values()) {
            SUFFIX2HANDLER.put(handler.getSuffix(), handler);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum SuffixHandler {
        fig{

            @Override
            void procSrc(File file, LatexPreProcessor proc) throws BuildFailureException {
                proc.runFig2Dev(file);
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc) {
                proc.clearTargetPtxPdfEps(file);
            }

            @Override
            String getSuffix() {
                return LatexPreProcessor.SUFFIX_FIG;
            }
        }
        ,
        gp{

            @Override
            void procSrc(File file, LatexPreProcessor proc) throws BuildFailureException {
                proc.runGnuplot2Dev(file);
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc) {
                proc.clearTargetPtxPdfEps(file);
            }

            @Override
            String getSuffix() {
                return LatexPreProcessor.SUFFIX_GP;
            }
        }
        ,
        mp{

            @Override
            void procSrc(File file, LatexPreProcessor proc) throws BuildFailureException {
                proc.runMetapost2mps(file);
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc) {
                proc.clearTargetMp(file);
            }

            @Override
            String getSuffix() {
                return LatexPreProcessor.SUFFIX_MP;
            }
        }
        ,
        svg{

            @Override
            void procSrc(File file, LatexPreProcessor proc) throws BuildFailureException {
                proc.runSvg2Dev(file);
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc) {
                proc.clearTargetPtxPdfEps(file);
            }

            @Override
            String getSuffix() {
                return LatexPreProcessor.SUFFIX_SVG;
            }
        }
        ,
        jpg{

            @Override
            void procSrc(File file, LatexPreProcessor proc) throws BuildFailureException {
                proc.runEbbByConfig(file);
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc) {
                proc.clearTargetJpgPng(file);
            }

            @Override
            String getSuffix() {
                return LatexPreProcessor.SUFFIX_JPG;
            }
        }
        ,
        png{

            @Override
            void procSrc(File file, LatexPreProcessor proc) throws BuildFailureException {
                proc.runEbbByConfig(file);
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc) {
                proc.clearTargetJpgPng(file);
            }

            @Override
            String getSuffix() {
                return LatexPreProcessor.SUFFIX_PNG;
            }
        }
        ,
        tex{

            @Override
            void scheduleProcSrc(File file, Map<File, SuffixHandler> file2handler, LatexPreProcessor proc, Collection<LatexMainDesc> latexMainDescs) {
                file2handler.put(file, this);
                proc.addIfLatexMain(file, latexMainDescs);
            }

            @Override
            void procSrc(File file, LatexPreProcessor proc) {
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc, Map<File, SuffixHandler> file2handler) {
                boolean isLatexMain = proc.clearTargetTexIfLatexMain(file);
                if (!isLatexMain) {
                    file2handler.put(file, this);
                }
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc) {
                proc.clearIfTexNoLatexMain(file);
            }

            @Override
            String getSuffix() {
                return LatexPreProcessor.SUFFIX_TEX;
            }
        }
        ,
        bib{

            @Override
            void procSrc(File file, LatexPreProcessor proc) {
                proc.log.info("Found bibliography file '" + file + "'. ");
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc, Map<File, SuffixHandler> file2handler) {
            }

            @Override
            void clearTarget(File file, LatexPreProcessor proc) {
                throw new IllegalStateException("File '" + file + "' has no targets to be cleared. ");
            }

            @Override
            String getSuffix() {
                return LatexPreProcessor.SUFFIX_BIB;
            }
        };


        void scheduleProcSrc(File file, Map<File, SuffixHandler> file2handler, LatexPreProcessor proc, Collection<LatexMainDesc> latexMainDescs) {
            file2handler.put(file, this);
        }

        abstract void procSrc(File var1, LatexPreProcessor var2) throws BuildFailureException;

        void clearTarget(File file, LatexPreProcessor proc, Map<File, SuffixHandler> file2handler) {
            file2handler.put(file, this);
        }

        abstract void clearTarget(File var1, LatexPreProcessor var2);

        abstract String getSuffix();
    }
}

