/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.LatexMainParameterNames;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

class LatexMainDesc
implements Comparable<LatexMainDesc> {
    final File texFile;
    final File pdfFile;
    final File dviFile;
    final File xdvFile;
    final File logFile;
    final File idxFile;
    final File indFile;
    final File ilgFile;
    final File glsFile;
    final File gloFile;
    final File glgFile;
    final File xxxFile;
    final File parentDir;
    private final Matcher matcher;

    private static boolean matches(Matcher matcher, LatexMainParameterNames name) {
        return matcher.group(name.toString()) != null;
    }

    private static void printGroups(Matcher matcher) {
        List names = Arrays.asList(LatexMainParameterNames.values()).stream().map(val -> val.toString()).collect(Collectors.toList());
        for (String name : names) {
            System.out.println(name + " |" + matcher.group(name) + "|");
        }
    }

    LatexMainDesc(File texFile, Matcher matcher) {
        this.matcher = matcher;
        this.texFile = texFile;
        this.xxxFile = TexFileUtils.replaceSuffix(texFile, "");
        this.pdfFile = this.withSuffix(".pdf");
        this.dviFile = this.withSuffix(".dvi");
        this.xdvFile = this.withSuffix(".xdv");
        this.logFile = this.withSuffix(".log");
        this.idxFile = this.withSuffix(".idx");
        this.indFile = this.withSuffix(".ind");
        this.ilgFile = this.withSuffix(".ilg");
        this.glsFile = this.withSuffix(".gls");
        this.gloFile = this.withSuffix(".glo");
        this.glgFile = this.withSuffix(".glg");
        this.parentDir = this.texFile.getParentFile();
    }

    Optional<String> groupMatch(LatexMainParameterNames groupName) {
        return Optional.ofNullable(this.matcher.group(groupName.toString()));
    }

    String getDocClass() {
        String res = this.matcher.group(LatexMainParameterNames.docClass.toString());
        assert (res != null);
        return res;
    }

    File withSuffix(String suffix) {
        return TexFileUtils.appendSuffix(this.xxxFile, suffix);
    }

    @Override
    public int compareTo(LatexMainDesc other) {
        return this.texFile.compareTo(other.texFile);
    }

    public String toString() {
        return "<LatexMainDesc>" + this.texFile.getName() + "</LatexMainDesc>";
    }
}

