/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.ConverterCategory;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum Converter {
    Maven{

        @Override
        String getCommand() {
            return "mvn";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^Apache Maven %s";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unparametrized;
        }
    }
    ,
    Ant{

        @Override
        String getCommand() {
            return "ant";
        }

        @Override
        String getVersionOption() {
            return "-version";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^Apache  Ant(TM) version %s";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unparametrized;
        }
    }
    ,
    Java{

        @Override
        String getCommand() {
            return "java";
        }

        @Override
        String getVersionPattern() {
            return Converter.V_JAVA;
        }

        @Override
        String getVersionEnvironment() {
            return "^openjdk %s \\d{4}-\\d{2}-\\\\d{2}";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unparametrized;
        }
    }
    ,
    PdfLatex{

        @Override
        String getCommand() {
            return "pdflatex";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^pdfTeX 3\\.[0-9]*-[0-9]+\\.[0-9]+-%s \\(TeX Live [0-9]{4}(?:/.+)?\\)";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.LaTeX;
        }
    }
    ,
    LuaLatex{

        @Override
        String getCommand() {
            return "lualatex";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is LuaHBTeX, Version %s \\(TeX Live [0-9]{4}(?:/.+)?\\)";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.LaTeX;
        }
    }
    ,
    XeLatex{

        @Override
        String getCommand() {
            return "xelatex";
        }

        @Override
        String getVersionPattern() {
            return "((0\\.[0-9]*))";
        }

        @Override
        String getVersionEnvironment() {
            return "^XeTeX 3\\.[0-9]*-[0-9]+\\.[0-9]+-%s \\(TeX Live [0-9]{4}(?:/.+)?\\)";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.LaTeX;
        }
    }
    ,
    Latex2rtf{

        @Override
        String getCommand() {
            return "latex2rtf";
        }

        @Override
        String getVersionOption() {
            return "-v";
        }

        @Override
        String getHelpOption() {
            return "-h";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]+)\\.([0-9]+)\\.([0-9]+) r([0-9]+))";
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " %s \\(released [A-Z][a-z]{2} [0-9]+, [0-9]{4}\\)\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.LaTeX2Rtf;
        }
    }
    ,
    Odt2doc{

        @Override
        String getCommand() {
            return "odt2doc";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^(?:.*\\R.*\\R)?unoconv %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Odt2Doc;
        }
    }
    ,
    Pdf2txt{

        @Override
        String getCommand() {
            return "pdftotext";
        }

        @Override
        String getVersionOption() {
            return "-v";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " version %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Pdf2Txt;
        }
    }
    ,
    Dvips{

        @Override
        String getCommand() {
            return "dvips";
        }

        @Override
        String getVersionOption() {
            return "-v";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9\\.]{4})\\.([0-9]))";
        }

        @Override
        String getVersionEnvironment() {
            return "^This is " + this.getCommand() + "\\(k\\) %s (?:\\(TeX Live [0-9]+\\)  )?Copyright [0-9]+ Radical Eye Software \\(www\\.radicaleye\\.com\\)\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unspecific;
        }
    }
    ,
    Dvipdfm{

        @Override
        String getCommand() {
            return "dvipdfm";
        }

        @Override
        String getVersionPattern() {
            return Converter.VYYYYMMDD;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is " + this.getCommand() + " Version %s by the DVIPDFMx project team,\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Dvi2Pdf;
        }
    }
    ,
    Dvipdfmx{

        @Override
        String getCommand() {
            return "dvipdfmx";
        }

        @Override
        String getVersionPattern() {
            return Converter.VYYYYMMDD;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is " + this.getCommand() + " Version %s by the DVIPDFMx project team,\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Dvi2Pdf;
        }
    }
    ,
    XDvipdfmx{

        @Override
        String getCommand() {
            return "xdvipdfmx";
        }

        @Override
        String getVersionPattern() {
            return Converter.VYYYYMMDD;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is " + this.getCommand() + " Version %s by the DVIPDFMx project team,\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Dvi2Pdf;
        }
    }
    ,
    Dvipdft{

        @Override
        String getCommand() {
            return "dvipdft";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]{4})([0-9]{2})([0-9]{2})\\.([0-9]{4}))";
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " version %s by Thomas Esser and others\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Dvi2Pdf;
        }
    }
    ,
    GS{

        @Override
        String getCommand() {
            return "gs";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^%s";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unspecific;
        }
    }
    ,
    ChkTeX{

        @Override
        String getCommand() {
            return "chktex";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + ChkTeX + " v%s - Copyright [0-9]{4}-[0-9]{2} Jens T. Berger Thielemann.\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.LatexChk;
        }
    }
    ,
    DiffPdfVisualLy{

        @Override
        String getCommand() {
            return "diff-pdf-visually";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " %s";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.DiffPdf;
        }
    }
    ,
    DiffPdf{

        @Override
        String getCommand() {
            return "diff-pdf";
        }

        @Override
        String getVersionOption() {
            return "-h";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX;
        }

        @Override
        String getVersionEnvironment() {
            return "^Usage: .*\\R.*\\R.*\\R.*\\R.*\\R.*\\R.*\\R.*\\R.*\\w*rasterization resolution \\(default: %s dpi\\)";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.DiffPdf;
        }
    }
    ,
    Diff{

        @Override
        String getCommand() {
            return "diff";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " \\(GNU diffutils\\) %s";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.DiffPdf;
        }
    }
    ,
    PdfInfo{

        @Override
        String getCommand() {
            return "pdfinfo";
        }

        @Override
        String getVersionOption() {
            return "-v";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " version %s";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unspecific;
        }
    }
    ,
    ExifTool{

        @Override
        String getCommand() {
            return "exiftool";
        }

        @Override
        String getVersionOption() {
            return "-ver";
        }

        @Override
        String getHelpOption() {
            return "-h";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^%s";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unspecific;
        }
    }
    ,
    BibTeX{

        @Override
        String getCommand() {
            return "bibtex";
        }

        @Override
        String getVersionPattern() {
            return "((0\\.[0-9]*)([a-z]))";
        }

        @Override
        String getVersionEnvironment() {
            return "^" + BibTeX + " %s \\(TeX Live [0-9]{4}(?:/.+)?\\)";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.BibTeX;
        }
    }
    ,
    BibTeXu{

        @Override
        String getCommand() {
            return "bibtexu";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is " + BibTeXu + ": a UTF-8 Big " + BibTeX + " version .* \\(TeX Live [0-9]{4}\\)\\RImplementation: .*\\RRelease version: %s \\([0-9]{2} [a-z]{3} [0-9]{4}\\)\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.BibTeX;
        }
    }
    ,
    BibTeX8{

        @Override
        String getCommand() {
            return "bibtex8";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is 8-bit Big " + BibTeX + " version .* \\(TeX Live [0-9]{4}\\)\\RImplementation: .*\\RRelease version: %s \\([0-9]{2} [a-z]{3} [0-9]{4}\\)\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.BibTeX;
        }
    }
    ,
    Makeindex{

        @Override
        String getCommand() {
            return "makeindex";
        }

        @Override
        String getVersionOption() {
            return TexFileUtils.getEmptyIdx().getName().toString();
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is " + this.getCommand() + ", version %s \\[TeX Live [0-9]{4}\\] \\(kpathsea \\+ Thai support\\).\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.MakeIndex;
        }
    }
    ,
    Upmendex{

        @Override
        String getCommand() {
            return "upmendex";
        }

        @Override
        String getVersionOption() {
            return "-h";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " - index processor, version %s \\(TeX Live [0-9]{4}\\).\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unspecific;
        }
    }
    ,
    Splitindex{

        @Override
        String getCommand() {
            return "splitindex";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + ".pl %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.SplitIndex;
        }
    }
    ,
    Xindy{

        @Override
        String getCommand() {
            return "xindy";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " release: %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unspecific;
        }
    }
    ,
    Makeglossaries{

        @Override
        String getCommand() {
            return "makeglossaries";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + Makeglossaries + " Version %s \\([0-9]{4}-[0-9]{2}-[0-9]{2}\\)\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.MakeGlossaries;
        }
    }
    ,
    PythonTeX{

        @Override
        String getCommand() {
            return "pythontex";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + PythonTeX + " %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Pythontex;
        }
    }
    ,
    DePythonTeX{

        @Override
        String getCommand() {
            return "depythontex";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + DePythonTeX + " %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.DePythontex;
        }
    }
    ,
    Latexmk{

        @Override
        String getCommand() {
            return "latexmk";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]+)\\.([0-9]+)([a-z]?))";
        }

        @Override
        String getVersionEnvironment() {
            return "^(?:.*\\R)*" + Latexmk + ", John Collins, .*[0-9]+ [A-Z][a-z]+\\.? [0-9]+. Version %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Unspecific;
        }
    }
    ,
    MetaPost{

        @Override
        String getCommand() {
            return "mpost";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^" + MetaPost + " %s \\(TeX Live [0-9]{4}(?:/.+)?\\)";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.MetaPost;
        }
    }
    ,
    Ebb{

        @Override
        String getCommand() {
            return "ebb";
        }

        @Override
        String getVersionPattern() {
            return Converter.VYYYYMMDD;
        }

        @Override
        String getVersionEnvironment() {
            return "^.*\\RThis is " + this.getCommand() + " Version %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.EbbCmd;
        }
    }
    ,
    Gnuplot{

        @Override
        String getCommand() {
            return "gnuplot";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]+)\\.([0-9]+) patchlevel ([0-9]+))";
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Gnuplot2Dev;
        }
    }
    ,
    Inkscape{

        @Override
        String getCommand() {
            return "inkscape";
        }

        @Override
        String getVersionPattern() {
            return Converter.VX_X__X;
        }

        @Override
        String getVersionEnvironment() {
            return "^(?:.*\\R)?" + Inkscape + " %s \\([0-9a-f]+, [0-9]{4}-[0-9]{2}-[0-9]{2}\\)\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Svg2Dev;
        }
    }
    ,
    Fig2Dev{

        @Override
        String getCommand() {
            return "fig2dev";
        }

        @Override
        String getVersionOption() {
            return "-V";
        }

        @Override
        String getHelpOption() {
            return "-h";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]+)\\.([0-9]+)\\.([0-9]+)([a-z])?)";
        }

        @Override
        String getVersionEnvironment() {
            return "^" + this.getCommand() + " Version %s\\R";
        }

        @Override
        ConverterCategory getCategory() {
            return ConverterCategory.Fig2Dev;
        }
    };

    private static final String X_X_X = "(([0-9]+)\\.([0-9]+)\\.([0-9]+))";
    private static final String VX_X__X = "(([0-9]+)\\.([0-9]+)(?:\\.([0-9]+))?)";
    private static final String V_JAVA = "(([0-9]+)(?:\\.([0-9]+))?(?:\\.([0-9]+))?(?:\\\\.([0-9]+))?)";
    private static final String VX_X = "(([0-9]+)\\.([0-9]+))";
    private static final String VX = "(([0-9]+))";
    private static final String VYYYYMMDD = "(([0-9]{4})([0-9]{2})([0-9]{2}))";
    private static final Map<String, Converter> cmd2conv;

    public static Converter cmd2Conv(String cmd) {
        return cmd2conv.get(cmd);
    }

    static String toCommandsString(Collection<Converter> convs) {
        return convs.stream().map(x -> x.getCommand()).collect(Collectors.joining(", "));
    }

    static String toCommandsString() {
        return Converter.toCommandsString(Arrays.asList(Converter.values()));
    }

    abstract String getCommand();

    String getVersionOption() {
        return "--version";
    }

    String getHelpOption() {
        return "--help";
    }

    abstract String getVersionPattern();

    abstract String getVersionEnvironment();

    abstract ConverterCategory getCategory();

    String getVersionInfo(CommandExecutor executor) throws BuildFailureException {
        return executor.execute((File)TexFileUtils.getEmptyIdx().getParentFile(), null, (String)this.getCommand(), (String[])new String[]{this.getVersionOption()}, (File[])new File[0]).output;
    }

    static {
        cmd2conv = new HashMap<String, Converter>();
        for (Converter conv : Converter.values()) {
            cmd2conv.put(conv.getCommand(), conv);
        }
    }
}

