/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.LatexMainParameterNames;
import eu.simuline.m2latex.core.LogWrapper;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.util.Optional;
import java.util.regex.Matcher;

class LatexMainDesc
implements Comparable<LatexMainDesc> {
    final File texFile;
    final File pdfFile;
    final File dviFile;
    final File xdvFile;
    final File logFile;
    final File idxFile;
    final File indFile;
    final File ilgFile;
    final File glsFile;
    final File gloFile;
    final File glgFile;
    final File xxxFile;
    final File parentDir;
    private final Matcher matcher;

    private static boolean matches(Matcher matcher, LatexMainParameterNames name) {
        boolean res = matcher.group(name.toString()) != null;
        System.out.println("group match " + res + " " + name);
        return res;
    }

    static Optional<LatexMainDesc> getLatexMain(File texFile, Matcher matcher) {
        LatexMainDesc.matches(matcher, LatexMainParameterNames.dummy);
        System.out.println("dummy |" + matcher.group(LatexMainParameterNames.dummy.toString()) + "|");
        return LatexMainDesc.matches(matcher, LatexMainParameterNames.programMagic) || LatexMainDesc.matches(matcher, LatexMainParameterNames.targetsMagic) || LatexMainDesc.matches(matcher, LatexMainParameterNames.docClassMagic) || LatexMainDesc.matches(matcher, LatexMainParameterNames.docClass) ? Optional.of(new LatexMainDesc(texFile, matcher)) : Optional.empty();
    }

    LatexMainDesc(File texFile, Matcher matcher) {
        this.matcher = matcher;
        this.texFile = texFile;
        this.xxxFile = TexFileUtils.replaceSuffix(texFile, "");
        this.pdfFile = this.withSuffix(".pdf");
        this.dviFile = this.withSuffix(".dvi");
        this.xdvFile = this.withSuffix(".xdv");
        this.logFile = this.withSuffix(".log");
        this.idxFile = this.withSuffix(".idx");
        this.indFile = this.withSuffix(".ind");
        this.ilgFile = this.withSuffix(".ilg");
        this.glsFile = this.withSuffix(".gls");
        this.gloFile = this.withSuffix(".glo");
        this.glgFile = this.withSuffix(".glg");
        this.parentDir = this.texFile.getParentFile();
    }

    String groupMatch(LatexMainParameterNames groupName) {
        return this.matcher.group(groupName.toString());
    }

    Optional<String> getDocClass(LogWrapper log) {
        String docClassMagic = this.groupMatch(LatexMainParameterNames.docClassMagic);
        String docClass = this.groupMatch(LatexMainParameterNames.docClass);
        if (docClassMagic != null) {
            if (docClass != null) {
                log.warn("XXXX: Doc class in magic comment '" + docClassMagic + "'' overwrites '" + docClass + "' in documentclass/style. ");
            }
            return Optional.of(docClassMagic);
        }
        return Optional.ofNullable(docClass);
    }

    File withSuffix(String suffix) {
        return TexFileUtils.appendSuffix(this.xxxFile, suffix);
    }

    @Override
    public int compareTo(LatexMainDesc other) {
        return this.texFile.compareTo(other.texFile);
    }

    public String toString() {
        return "<LatexMainDesc>" + this.texFile.getName() + "</LatexMainDesc>";
    }
}

