/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.LatexMainParameterNames;
import java.util.regex.Matcher;

public class FileMatch {
    private static final FileMatch UNREADABLE = new FileMatch();
    private static final FileMatch NO_MATCH = new FileMatchReadableNoMatch();

    private FileMatch() {
    }

    static FileMatch unreadable() {
        return UNREADABLE;
    }

    static FileMatch noMatch() {
        return NO_MATCH;
    }

    static FileMatch matches(Matcher matcher) {
        return new FileMatchWithMatcher(matcher);
    }

    boolean isFileReadable() {
        return false;
    }

    boolean doesExprMatch() {
        throw new IllegalStateException("Unreadable cannot be asked for match. ");
    }

    Matcher getMatcher() {
        throw new IllegalStateException("No group matched. ");
    }

    boolean matches(LatexMainParameterNames paramName) {
        throw new IllegalStateException("XXXX. ");
    }

    String get(LatexMainParameterNames paramName) {
        throw new IllegalStateException("XXXX. ");
    }

    static class FileMatchWithMatcher
    extends FileMatch {
        private final Matcher matcher;

        FileMatchWithMatcher(Matcher matcher) {
            assert (matcher.matches());
            this.matcher = matcher;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return true;
        }

        @Override
        Matcher getMatcher() {
            return this.matcher;
        }

        @Override
        boolean matches(LatexMainParameterNames paramName) {
            return this.matcher.group(paramName.toString()) != null;
        }

        @Override
        String get(LatexMainParameterNames paramName) {
            return this.matcher.group(paramName.toString());
        }
    }

    static class FileMatchReadableNoMatch
    extends FileMatch {
        private FileMatchReadableNoMatch() {
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return false;
        }
    }
}

