/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.LatexMainParameterNames;
import java.util.regex.Matcher;

public class FileMatch {
    private static final FileMatch UNREADABLE = new FileMatch();
    private static final FileMatch NO_MATCH = new FileMatchReadableNoMatch();

    private FileMatch() {
    }

    static FileMatch unreadable() {
        return UNREADABLE;
    }

    static FileMatch noMatch() {
        return NO_MATCH;
    }

    static FileMatch matches(Matcher matcher) {
        return new FileMatchWithMatcher(matcher);
    }

    boolean isFileReadable() {
        return false;
    }

    boolean doesExprMatch() {
        throw new IllegalStateException("Unreadable cannot be asked for match. ");
    }

    String groupMatch(LatexMainParameterNames groupName) {
        throw new IllegalStateException("No group matched. ");
    }

    static class FileMatchReadableNoMatch
    extends FileMatch {
        private FileMatchReadableNoMatch() {
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return false;
        }
    }

    static class FileMatchWithMatcher
    extends FileMatch {
        private final Matcher matcher;

        FileMatchWithMatcher(Matcher matcher) {
            assert (matcher.matches());
            this.matcher = matcher;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return true;
        }

        @Override
        String groupMatch(LatexMainParameterNames groupName) {
            return this.matcher.group(groupName.toString());
        }
    }
}

