/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import java.util.regex.Matcher;

public class FileMatch {
    private static final FileMatch UNREADABLE = new FileMatch();
    private static final FileMatch NO_MATCH = new FileMatchReadableNoMatch();

    private FileMatch() {
    }

    static FileMatch unreadable() {
        return UNREADABLE;
    }

    static FileMatch noMatch() {
        return NO_MATCH;
    }

    static FileMatch matches(Matcher matcher) {
        return new FileMatchWithMatcher(matcher);
    }

    boolean isFileReadable() {
        return false;
    }

    boolean doesExprMatch() {
        throw new IllegalStateException("Unreadable cannot be asked for match. ");
    }

    String groupMatch() {
        throw new IllegalStateException("No group matched. ");
    }

    static class FileMatchWithMatcher
    extends FileMatch {
        private final Matcher matcher;

        FileMatchWithMatcher(Matcher matcher) {
            this.matcher = matcher;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return true;
        }

        @Override
        String groupMatch() {
            return this.matcher.group("class");
        }
    }

    static class FileMatchReadableNoMatch
    extends FileMatch {
        private FileMatchReadableNoMatch() {
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return false;
        }
    }
}

