/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import java.util.regex.Matcher;

public class FileMatch {
    private static final FileMatch UNREADABLE = new FileMatch();
    private static final FileMatch DO_MATCH = new FileMatchReadable(true);
    private static final FileMatch NO_MATCH = new FileMatchReadable(false);

    private FileMatch() {
    }

    static FileMatch unreadable() {
        return UNREADABLE;
    }

    static FileMatch matches(boolean matches) {
        return matches ? DO_MATCH : NO_MATCH;
    }

    static FileMatch matches(Matcher matcher) {
        return new FileMatchWithMatcher(matcher);
    }

    boolean isFileReadable() {
        return false;
    }

    boolean doesExprMatch() {
        throw new IllegalStateException("Unreadable cannot be asked for match. ");
    }

    String groupMatch() {
        throw new IllegalStateException("No group matched. ");
    }

    static class FileMatchReadable
    extends FileMatch {
        private final boolean matches;

        private FileMatchReadable(boolean matches) {
            this.matches = matches;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return this.matches;
        }
    }

    static class FileMatchWithMatcher
    extends FileMatch {
        private final Matcher matcher;

        FileMatchWithMatcher(Matcher matcher) {
            this.matcher = matcher;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return true;
        }

        @Override
        String groupMatch() {
            return this.matcher.group("class");
        }
    }
}

