/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

public class FileMatch {
    private static final FileMatch UNREADABLE = new FileMatch();
    private static final FileMatch DO_MATCH = new FileMatchReadable(true);
    private static final FileMatch NO_MATCH = new FileMatchReadable(false);

    private FileMatch() {
    }

    static FileMatch unreadable() {
        return UNREADABLE;
    }

    static FileMatch matches(boolean matches) {
        return matches ? DO_MATCH : NO_MATCH;
    }

    static FileMatch matches(String grpString) {
        return new FileMatchGrouped(grpString);
    }

    boolean isFileReadable() {
        return false;
    }

    boolean doesExprMatch() {
        throw new IllegalStateException("Unreadable cannot be asked for match. ");
    }

    String groupMatch() {
        throw new IllegalStateException("No group matched. ");
    }

    static class FileMatchGrouped
    extends FileMatch {
        String grpString;

        FileMatchGrouped(String grpString) {
            this.grpString = grpString;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return true;
        }

        @Override
        String groupMatch() {
            return this.grpString;
        }
    }

    static class FileMatchReadable
    extends FileMatch {
        private final boolean matches;

        private FileMatchReadable(boolean matches) {
            this.matches = matches;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean doesExprMatch() {
            return this.matches;
        }
    }
}

