/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

public class FileMatch {
    private FileMatch() {
    }

    static FileMatch unreadable() {
        return new FileMatch();
    }

    static FileMatch matches(boolean matches) {
        return new FileMatchReadable(matches);
    }

    static FileMatch matches(String grpString) {
        return new FileMatchGrouped(grpString);
    }

    boolean isFileReadable() {
        return false;
    }

    boolean matches() {
        throw new IllegalStateException("Unreadable cannot be asked for match. ");
    }

    String group() {
        throw new IllegalStateException("No group matched. ");
    }

    static class FileMatchGrouped
    extends FileMatch {
        String grpString;

        FileMatchGrouped(String grpString) {
            this.grpString = grpString;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean matches() {
            return true;
        }

        @Override
        String group() {
            return this.grpString;
        }
    }

    static class FileMatchReadable
    extends FileMatch {
        private final boolean matches;

        private FileMatchReadable(boolean matches) {
            this.matches = matches;
        }

        @Override
        boolean isFileReadable() {
            return true;
        }

        @Override
        boolean matches() {
            return this.matches;
        }
    }
}

