/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.DirNode;
import eu.simuline.m2latex.core.Injection;
import eu.simuline.m2latex.core.LogWrapper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

class TexFileUtils {
    private static final String PATTERN_INS_LATEX_MAIN = "T\\$T";
    static final String PREFIX_PYTEX_OUT_FOLDER = "pythontex-files-";
    private final LogWrapper log;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String INKSCAPE_PREAMBLE = "%% LatexMavenPlugin (version unknown) modified two of the following lines\n";
    private static File EMPTY_IDX;
    static final String SUFFIX_IDX = ".idx";
    static final String SUFFIX_IND = ".ind";
    static final String SUFFIX_ILG = ".ilg";
    static final String HEADLINE_GEN = " injection file written by latex plugin ";

    TexFileUtils(LogWrapper log) {
        this.log = log;
    }

    File[] listFilesOrWarn(File dir) {
        assert (dir != null && dir.isDirectory()) : "Expected folder found " + String.valueOf(dir);
        File[] files = dir.listFiles();
        this.warnIfNull(files, dir);
        return files;
    }

    File[] listFilesOrWarn(File dir, FileFilter filter) {
        assert (dir != null && dir.isDirectory()) : "Expected folder found " + String.valueOf(dir);
        File[] files = dir.listFiles(filter);
        this.warnIfNull(files, dir);
        return files;
    }

    private void warnIfNull(File[] files, File dir) {
        if (files == null) {
            this.log.warn("WFU01: Cannot read directory '" + String.valueOf(dir) + "'; build may be incomplete. ");
        }
    }

    File getTargetDirectory(File srcFile, File srcBaseDir, File targetBaseDir) throws BuildFailureException {
        Path srcParentPath = srcFile.getParentFile().toPath();
        Path srcBasePath = srcBaseDir.toPath();
        assert (srcParentPath.startsWith(srcBasePath));
        srcParentPath = srcBasePath.relativize(srcParentPath);
        File targetDir = new File(targetBaseDir, srcParentPath.toString());
        targetDir.mkdirs();
        if (!targetDir.isDirectory()) {
            throw new BuildFailureException("TFU01: Cannot create destination directory '" + String.valueOf(targetDir) + "'. ");
        }
        assert (targetDir.isDirectory());
        return targetDir;
    }

    static File getPdfFileDiff(File pdfFileAct, File artifactBaseDir, File diffBaseDir) {
        Path pdfFileActPath = pdfFileAct.toPath();
        Path artifactBasePath = artifactBaseDir.toPath();
        assert (pdfFileActPath.startsWith(artifactBasePath));
        pdfFileActPath = artifactBasePath.relativize(pdfFileActPath);
        return new File(diffBaseDir, pdfFileActPath.toString());
    }

    static FileFilter getFileFilter(final File texFile, String pattern, final boolean allowsDirs) {
        final String patternAccept = pattern.replaceAll(PATTERN_INS_LATEX_MAIN, TexFileUtils.getFileNameWithoutSuffix(texFile));
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory() && !allowsDirs || file.equals(texFile)) {
                    return false;
                }
                return file.getName().matches(patternAccept);
            }
        };
    }

    FileFilter getFileFilterReplace(File idxFile, String pattern) {
        final String patternAccept = TexFileUtils.getFileNameWithoutSuffix(idxFile) + pattern + TexFileUtils.getSuffix(idxFile);
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return file.getName().matches(patternAccept);
            }
        };
    }

    Set<File> copyOutputToTargetFolder(File texFile, FileFilter fileFilter, File targetDir) throws BuildFailureException {
        HashSet<File> targetFiles = new HashSet<File>();
        assert (texFile.exists() && !texFile.isDirectory()) : "Expected existing (regular) tex file " + String.valueOf(texFile);
        assert (!targetDir.exists() || targetDir.isDirectory()) : "Expected existing target folder " + String.valueOf(targetDir);
        File texFileDir = texFile.getParentFile();
        File[] outputFiles = this.listFilesOrWarn(texFileDir);
        if (outputFiles == null) {
            return targetFiles;
        }
        assert (outputFiles != null);
        int idx = 0;
        while (idx < outputFiles.length) {
            File srcFile = outputFiles[idx];
            assert (srcFile.exists()) : "Missing " + String.valueOf(srcFile);
            if (fileFilter.accept(srcFile)) {
                assert (srcFile.exists() && !srcFile.isDirectory()) : "Expected existing (regular) tex file " + String.valueOf(texFile);
                assert (!srcFile.equals(targetDir));
                assert (!srcFile.equals(texFile));
                File destFile = new File(targetDir, srcFile.getName());
                if (destFile.isDirectory()) {
                    throw new BuildFailureException("TFU04: Cannot overwrite directory '" + String.valueOf(destFile) + "'. ");
                }
                this.log.debug("Copying '" + srcFile.getName() + "' to '" + String.valueOf(targetDir) + "'. ");
                try {
                    this.doCopyFile(srcFile, destFile);
                    targetFiles.add(destFile);
                }
                catch (IOException e) {
                    throw new BuildFailureException("TFU06: Cannot copy '" + srcFile.getName() + "' to '" + String.valueOf(targetDir) + "'. ", e);
                }
            }
            ++idx;
        }
        return targetFiles;
    }

    private void doCopyFile(File srcFile, File destFile) throws IOException {
        FileInputStream input = new FileInputStream(srcFile);
        try {
            FileOutputStream output = new FileOutputStream(destFile);
            try {
                TexFileUtils.copyStream(input, output);
            }
            finally {
                this.closeQuietly(output);
            }
        }
        finally {
            this.closeQuietly(input);
        }
        assert (!destFile.isDirectory() && destFile.canWrite()) : "Expected existing (regular) writable file " + String.valueOf(destFile);
        destFile.setLastModified(srcFile.lastModified());
    }

    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    private void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException ioe) {
            this.log.warn("WFU03: Cannot close '" + String.valueOf(closeable) + "'. ", ioe);
        }
    }

    public void filterInkscapeIncludeFile(File srcFile, File destFile, String bareFileName, String epsSuffix) {
        block10: {
            BufferedReader bufferedReader = null;
            FileWriter writer = null;
            try {
                FileReader reader = new FileReader(srcFile);
                bufferedReader = new BufferedReader(reader);
                writer = new FileWriter(destFile);
                writer.write(INKSCAPE_PREAMBLE);
                String line = bufferedReader.readLine();
                writer.write(line + "\n");
                line = bufferedReader.readLine();
                writer.write(line + "\n");
                line = bufferedReader.readLine();
                line = line.replace(bareFileName + epsSuffix + "' (pdf, eps, ps)", bareFileName + ".pdf/eps/ps'\n");
                writer.write(line);
                int idx = 4;
                while (idx < 56) {
                    line = bufferedReader.readLine();
                    writer.write(line + "\n");
                    ++idx;
                }
                line = bufferedReader.readLine();
                line = line.replace(bareFileName + epsSuffix + "}}%", bareFileName + "}}%\n");
                writer.write(line);
                line = bufferedReader.readLine();
                do {
                    writer.write(line + "\n");
                } while ((line = bufferedReader.readLine()) != null);
            }
            catch (IOException e) {
                block9: {
                    if (bufferedReader == null) {
                        this.log.error("EFU07: File '" + String.valueOf(srcFile) + "' to be filtered cannot be read. ");
                        this.closeQuietly(bufferedReader);
                        this.closeQuietly(writer);
                        return;
                    }
                    try {
                        if (writer != null) break block9;
                        this.log.error("EFU08: Destination file '" + String.valueOf(destFile) + "' for filtering cannot be written. ");
                        this.closeQuietly(bufferedReader);
                        this.closeQuietly(writer);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.closeQuietly(bufferedReader);
                        this.closeQuietly(writer);
                        throw throwable;
                    }
                }
                this.log.error("EFU09: Cannot filter file '" + String.valueOf(srcFile) + "' into '" + String.valueOf(destFile) + "'. ");
                this.closeQuietly(bufferedReader);
                this.closeQuietly(writer);
                break block10;
            }
            this.closeQuietly(bufferedReader);
            this.closeQuietly(writer);
        }
    }

    static String getFileNameWithoutSuffix(File file) {
        String nameFile = file.getName();
        int idxDot = nameFile.lastIndexOf(".");
        return idxDot == -1 ? nameFile : nameFile.substring(0, idxDot);
    }

    static String getSuffix(File file) {
        return TexFileUtils.getSuffix(file, true);
    }

    static String getSuffix(File file, boolean withDot) {
        String nameFile = file.getName();
        int idxDot = nameFile.lastIndexOf(".");
        if (idxDot == -1) {
            return "";
        }
        if (!withDot) {
            ++idxDot;
        }
        return nameFile.substring(idxDot, nameFile.length());
    }

    Boolean matchInFile(File file, String regex) {
        return this.matchInFile(file, regex, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Boolean matchInFile(File file, String regex, String groupName) {
        Pattern pattern = Pattern.compile(regex, 8);
        boolean fromStart = regex.startsWith("\\A");
        Object lines = "";
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String line = bufferedReader.readLine();
                while (true) {
                    if (line == null) {
                        Boolean bl = false;
                        return bl;
                    }
                    lines = fromStart ? (lines = (String)lines + "\n" + line) : line;
                    Matcher matcher = pattern.matcher((CharSequence)lines);
                    if (matcher.find()) {
                        if (groupName != null) {
                            System.out.println("found class: " + matcher.group(groupName));
                        }
                        Boolean bl = true;
                        return bl;
                    }
                    line = bufferedReader.readLine();
                }
            }
            catch (IOException ioe) {
                return null;
            }
            finally {
                this.closeQuietly(bufferedReader);
            }
        }
        catch (FileNotFoundException ffe) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Collection<String> collectMatches(File file, String regex, int idxGroup) {
        TreeSet<String> res = new TreeSet<String>();
        Pattern pattern = Pattern.compile(regex);
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String line = bufferedReader.readLine();
                while (true) {
                    if (line == null) {
                        TreeSet<String> treeSet = res;
                        return treeSet;
                    }
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.find()) {
                        res.add(matcher.group(idxGroup));
                    }
                    line = bufferedReader.readLine();
                }
            }
            catch (IOException ioe) {
                return null;
            }
            finally {
                this.closeQuietly(bufferedReader);
            }
        }
        catch (FileNotFoundException ffe) {
            return null;
        }
    }

    static File replaceSuffix(File file, String suffix) {
        return new File(file.getParentFile(), TexFileUtils.getFileNameWithoutSuffix(file) + suffix);
    }

    static File replacePrefix(String prefix, File file) {
        return new File(file.getParentFile(), prefix + file.getName());
    }

    static File appendSuffix(File file, String suffix) {
        return new File(file.getParentFile(), file.getName() + suffix);
    }

    void deleteX(File pFile, FileFilter filter, boolean allowsDirs) {
        assert (pFile.exists() && !pFile.isDirectory()) : "Expected existing (regular) file " + String.valueOf(pFile);
        File dir = pFile.getParentFile();
        File[] found = this.listFilesOrWarn(dir);
        if (found == null) {
            return;
        }
        File[] fileArray = found;
        int n = found.length;
        int n2 = 0;
        while (n2 < n) {
            File delFile = fileArray[n2];
            assert (delFile.exists());
            if (filter.accept(delFile)) {
                assert (delFile.exists() && (!delFile.isDirectory() || allowsDirs)) : "Expected existing (regular) file " + String.valueOf(delFile);
                this.deleteOrError(delFile, allowsDirs);
            }
            ++n2;
        }
    }

    void deleteOrError(File delFile, boolean allowsDirs) {
        assert (delFile.exists() && (!delFile.isDirectory() || allowsDirs)) : "Expected existing (regular) file " + String.valueOf(delFile);
        if (!FileUtils.deleteQuietly((File)delFile)) {
            this.log.error("EFU05: Cannot delete file '" + String.valueOf(delFile) + "'. ");
        }
    }

    void moveOrError(File fromFile, File toFile) {
        assert (fromFile.exists() && !fromFile.isDirectory()) : "Expected existing (regular) source file " + String.valueOf(fromFile);
        assert (!toFile.isDirectory()) : "Expected (regular) target file " + String.valueOf(toFile);
        boolean success = fromFile.renameTo(toFile);
        if (!success) {
            this.log.error("EFU06: Cannot move file '" + String.valueOf(fromFile) + "' to '" + String.valueOf(toFile) + "'. ");
        }
    }

    void cleanUp(DirNode orgNode, File texDir) {
        this.cleanUpRec(texDir, orgNode, new DirNode(texDir, this));
    }

    private void cleanUpRec(File dir, DirNode origNode, DirNode currNode) {
        File file;
        Set<String> origSubdirs = origNode.getSubdirs().keySet();
        TreeSet<String> currSubdirs = new TreeSet<String>(currNode.getSubdirs().keySet());
        boolean containsAll = currSubdirs.containsAll(origSubdirs);
        assert (containsAll);
        currSubdirs.removeAll(origSubdirs);
        TreeSet<String> diffSet = currSubdirs;
        String regex = "pythontex-files-.+";
        for (String name : diffSet) {
            assert (name.matches(regex));
            System.out.println("del: " + String.valueOf(new File(dir, name)));
            this.deleteOrError(new File(dir, name), true);
        }
        for (String key : origNode.getSubdirs().keySet()) {
            file = new File(dir, key);
            this.cleanUpRec(file, origNode.getSubdirs().get(key), currNode.getSubdirs().get(key));
        }
        Set<String> currFileNames = currNode.getRegularFileNames();
        currFileNames.removeAll(origNode.getRegularFileNames());
        for (String fileName : currFileNames) {
            file = new File(dir, fileName);
            this.deleteOrError(file, false);
        }
    }

    static File getEmptyIdx() {
        if (EMPTY_IDX == null) {
            try {
                EMPTY_IDX = File.createTempFile("forMakeindex", SUFFIX_IDX);
                EMPTY_IDX.deleteOnExit();
                TexFileUtils.replaceSuffix(EMPTY_IDX, SUFFIX_IND).deleteOnExit();
                TexFileUtils.replaceSuffix(EMPTY_IDX, SUFFIX_ILG).deleteOnExit();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create temp file.");
            }
        }
        return EMPTY_IDX;
    }

    boolean isCreatedByMyself(File aFile, Injection inj) {
        block5: {
            assert (aFile.exists()) : "File " + String.valueOf(aFile) + " expected to exist. ";
            try {
                if (aFile.isDirectory()) break block5;
                BufferedReader reader = new BufferedReader(new FileReader(aFile));
                String headline = reader.readLine();
                if (inj.hasShebang()) {
                    headline = reader.readLine();
                }
                reader.close();
                if (headline == null || !headline.startsWith(inj.commentStr() + HEADLINE_GEN)) break block5;
                return true;
            }
            catch (IOException ioe) {
                this.log.warn("WFU11: Refuse to overwrite/clean file '" + String.valueOf(aFile) + "' because it may be not self-created or has dangling reader. ");
                return false;
            }
        }
        this.log.warn("WFU10: Cannot overwrite/clean file '" + String.valueOf(aFile) + "' because it is not self-created. ");
        return false;
    }

    public static void main(String[] args) {
        String regex = args[0];
        String text = args[1];
        text = "xx\nyzzz";
        System.out.println("regex: " + regex);
        System.out.println("text: " + text);
        System.out.println("len: " + text.length());
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(text);
        matcher.useAnchoringBounds(true);
        System.out.println("find:   " + matcher.find());
        System.out.println("hitEnd: " + matcher.hitEnd());
        System.out.println("hitEnd: " + matcher.end());
    }
}

