/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;

class LatexMainDesc
implements Comparable<LatexMainDesc> {
    final File texFile;
    final File pdfFile;
    final File dviFile;
    final File xdvFile;
    final File logFile;
    final File idxFile;
    final File indFile;
    final File ilgFile;
    final File glsFile;
    final File gloFile;
    final File glgFile;
    final File xxxFile;
    final File parentDir;

    LatexMainDesc(File texFile) {
        this.texFile = texFile;
        this.xxxFile = TexFileUtils.replaceSuffix(texFile, "");
        this.pdfFile = this.withSuffix(".pdf");
        this.dviFile = this.withSuffix(".dvi");
        this.xdvFile = this.withSuffix(".xdv");
        this.logFile = this.withSuffix(".log");
        this.idxFile = this.withSuffix(".idx");
        this.indFile = this.withSuffix(".ind");
        this.ilgFile = this.withSuffix(".ilg");
        this.glsFile = this.withSuffix(".gls");
        this.gloFile = this.withSuffix(".glo");
        this.glgFile = this.withSuffix(".glg");
        this.parentDir = this.texFile.getParentFile();
    }

    File withSuffix(String suffix) {
        return TexFileUtils.appendSuffix(this.xxxFile, suffix);
    }

    @Override
    public int compareTo(LatexMainDesc other) {
        return this.texFile.compareTo(other.texFile);
    }
}

