/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.Settings;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Target {
    chk{

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return Target.NO_OUTPUT_FILES;
        }
    }
    ,
    dvi{

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^(T$T\\.(dvi|xdv)|.+(\\.(ptx|eps|jpg|png)|\\d+\\.mps))$";
        }
    }
    ,
    pdf{

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.pdf$";
        }

        @Override
        public boolean hasDiffTool() {
            return true;
        }
    }
    ,
    html{

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return settings.getPatternT4htOutputFiles();
        }
    }
    ,
    odt{

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.(odt|fodt|uot|uot)$";
        }
    }
    ,
    docx{

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.(doc(|6|.95|.x|.x7)|rtf)$";
        }
    }
    ,
    rtf{

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.rtf$";
        }
    }
    ,
    txt{

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.txt$";
        }
    };

    private static final String NO_OUTPUT_FILES = ".^";

    public abstract String getPatternOutputFiles(Settings var1);

    public boolean hasDiffTool() {
        return false;
    }
}

