/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.LatexMainDesc;
import eu.simuline.m2latex.core.LatexProcessor;
import eu.simuline.m2latex.core.Settings;

public enum Target {
    rtf{
        private final String RTF_OUTPUT_FILES = "^T$T\\.rtf$";

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc) throws BuildFailureException {
            latexProcessor.processLatex2rtf(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.rtf$";
        }
    }
    ,
    dvi{
        private final String LATEX_OUTPUT_FILES = "^(T$T\\.(dvi|xdv)|.+(\\.(ptx|eps|jpg|png)|\\d+\\.mps))$";

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc) throws BuildFailureException {
            latexProcessor.processLatex2dvi(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^(T$T\\.(dvi|xdv)|.+(\\.(ptx|eps|jpg|png)|\\d+\\.mps))$";
        }
    }
    ,
    pdf{
        private final String LATEX_OUTPUT_FILES = "^T$T\\.pdf$";

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc) throws BuildFailureException {
            latexProcessor.processLatex2pdf(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.pdf$";
        }

        @Override
        public boolean hasDiffTool() {
            return true;
        }
    }
    ,
    html{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc) throws BuildFailureException {
            latexProcessor.processLatex2html(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return settings.getPatternT4htOutputFiles();
        }
    }
    ,
    odt{
        private final String OOFFICE_OUTPUT_FILES = "^T$T\\.(odt|fodt|uot|uot)$";

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc) throws BuildFailureException {
            latexProcessor.processLatex2odt(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.(odt|fodt|uot|uot)$";
        }
    }
    ,
    docx{
        private final String MSWORD_OUTPUT_FILES = "^T$T\\.(doc(|6|.95|.x|.x7)|rtf)$";

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc) throws BuildFailureException {
            latexProcessor.processLatex2docx(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.(doc(|6|.95|.x|.x7)|rtf)$";
        }
    }
    ,
    txt{
        private final String TXT_OUTPUT_FILES = "^T$T\\.txt$";

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc) throws BuildFailureException {
            latexProcessor.processLatex2txt(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.txt$";
        }
    }
    ,
    chk{

        @Override
        public void processSource(LatexProcessor latexProcessor, LatexMainDesc desc) throws BuildFailureException {
            latexProcessor.processLatex2txt(desc);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return Target.NO_OUTPUT_FILES;
        }
    };

    private static final String NO_OUTPUT_FILES = ".^";

    public abstract void processSource(LatexProcessor var1, LatexMainDesc var2) throws BuildFailureException;

    public abstract String getPatternOutputFiles(Settings var1);

    public boolean hasDiffTool() {
        return false;
    }
}

