/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.LogWrapper;
import java.io.File;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

class CommandExecutor {
    private final LogWrapper log;

    CommandExecutor(LogWrapper log) {
        this.log = log;
    }

    CmdResult execute(File workingDir, File pathToExecutable, String command, String[] args, File ... resFiles) throws BuildFailureException {
        return this.execute(workingDir, pathToExecutable, command, true, args, resFiles);
    }

    CmdResult execute(File workingDir, File pathToExecutable, String command, boolean checkReturnCode, String[] args, File ... resFiles) throws BuildFailureException {
        boolean[] existsTarget = new boolean[resFiles.length];
        long[] lastModifiedTarget = new long[resFiles.length];
        long currentTime = System.currentTimeMillis();
        long minTimePast = Long.MAX_VALUE;
        for (int idx = 0; idx < resFiles.length; ++idx) {
            existsTarget[idx] = resFiles[idx].exists();
            lastModifiedTarget[idx] = resFiles[idx].lastModified();
            assert (lastModifiedTarget[idx] <= currentTime);
            minTimePast = Math.min(minTimePast, currentTime - lastModifiedTarget[idx]);
        }
        if (minTimePast < 1001L) {
            try {
                Thread.sleep(1001L - minTimePast);
            }
            catch (InterruptedException ie) {
                this.log.warn("WEX05: Update control may emit false warnings. ");
            }
        }
        if (workingDir == null && resFiles.length != 0) {
            throw new IllegalStateException("Working directory shall be determined but was null. ");
        }
        CmdResult res = this.execute(workingDir, pathToExecutable, command, checkReturnCode, args);
        for (int idx = 0; idx < resFiles.length; ++idx) {
            this.isUpdatedOrWarn(command, resFiles[idx], existsTarget[idx], lastModifiedTarget[idx]);
        }
        return res;
    }

    private boolean isUpdatedOrWarn(String command, File target, boolean existedBefore, long lastModifiedBefore) {
        if (!target.exists()) {
            this.log.error("EEX02: Running " + command + " failed: No target file '" + target.getName() + "' written. ");
            return false;
        }
        assert (target.exists());
        if (!existedBefore) {
            return true;
        }
        assert (existedBefore && target.exists());
        long lastModifiedAfter = target.lastModified();
        if (lastModifiedBefore == 0L || lastModifiedAfter == 0L) {
            this.log.warn("WEX04: Cannot read target file '" + target.getName() + "'; may be outdated. ");
            return false;
        }
        assert (lastModifiedBefore > 0L && lastModifiedAfter > 0L);
        if (lastModifiedAfter <= lastModifiedBefore) {
            assert (lastModifiedAfter == lastModifiedBefore);
            this.log.error("EEX03: Running " + command + " failed: Target file '" + target.getName() + "' is not updated. ");
            return false;
        }
        return true;
    }

    private CmdResult execute(File workingDir, File pathToExecutable, String command, boolean checkReturnCode, String[] args) throws BuildFailureException {
        String executable = new File(pathToExecutable, command).getPath();
        Commandline cl = new Commandline(executable);
        cl.getShell().setQuotedArgumentsEnabled(true);
        cl.addArguments(args);
        if (workingDir != null) {
            cl.setWorkingDirectory(workingDir.getPath());
        }
        CommandLineUtils.StringStreamConsumer output = new CommandLineUtils.StringStreamConsumer();
        this.log.debug("Executing: " + cl + " in: " + workingDir + ". ");
        int returnCode = -1;
        try {
            ReturnCodeChecker checker;
            returnCode = CommandLineUtils.executeCommandLine(cl, output, output);
            ReturnCodeChecker returnCodeChecker = checker = checkReturnCode ? ReturnCodeChecker.IsNonZero : ReturnCodeChecker.Never;
            if (checker.hasFailed(returnCode)) {
                this.log.error("EEX01: Running " + command + " failed with return code " + returnCode + ". ");
            }
        }
        catch (CommandLineException e) {
            throw new BuildFailureException("TEX01: Error running " + command + ". ", e);
        }
        this.log.debug("Output:\n" + output.getOutput() + "\n");
        return new CmdResult(output.getOutput(), returnCode == 0);
    }

    static class CmdResult {
        final String output;
        final boolean success;

        CmdResult(String output, boolean success) {
            this.output = output;
            this.success = success;
        }
    }

    static enum ReturnCodeChecker {
        Never{

            @Override
            boolean hasFailed(int returnCode) {
                return false;
            }
        }
        ,
        IsNonZero{

            @Override
            boolean hasFailed(int returnCode) {
                return returnCode != 0;
            }
        }
        ,
        IsOne{

            @Override
            boolean hasFailed(int returnCode) {
                return returnCode == 1;
            }
        };


        abstract boolean hasFailed(int var1);
    }
}

