/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.Converter;
import eu.simuline.m2latex.core.ConverterCategory;
import eu.simuline.m2latex.core.LatexDev;
import eu.simuline.m2latex.core.Target;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.plugins.annotations.Parameter;

public class Settings {
    static final String SST;
    private File baseDirectory;
    private File targetDirectory;
    private File targetSiteDirectory;
    @Parameter(name="texSrcDirectory", defaultValue="src${file.separator}site${file.separator}tex")
    private String texSrcDirectory = SST;
    private File texSrcDirectoryFile = new File(this.baseDirectory, this.texSrcDirectory);
    @Parameter(name="texSrcProcDirectory", defaultValue=".")
    private String texSrcProcDirectory = ".";
    private File texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
    @Parameter(name="readTexSrcProcDirRec", defaultValue="true")
    private boolean readTexSrcProcDirRec = true;
    @Parameter(name="outputDirectory", defaultValue=".")
    private String outputDirectory = ".";
    private File outputDirectoryFile = new File(this.targetSiteDirectory, this.outputDirectory);
    @Parameter(name="diffDirectory", defaultValue=".")
    private String diffDirectory = ".";
    private File diffDirectoryFile = new File(this.baseDirectory, this.diffDirectory);
    @Parameter(name="targets", defaultValue="pdf, html")
    private String targets = "pdf, html";
    @Parameter(name="convertersExcluded", defaultValue="")
    private String convertersExcluded = "";
    @Parameter(name="patternLatexMainFile")
    private String patternLatexMainFile = "\\A(\\\\RequirePackage\\s*(\\[(\\s|\\w|,)*\\])?\\s*\\{(\\w|-)+\\}\\s*(\\[(\\d|\\.)+\\])?|%.*$|\\\\PassOptionsToPackage\\s*\\{\\w+\\}\\s*\\{(\\w|-)\\}|%.*$|\\\\input\\{[^{}]*\\}|\\s)*\\\\(documentstyle|documentclass)";
    @Parameter(name="mainFilesIncluded", defaultValue="")
    private String mainFilesIncluded = "";
    private Set<String> mainFilesIncludedSet = new HashSet<String>(Arrays.asList(this.mainFilesIncluded.split(" ")));
    @Parameter(name="mainFilesExcluded", defaultValue="")
    private String mainFilesExcluded = "";
    private Set<String> mainFilesExcludedSet = new HashSet<String>(Arrays.asList(this.mainFilesExcluded.split(" ")));
    @Parameter(name="texPath", defaultValue="null")
    private File texPath = null;
    @Parameter(name="chkDiff", defaultValue="false")
    private boolean chkDiff = false;
    @Parameter(name="cleanUp", defaultValue="true")
    private boolean cleanUp = true;
    @Parameter(name="patternCreatedFromLatexMain")
    private String patternCreatedFromLatexMain = "^(T$T(\\.([^.]*|synctex\\.gz(\\(busy\\))?|out\\.ps)|(-|ch|se|su|ap|li)?\\d+\\.x?html?|\\d+x\\.x?bb|\\d+x?\\.png|-\\d+\\.svg|-.+\\.(idx|ind|ilg)|\\.(pytxcode|plg|dplg|depytx(\\.tex)?))|pythontex-files-T$T|zzT$T\\.e?ps|(cmsy)\\d+(-c)?-\\d+c?\\.png|(pdf)?latex\\d+\\.fls)$";
    @Parameter(name="fig2devCommand", defaultValue="fig2dev")
    private String fig2devCommand = "fig2dev";
    @Parameter(name="fig2devGenOptions", defaultValue="")
    private String fig2devGenOptions = "";
    @Parameter(name="fig2devPtxOptions", defaultValue="")
    private String fig2devPtxOptions = "";
    @Parameter(name="fig2devPdfEpsOptions", defaultValue="")
    private String fig2devPdfEpsOptions = "";
    @Parameter(name="gnuplotCommand", defaultValue="gnuplot")
    private String gnuplotCommand = "gnuplot";
    @Parameter(name="gnuplotOptions", defaultValue="")
    private String gnuplotOptions = "";
    @Parameter(name="metapostCommand", defaultValue="mpost")
    private String metapostCommand = "mpost";
    @Parameter(name="metapostOptions", defaultValue="-interaction=nonstopmode -recorder -s prologues=2")
    private String metapostOptions = "-interaction=nonstopmode -recorder -s prologues=2";
    @Parameter(name="svg2devCommand", defaultValue="inkscape")
    private String svg2devCommand = "inkscape";
    @Parameter(name="svg2devOptions", defaultValue="-D --export-latex")
    private String svg2devOptions = "-D --export-latex";
    @Parameter(name="ebbCommand", defaultValue="ebb")
    private String ebbCommand = "ebb";
    @Parameter(name="ebbOptions", defaultValue="-v")
    private String ebbOptions = "-v";
    @Parameter(name="latex2pdfCommand", defaultValue="lualatex")
    private String latex2pdfCommand = "lualatex";
    @Parameter(name="latex2pdfOptions", defaultValue="-interaction=nonstopmode -synctex=1 -src-specials -recorder -shell-escape")
    private String latex2pdfOptions = "-interaction=nonstopmode -synctex=1 -src-specials -recorder -shell-escape";
    @Parameter(name="patternErrLatex", defaultValue="(^! )")
    private String patternErrLatex = "(^! )";
    @Parameter(name="patternWarnLatex", defaultValue="^(LaTeX Warning: |LaTeX Font Warning: |(Package|Class) .+ Warning: |pdfTeX warning( \\((\\d|\\w)+\\))?: |\\* fontspec warning: |Missing character: There is no .* in font .*!$|A space is missing\\. (No warning)\\.)")
    private String patternWarnLatex = "^(LaTeX Warning: |LaTeX Font Warning: |(Package|Class) .+ Warning: |pdfTeX warning( \\((\\d|\\w)+\\))?: |\\* fontspec warning: |Missing character: There is no .* in font .*!$|A space is missing\\. (No warning)\\.)";
    @Parameter(name="debugBadBoxes", defaultValue="true")
    private boolean debugBadBoxes = true;
    @Parameter(name="debugWarnings", defaultValue="true")
    private boolean debugWarnings = true;
    @Parameter(name="pdfViaDvi", defaultValue="false")
    private boolean pdfViaDvi = false;
    @Parameter(name="dvi2pdfCommand", defaultValue="dvipdfmx")
    private String dvi2pdfCommand = "dvipdfmx";
    @Parameter(name="dvi2pdfOptions", defaultValue="")
    private String dvi2pdfOptions = "";
    @Parameter(name="patternReRunLatex", defaultValue="^(LaTeX Warning: Label\\(s\\) may have changed\\. Rerun to get cross-references right\\.$|Package \\w+ Warning: .*Rerun( .*|\\.)$|Package \\w+ Warning: .*$^\\(\\w+\\) .*Rerun .*$|LaTeX Warning: Etaremune labels have changed\\.$|\\(rerunfilecheck\\)                Rerun to get outlines right$)")
    private String patternReRunLatex = "^(LaTeX Warning: Label\\(s\\) may have changed. Rerun to get cross-references right\\.$|Package \\w+ Warning: .*Rerun .*$|Package \\w+ Warning: .*$^\\(\\w+\\) .*Rerun .*$|LaTeX Warning: Etaremune labels have changed\\.$|\\(rerunfilecheck\\)                Rerun to get outlines right$)";
    @Parameter(name="maxNumReRunsLatex", defaultValue="5")
    private int maxNumReRunsLatex = 5;
    @Parameter(name="bibtexCommand", defaultValue="bibtex")
    private String bibtexCommand = "bibtex";
    @Parameter(name="bibtexOptions", defaultValue="")
    private String bibtexOptions = "";
    @Parameter(name="patternErrBibtex", defaultValue="error message")
    private String patternErrBibtex = "error message";
    @Parameter(name="patternWarnBibtex", defaultValue="^Warning--")
    private String patternWarnBibtex = "^Warning--";
    @Parameter(name="makeIndexCommand", defaultValue="makeindex")
    private String makeIndexCommand = "makeindex";
    @Parameter(name="makeIndexOptions", defaultValue="")
    private String makeIndexOptions = "";
    @Parameter(name="patternErrMakeIndex", defaultValue="(!! Input index error )")
    private String patternErrMakeIndex = "(!! Input index error )";
    @Parameter(name="patternWarnMakeIndex", defaultValue="(## Warning )")
    private String patternWarnMakeIndex = "(## Warning )";
    @Parameter(name="patternReRunMakeIndex", defaultValue="^\\(rerunfilecheck\\) +Rerun LaTeX/makeindex to get index right\\.$")
    private String patternReRunMakeIndex = "^\\(rerunfilecheck\\) +Rerun LaTeX/makeindex to get index right\\.$";
    @Parameter(name="splitIndexCommand", defaultValue="splitindex")
    private String splitIndexCommand = "splitindex";
    @Parameter(name="splitIndexOptions", defaultValue="-V")
    private String splitIndexOptions = "splitindexOptions";
    @Parameter(name="makeGlossariesCommand", defaultValue="makeglossaries")
    private String makeGlossariesCommand = "makeglossaries";
    @Parameter(name="makeGlossariesOptions", defaultValue="")
    private String makeGlossariesOptions = "";
    @Parameter(name="patternErrMakeGlossaries", defaultValue="^\\*\\*\\* unable to execute: ")
    private String patternErrMakeGlossaries = "^\\*\\*\\* unable to execute: ";
    @Parameter(name="patternErrXindy", defaultValue="(^ERROR: )")
    private String patternErrXindy = "(^ERROR: )";
    @Parameter(name="patternWarnXindy", defaultValue="(^WARNING: )")
    private String patternWarnXindy = "(^WARNING: )";
    @Parameter(name="patternReRunMakeGlossaries", defaultValue="^\\(rerunfilecheck\\) +Rerun LaTeX/makeindex to get glossary right\\.$")
    private String patternReRunMakeGlossaries = "^\\(rerunfilecheck\\) +Rerun LaTeX/makeindex to get glossary right\\.$";
    @Parameter(name="pythontexCommand", defaultValue="pythontex")
    private String pythontexCommand = "pythontex";
    @Parameter(name="pythontexOptions", defaultValue="--rerun=always")
    private String pythontexOptions = "--rerun=always";
    @Parameter(name="patternErrPyTex", defaultValue="\\* PythonTeX error|(PythonTeX:  .+ -|    - Current: ) [1-9][0-9]* error\\(s\\), [0-9]+ warning\\(s\\)")
    private String patternErrPyTex = "\\* PythonTeX error|(PythonTeX:  .+ -|    - Current: ) [1-9][0-9]* error\\(s\\), [0-9]+ warning\\(s\\)";
    @Parameter(name="patternWarnPyTex", defaultValue="(PythonTeX:  .+ -|    - Current: ) [0-9]+ error\\(s\\), [1-9][0-9]* warning\\(s\\)")
    private String patternWarnPyTex = "(PythonTeX:  .+ -|    - Current: ) [0-9]+ error\\(s\\), [1-9][0-9]* warning\\(s\\)";
    @Parameter(name="depythontexCommand", defaultValue="depythontex")
    private String depythontexCommand = "depythontex";
    @Parameter(name="depythontexOptions", defaultValue="")
    private String depythontexOptions = "";
    @Parameter(name="tex4htCommand", defaultValue="htlatex")
    private String tex4htCommand = "htlatex";
    @Parameter(name="tex4htStyOptions", defaultValue="html,2")
    private String tex4htStyOptions = "html,2";
    @Parameter(name="tex4htOptions", defaultValue="")
    private String tex4htOptions = "";
    @Parameter(name="t4htOptions", defaultValue="")
    private String t4htOptions = "";
    @Parameter(name="patternT4htOutputFiles", defaultValue="")
    private String patternT4htOutputFiles = "^(T$T(((ch|se|su|ap|li)?\\d+)?\\.x?html?|\\.css|\\d+x\\.x?bb|\\d+x\\.png|-\\d+\\.svg)|(cmsy)\\d+(-c)?-\\d+c?\\.png)$";
    @Parameter(name="latex2rtfCommand", defaultValue="latex2rtf")
    private String latex2rtfCommand = "latex2rtf";
    @Parameter(name="latex2rtfOptions", defaultValue="")
    private String latex2rtfOptions = "";
    @Parameter(name="odt2docCommand", defaultValue="odt2doc")
    private String odt2docCommand = "odt2doc";
    @Parameter(name="odt2docOptions", defaultValue="-fdocx")
    private String odt2docOptions = "-fdocx";
    @Parameter(name="pdf2txtCommand", defaultValue="pdftotext")
    private String pdf2txtCommand = "pdftotext";
    @Parameter(name="pdf2txtOptions", defaultValue="-q")
    private String pdf2txtOptions = "-q";
    @Parameter(name="chkTexCommand", defaultValue="chktex")
    private String chkTexCommand = "chktex";
    @Parameter(name="chkTexOptions", defaultValue="")
    private String chkTexOptions = "-q -b0";
    @Parameter(name="diffPdfCommand", defaultValue="diff")
    private String diffPdfCommand = "diff";

    public File getTexSrcDirectoryFile() throws BuildFailureException {
        if (!this.texSrcDirectoryFile.exists() || !this.texSrcDirectoryFile.isDirectory()) {
            throw new BuildFailureException("TSS01: The tex source directory '" + this.texSrcDirectoryFile + "' should be an existing directory, but is not. ");
        }
        return this.texSrcDirectoryFile;
    }

    public File getTexSrcProcDirectoryFile() throws BuildFailureException {
        if (!this.texSrcProcDirectoryFile.exists() || !this.texSrcProcDirectoryFile.isDirectory()) {
            throw new BuildFailureException("TSS02: The tex source processing directory '" + this.texSrcProcDirectoryFile + "' should be an existing directory, but is not. ");
        }
        return this.texSrcProcDirectoryFile;
    }

    public boolean getReadTexSrcProcDirRec() {
        return this.readTexSrcProcDirRec;
    }

    public File getOutputDirectoryFile() throws BuildFailureException {
        if (this.outputDirectoryFile.exists() && !this.outputDirectoryFile.isDirectory()) {
            throw new BuildFailureException("TSS03: The output directory '" + this.outputDirectoryFile + "' should be a directory if it exists, but is not. ");
        }
        return this.outputDirectoryFile;
    }

    public File getDiffDirectoryFile() throws BuildFailureException {
        if (this.diffDirectoryFile.exists() && !this.diffDirectoryFile.isDirectory()) {
            throw new BuildFailureException("TSS09: The diff directory '" + this.diffDirectoryFile + "' should be a directory if it exists, but is not. ");
        }
        return this.diffDirectoryFile;
    }

    public SortedSet<Target> getTargetSet() throws BuildFailureException {
        TreeSet<Target> targetSet = new TreeSet<Target>();
        if (this.targets.isEmpty()) {
            return targetSet;
        }
        String[] targetSeq = this.targets.split(" *, *");
        for (int idx = 0; idx < targetSeq.length; ++idx) {
            Target target;
            try {
                assert (targetSeq[idx] != null);
                target = Target.valueOf(targetSeq[idx]);
            }
            catch (IllegalArgumentException ae) {
                assert (Target.class.isEnum());
                String setOfAllowedTargets = Arrays.asList(Target.values()).toString();
                setOfAllowedTargets = setOfAllowedTargets.substring(1, setOfAllowedTargets.length() - 1);
                throw new BuildFailureException("TSS04: The target set '" + this.targets + "' should be a subset of the registered targets '" + setOfAllowedTargets + "', but is not. ");
            }
            targetSet.add(target);
        }
        return targetSet;
    }

    public SortedSet<Converter> getConvertersExcluded() throws BuildFailureException {
        TreeSet<Converter> convSet = new TreeSet<Converter>();
        if (this.convertersExcluded.isEmpty()) {
            return convSet;
        }
        String[] convSeq = this.convertersExcluded.split(" *, *");
        for (int idx = 0; idx < convSeq.length; ++idx) {
            Converter conv = Converter.cmd2Conv(convSeq[idx]);
            if (conv == null) {
                throw new BuildFailureException("TSS05: The excluded converters '" + this.convertersExcluded + "' should form a subset of the registered converters '" + Converter.toCommandsString() + "'. ");
            }
            convSet.add(conv);
        }
        return convSet;
    }

    private String checkConverterName(String convStr, ConverterCategory cat) throws BuildFailureException {
        int idxLastCol = convStr.lastIndexOf(58);
        if (idxLastCol != -1) {
            String catStr = convStr.substring(idxLastCol + 1);
            String convStrProper = convStr.substring(0, idxLastCol);
            if (!cat.getExtName().equals(catStr)) {
                throw new BuildFailureException("TSS10: Specified unregistered converter '" + convStrProper + "' with invalid category '" + catStr + "'; should be '" + cat.getExtName() + "''. ");
            }
            return convStrProper;
        }
        Converter conv = Converter.cmd2Conv(convStr);
        if (conv == null) {
            throw new BuildFailureException("TSS06: Tried to use converter '" + convStr + "' although not among the registered converters '" + Converter.toCommandsString() + "' as expected. ");
        }
        SortedSet<Converter> convertersExcluded = this.getConvertersExcluded();
        if (convertersExcluded.contains((Object)conv)) {
            throw new BuildFailureException("TSS07: Tried to use converter '" + convStr + "' although among the excluded converters '" + Converter.toCommandsString(convertersExcluded) + "'. ");
        }
        if (conv.getCategory() != cat) {
            throw new BuildFailureException("TSS08: Tried to use converter '" + convStr + "' in configuration '" + cat.getFieldname() + "' instead of configuration '" + conv.getCategory().getFieldname() + "'. ");
        }
        return convStr;
    }

    public String getPatternLatexMainFile() {
        return this.patternLatexMainFile;
    }

    public Set<String> getMainFilesIncluded() {
        return this.mainFilesIncludedSet;
    }

    public Set<String> getMainFilesExcluded() {
        return this.mainFilesExcludedSet;
    }

    public File getTexPath() {
        return this.texPath;
    }

    public boolean isCleanUp() {
        return this.cleanUp;
    }

    public boolean isChkDiff() {
        return this.chkDiff;
    }

    public String getPatternCreatedFromLatexMain() {
        return this.patternCreatedFromLatexMain;
    }

    public String getFig2devCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Fig2Dev);
    }

    public String getFig2devGenOptions() {
        return this.fig2devGenOptions;
    }

    public String getFig2devPtxOptions() {
        return this.fig2devPtxOptions;
    }

    public String getFig2devPdfEpsOptions() {
        return this.fig2devPdfEpsOptions;
    }

    public String getGnuplotCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Gnuplot2Dev);
    }

    public String getGnuplotOptions() {
        return this.gnuplotOptions;
    }

    public String getMetapostCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.MetaPost);
    }

    public String getMetapostOptions() {
        return this.metapostOptions;
    }

    public String getSvg2devCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Svg2Dev);
    }

    public String getSvg2devOptions() {
        return this.svg2devOptions;
    }

    public String getEbbCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.EbbCmd);
    }

    public String getEbbOptions() {
        return this.ebbOptions;
    }

    public String getLatex2pdfCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.LaTeX);
    }

    public String getLatex2pdfOptions() {
        return this.latex2pdfOptions;
    }

    public String getPatternErrLatex() {
        return this.patternErrLatex;
    }

    public String getPatternErrMPost() {
        return this.patternErrLatex;
    }

    public String getPatternWarnLatex() {
        return this.patternWarnLatex;
    }

    public boolean getDebugBadBoxes() {
        return this.debugBadBoxes;
    }

    public boolean getDebugWarnings() {
        return this.debugWarnings;
    }

    public LatexDev getPdfViaDvi() {
        return LatexDev.devViaDvi(this.pdfViaDvi);
    }

    public String getDvi2pdfCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Dvi2Pdf);
    }

    public String getDvi2pdfOptions() {
        return this.dvi2pdfOptions;
    }

    public String getPatternReRunLatex() {
        return this.patternReRunLatex;
    }

    public int getMaxNumReRunsLatex() {
        return this.maxNumReRunsLatex;
    }

    public String getCommand(ConverterCategory cat) throws BuildFailureException {
        String cmdName;
        try {
            cmdName = (String)this.getClass().getDeclaredField(cat.getFieldname()).get(this);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalStateException("Could not find field '" + cat.getFieldname() + "' in Settings. ");
        }
        catch (IllegalAccessException iace) {
            throw new IllegalStateException("Parameter '" + cat.getFieldname() + "' not readable. ");
        }
        catch (IllegalArgumentException iage) {
            throw new IllegalStateException("Settings class mismatch. ");
        }
        cmdName = this.checkConverterName(cmdName, cat);
        return cmdName;
    }

    public String getBibtexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.BibTeX);
    }

    public String getBibtexOptions() {
        return this.bibtexOptions;
    }

    public String getPatternErrBibtex() {
        return this.patternErrBibtex;
    }

    public String getPatternWarnBibtex() {
        return this.patternWarnBibtex;
    }

    public String getMakeIndexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.MakeIndex);
    }

    public String getMakeIndexOptions() {
        return this.makeIndexOptions;
    }

    public String getPatternErrMakeIndex() {
        return this.patternErrMakeIndex;
    }

    public String getPatternWarnMakeIndex() {
        return this.patternWarnMakeIndex;
    }

    public String getPatternReRunMakeIndex() {
        return this.patternReRunMakeIndex;
    }

    public String getSplitIndexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.SplitIndex);
    }

    public String getSplitIndexOptions() {
        return this.splitIndexOptions;
    }

    public String getMakeGlossariesCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.MakeGlossaries);
    }

    public String getMakeGlossariesOptions() {
        return this.makeGlossariesOptions;
    }

    public String getPatternErrMakeGlossaries() {
        return this.patternErrMakeGlossaries;
    }

    public String getPatternWarnXindy() {
        return this.patternWarnXindy;
    }

    public String getPatternReRunMakeGlossaries() {
        return this.patternReRunMakeGlossaries;
    }

    public String getPythontexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Pythontex);
    }

    public String getPythontexOptions() {
        return this.pythontexOptions;
    }

    public String getPatternErrPyTex() {
        return this.patternErrPyTex;
    }

    public String getPatternWarnPyTex() {
        return this.patternWarnPyTex;
    }

    public String getTex4htCommand() {
        return this.tex4htCommand;
    }

    public String getTex4htStyOptions() {
        return this.tex4htStyOptions;
    }

    public String getTex4htOptions() {
        return this.tex4htOptions;
    }

    public String getT4htOptions() {
        return this.t4htOptions;
    }

    public String getPatternT4htOutputFiles() {
        return this.patternT4htOutputFiles;
    }

    public String getLatex2rtfCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.LaTeX2Rtf);
    }

    public String getLatex2rtfOptions() {
        return this.latex2rtfOptions;
    }

    public String getOdt2docCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Odt2Doc);
    }

    public String getOdt2docOptions() {
        return this.odt2docOptions;
    }

    public String getPdf2txtCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.Pdf2Txt);
    }

    public String getPdf2txtOptions() {
        return this.pdf2txtOptions;
    }

    public String getChkTexCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.LatexChk);
    }

    public String getChkTexOptions() {
        return this.chkTexOptions;
    }

    public String getDiffPdfCommand() throws BuildFailureException {
        return this.getCommand(ConverterCategory.DiffPdf);
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.texSrcDirectoryFile = new File(this.baseDirectory, this.texSrcDirectory);
        this.texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
        this.texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
        this.diffDirectoryFile = new File(this.baseDirectory, this.diffDirectory);
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTargetSiteDirectory(File targetSiteDirectory) {
        this.targetSiteDirectory = targetSiteDirectory;
        this.outputDirectoryFile = new File(this.targetSiteDirectory, this.outputDirectory);
    }

    public void setTexSrcDirectory(String texSrcDirectory) {
        this.texSrcDirectory = texSrcDirectory;
        this.texSrcDirectoryFile = new File(this.baseDirectory, this.texSrcDirectory);
        this.texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
    }

    public void setTexSrcProcDirectory(String texSrcProcDirectory) {
        this.texSrcProcDirectory = texSrcProcDirectory;
        this.texSrcProcDirectoryFile = new File(this.texSrcDirectoryFile, this.texSrcProcDirectory);
    }

    public void setReadTexSrcProcDirRec(boolean readTexSrcProcDirRec) {
        this.readTexSrcProcDirRec = readTexSrcProcDirRec;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.outputDirectoryFile = new File(this.targetSiteDirectory, this.outputDirectory);
    }

    public void setDiffDirectory(String diffDirectory) {
        this.diffDirectory = diffDirectory;
        this.diffDirectoryFile = new File(this.baseDirectory, this.diffDirectory);
    }

    public void setTargets(String targets) {
        this.targets = targets.trim();
    }

    public void setConvertersExcluded(String convertersExcluded) {
        this.convertersExcluded = convertersExcluded;
    }

    public void setPatternLatexMainFile(String patternLatexMainFile) {
        this.patternLatexMainFile = patternLatexMainFile.replaceAll("(\t|\n)+", "").trim();
    }

    public PatternLatexMainFile createPatternLatexMainFile() {
        return new PatternLatexMainFile();
    }

    public void setMainFilesIncluded(String setMainFilesIncluded) {
        System.out.println("setMainFilesIncluded: '" + setMainFilesIncluded + "'");
        this.mainFilesIncluded = this.mainFilesIncluded.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setMainFilesExcluded(String mainFilesExcluded) {
        System.out.println("setMainFilesExcluded: '" + mainFilesExcluded + "'");
        this.mainFilesExcluded = mainFilesExcluded.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setTexPath(File texPath) {
        this.texPath = texPath;
    }

    public void setCleanUp(boolean cleanUp) {
        this.cleanUp = cleanUp;
    }

    public void setChkDiff(boolean chkDiff) {
        this.chkDiff = chkDiff;
    }

    public void setPatternCreatedFromLatexMain(String pattern) {
        this.patternCreatedFromLatexMain = pattern.replaceAll("(\t|\n| )+", "").trim();
    }

    public PatternCreatedFromLatexMain createPatternCreatedFromLatexMain() {
        return new PatternCreatedFromLatexMain();
    }

    public void setFig2devCommand(String fig2devCommand) {
        this.fig2devCommand = fig2devCommand;
    }

    public void setFig2devGenOptions(String fig2devGenOptions) {
        this.fig2devGenOptions = fig2devGenOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setFig2devPtxOptions(String fig2devPtxOptions) {
        this.fig2devPtxOptions = fig2devPtxOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setFig2devPdfEpsOptions(String fig2devPdfEpsOptions) {
        this.fig2devPdfEpsOptions = fig2devPdfEpsOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setGnuplotCommand(String gnuplotCommand) {
        this.gnuplotCommand = gnuplotCommand;
    }

    public void setGnuplotOptions(String gnuplotOptions) {
        this.gnuplotOptions = gnuplotOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setMetapostCommand(String metapostCommand) {
        this.metapostCommand = metapostCommand;
    }

    public void setMetapostOptions(String metapostOptions) {
        this.metapostOptions = metapostOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public MetapostOptions createMetapostOptions() {
        return new MetapostOptions();
    }

    public void setSvg2devCommand(String svg2devCommand) {
        this.svg2devCommand = svg2devCommand;
    }

    public void setSvg2devOptions(String svg2dev) {
        this.svg2devOptions = this.svg2devOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setEbbCommand(String ebbCommand) {
        this.ebbCommand = ebbCommand;
    }

    public void setEbbOptions(String ebbOptions) {
        this.ebbOptions = ebbOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setLatex2pdfCommand(String latex2pdfCommand) {
        this.latex2pdfCommand = latex2pdfCommand;
    }

    public void setLatex2pdfOptions(String args) {
        this.latex2pdfOptions = args.replaceAll("(\t|\n| )+", " ").trim();
    }

    public Latex2pdfOptions createLatex2pdfOptions() {
        return new Latex2pdfOptions();
    }

    public void setPatternErrLatex(String patternErrLatex) {
        this.patternErrLatex = patternErrLatex;
    }

    public PatternErrLatex createPatternErrLatex() {
        return new PatternErrLatex();
    }

    public void setPatternWarnLatex(String patternWarnLatex) {
        this.patternWarnLatex = patternWarnLatex.replaceAll("(\t|\n)+", "").trim();
    }

    public PatternWarnLatex createPatternWarnLatex() {
        return new PatternWarnLatex();
    }

    public void setDebugBadBoxes(boolean debugBadBoxes) {
        this.debugBadBoxes = debugBadBoxes;
    }

    public void setDebugWarnings(boolean debugWarnings) {
        this.debugWarnings = debugWarnings;
    }

    public void setPdfViaDvi(boolean pdfViaDvi) {
        this.pdfViaDvi = pdfViaDvi;
    }

    public void setDvi2pdfCommand(String dvi2pdfCommand) {
        this.dvi2pdfCommand = dvi2pdfCommand;
    }

    public void setDvi2pdfOptions(String dvi2pdfOptions) {
        this.dvi2pdfOptions = dvi2pdfOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPatternReRunLatex(String pattern) {
        this.patternReRunLatex = pattern.replaceAll("(\t|\n)+", "").trim();
    }

    public PatternReRunLatex createPatternReRunLatex() {
        return new PatternReRunLatex();
    }

    public void setMaxNumReRunsLatex(int maxNumReRunsLatex) {
        assert (maxNumReRunsLatex >= 1 || maxNumReRunsLatex == -1) : "Found illegal max number of reruns " + maxNumReRunsLatex + ". ";
        this.maxNumReRunsLatex = maxNumReRunsLatex;
    }

    public void setBibtexCommand(String bibtexCommand) {
        this.bibtexCommand = bibtexCommand;
    }

    public void setBibtexOptions(String bibtexOptions) {
        this.bibtexOptions = bibtexOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPatternErrBibtex(String patternErrBibtex) {
        this.patternErrBibtex = patternErrBibtex;
    }

    public PatternErrBibtex createPatternErrBibtex() {
        return new PatternErrBibtex();
    }

    public void setPatternWarnBibtex(String patternWarnBibtex) {
        this.patternWarnBibtex = patternWarnBibtex;
    }

    public PatternWarnBibtex createPatternWarnBibtex() {
        return new PatternWarnBibtex();
    }

    public void setMakeIndexCommand(String makeIndexCommand) {
        this.makeIndexCommand = makeIndexCommand;
    }

    public void setMakeIndexOptions(String makeIndexOptions) {
        this.makeIndexOptions = makeIndexOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPatternErrMakeIndex(String patternErrMakeIndex) {
        this.patternErrMakeIndex = patternErrMakeIndex.replaceAll("\n+", "").trim();
    }

    public PatternErrMakeIndex createPatternErrMakeIndex() {
        return new PatternErrMakeIndex();
    }

    public void setPatternWarnMakeIndex(String patternWarnMakeIndex) {
        this.patternWarnMakeIndex = patternWarnMakeIndex.replaceAll("\n+", "").trim();
    }

    public PatternWarnMakeIndex createPatternWarnMakeIndex() {
        return new PatternWarnMakeIndex();
    }

    public void setPatternReRunMakeIndex(String pattern) {
        this.patternReRunMakeIndex = pattern.replaceAll("\n+", "").trim();
    }

    public PatternReRunMakeIndex createPatternReRunMakeIndex() {
        return new PatternReRunMakeIndex();
    }

    public void setSplitIndexCommand(String splitIndexCommand) {
        this.splitIndexCommand = splitIndexCommand;
    }

    public void setSplitIndexOptions(String splitIndexOptions) {
        this.splitIndexOptions = splitIndexOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setMakeGlossariesCommand(String makeGlossariesCommand) {
        this.makeGlossariesCommand = makeGlossariesCommand;
    }

    public void setMakeGlossariesOptions(String makeGlossariesOptions) {
        this.makeGlossariesOptions = makeGlossariesOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPatternErrMakeGlossaries(String patternErrMakeGlossaries) {
        this.patternErrMakeGlossaries = patternErrMakeGlossaries.replaceAll("\n+", "").trim();
    }

    public void setPatternWarnXindy(String patternWarnXindy) {
        this.patternWarnXindy = patternWarnXindy.replaceAll("\n+", "").trim();
    }

    public void setPatternReRunMakeGlossaries(String pattern) {
        this.patternReRunMakeGlossaries = pattern.replaceAll("\n+", "").trim();
    }

    public PatternReRunMakeGlossaries createPatternReRunMakeGlossaries() {
        return new PatternReRunMakeGlossaries();
    }

    public void setPythontexCommand(String pythontexCommand) {
        this.pythontexCommand = pythontexCommand;
    }

    public void setPythontexOptions(String pythontexOptions) {
        this.pythontexOptions = pythontexOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPatternErrPyTex(String patternErrPyTex) {
        this.patternErrPyTex = patternErrPyTex.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPatternWarnPyTex(String patternWarnPyTex) {
        this.patternWarnPyTex = patternWarnPyTex.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setTex4htCommand(String tex4htCommand) {
        this.tex4htCommand = tex4htCommand;
    }

    public void setTex4htStyOptions(String tex4htStyOptions) {
        this.tex4htStyOptions = tex4htStyOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setTex4htOptions(String tex4htOptions) {
        this.tex4htOptions = tex4htOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setT4htOptions(String t4htOptions) {
        this.t4htOptions = t4htOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPatternT4htOutputFiles(String patternT4htOutputFiles) {
        this.patternT4htOutputFiles = patternT4htOutputFiles.replaceAll("(\t|\n| )+", "").trim();
    }

    public PatternT4htOutputFiles createPatternT4htOutputFiles() {
        return new PatternT4htOutputFiles();
    }

    public void setLatex2rtfCommand(String latex2rtfCommand) {
        this.latex2rtfCommand = latex2rtfCommand;
    }

    public void setLatex2rtfOptions(String latex2rtfOptions) {
        this.latex2rtfOptions = latex2rtfOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setOdt2docCommand(String odt2docCommand) {
        this.odt2docCommand = odt2docCommand;
    }

    public void setOdt2docOptions(String odt2docOptions) {
        this.odt2docOptions = odt2docOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setPdf2txtCommand(String pdf2txtCommand) {
        this.pdf2txtCommand = pdf2txtCommand;
    }

    public void setPdf2txtOptions(String pdf2txtOptions) {
        this.pdf2txtOptions = pdf2txtOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setChkTexCommand(String chkTexCommand) {
        this.chkTexCommand = chkTexCommand;
    }

    public void setChkTexOptions(String chkTexOptions) {
        this.chkTexOptions = chkTexOptions.replaceAll("(\t|\n| )+", " ").trim();
    }

    public void setDiffPdfCommand(String diffPdfCommand) {
        this.diffPdfCommand = diffPdfCommand;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ baseDirectory=").append(this.baseDirectory);
        sb.append(", targetDirectory=").append(this.targetDirectory);
        sb.append(", targetSiteDirectory=").append(this.targetSiteDirectory);
        sb.append(", texSrcDirectory=").append(this.texSrcDirectory);
        sb.append(", texSrcProcDirectory=").append(this.texSrcProcDirectory);
        sb.append(", readTexSrcProcDirRec=").append(this.readTexSrcProcDirRec);
        sb.append(", outputDirectory=").append(this.outputDirectory);
        sb.append(", diffDirectory=").append(this.diffDirectory);
        sb.append(", targets=").append(this.targets);
        sb.append(", convertersExcluded=").append(this.convertersExcluded);
        sb.append(", patternLatexMainFile=").append(this.patternLatexMainFile);
        sb.append(", mainFilesIncluded=").append(this.mainFilesIncluded);
        sb.append(", mainFilesExcluded=").append(this.mainFilesExcluded);
        sb.append(", texPath=").append(this.texPath);
        sb.append(", cleanUp=").append(this.cleanUp);
        sb.append(", chkDiff=").append(this.chkDiff);
        sb.append(", patternCreatedFromLatexMain=").append(this.patternCreatedFromLatexMain);
        sb.append(", fig2devCommand=").append(this.fig2devCommand);
        sb.append(", fig2devGenOptions").append(this.fig2devGenOptions);
        sb.append(", fig2devPtxOptions").append(this.fig2devPtxOptions);
        sb.append(", fig2devPdfEpsOptions").append(this.fig2devPdfEpsOptions);
        sb.append(", gnuplotCommand=").append(this.gnuplotCommand);
        sb.append(", gnuplotOptions=").append(this.gnuplotOptions);
        sb.append(", metapostCommand=").append(this.metapostCommand);
        sb.append(", metapostOptions=").append(this.metapostOptions);
        sb.append(", svg2devCommand=").append(this.svg2devCommand);
        sb.append(", svg2devOptions=").append(this.svg2devOptions);
        sb.append(", ebbCommand=").append(this.ebbCommand);
        sb.append(", ebbOptions=").append(this.ebbOptions);
        sb.append(", latex2pdfCommand=").append(this.latex2pdfCommand);
        sb.append(", latex2pdfOptions=").append(this.latex2pdfOptions);
        sb.append(", patternErrLatex=").append(this.patternErrLatex);
        sb.append(", patternWarnLatex=").append(this.patternWarnLatex);
        sb.append(", debugBadBoxes=").append(this.debugBadBoxes);
        sb.append(", debugWarnings=").append(this.debugWarnings);
        sb.append(", pdfViaDvi=").append(this.pdfViaDvi);
        sb.append(", dvi2pdfCommand=").append(this.dvi2pdfCommand);
        sb.append(", dvi2pdfOptions=").append(this.dvi2pdfOptions);
        sb.append(", patternReRunLatex=").append(this.patternReRunLatex);
        sb.append(", maxNumReRunsLatex=").append(this.maxNumReRunsLatex);
        sb.append(", bibtexCommand=").append(this.bibtexCommand);
        sb.append(", bibtexOptions=").append(this.bibtexOptions);
        sb.append(", patternErrBibtex=").append(this.patternErrBibtex);
        sb.append(", patternWarnBibtex=").append(this.patternWarnBibtex);
        sb.append(", makeIndexCommand=").append(this.makeIndexCommand);
        sb.append(", makeIndexOptions=").append(this.makeIndexOptions);
        sb.append(", patternErrMakeIndex=").append(this.patternErrMakeIndex);
        sb.append(", patternWarnMakeIndex=").append(this.patternWarnMakeIndex);
        sb.append(", patternReRunMakeIndex=").append(this.patternReRunMakeIndex);
        sb.append(", splitIndexCommand=").append(this.splitIndexCommand);
        sb.append(", splitIndexOptions=").append(this.splitIndexOptions);
        sb.append(", makeGlossariesCommand=").append(this.makeGlossariesCommand);
        sb.append(", makeGlossariesOptions=").append(this.makeGlossariesOptions);
        sb.append(", patternErrMakeGlossaries=").append(this.patternErrMakeGlossaries);
        sb.append(", patternWarnXindy=").append(this.patternWarnXindy);
        sb.append(", patternReRunMakeGlossaries=").append(this.patternReRunMakeGlossaries);
        sb.append(", pythontexCommand=").append(this.pythontexCommand);
        sb.append(", pythontexOptions=").append(this.pythontexOptions);
        sb.append(", patternErrPyTex=").append(this.patternErrPyTex);
        sb.append(", patternWarnPyTex=").append(this.patternWarnPyTex);
        sb.append(", tex4htCommand=").append(this.tex4htCommand);
        sb.append(", tex4htStyOptions=").append(this.tex4htStyOptions);
        sb.append(", tex4htOptions=").append(this.tex4htOptions);
        sb.append(", t4htOptions=").append(this.t4htOptions);
        sb.append(", patternT4htOutputFiles=").append(this.patternT4htOutputFiles);
        sb.append(", latex2rtfCommand=").append(this.latex2rtfCommand);
        sb.append(", latex2rtfOptions=").append(this.latex2rtfOptions);
        sb.append(", odt2docCommand=").append(this.odt2docCommand);
        sb.append(", odt2docOptions=").append(this.odt2docOptions);
        sb.append(", pdf2txtCommand=").append(this.pdf2txtCommand);
        sb.append(", pdf2txtOptions=").append(this.pdf2txtOptions);
        sb.append(", chkTexCommand=").append(this.chkTexCommand);
        sb.append(", chkTexOptions=").append(this.chkTexOptions);
        sb.append(", diffPdfCommand=").append(this.diffPdfCommand);
        sb.append(']');
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("texpath: " + new Settings().getTexPath());
    }

    static {
        String fs = System.getProperty("file.separator");
        SST = "src" + fs + "site" + fs + "tex";
    }

    public class PatternT4htOutputFiles {
        public void addText(String pattern) {
            Settings.this.setPatternT4htOutputFiles(pattern);
        }
    }

    public class PatternReRunMakeGlossaries {
        public void addText(String pattern) {
            Settings.this.setPatternReRunMakeGlossaries(pattern);
        }
    }

    public class PatternReRunMakeIndex {
        public void addText(String pattern) {
            Settings.this.setPatternReRunMakeIndex(pattern);
        }
    }

    public class PatternWarnMakeIndex {
        public void addText(String pattern) {
            Settings.this.setPatternWarnMakeIndex(pattern);
        }
    }

    public class PatternErrMakeIndex {
        public void addText(String pattern) {
            Settings.this.setPatternErrMakeIndex(pattern);
        }
    }

    public class PatternWarnBibtex {
        public void addText(String pattern) {
            Settings.this.setPatternWarnBibtex(pattern);
        }
    }

    public class PatternErrBibtex {
        public void addText(String pattern) {
            Settings.this.setPatternErrBibtex(pattern);
        }
    }

    public class PatternReRunLatex {
        public void addText(String pattern) {
            Settings.this.setPatternReRunLatex(pattern);
        }
    }

    public class PatternWarnLatex {
        public void addText(String pattern) {
            Settings.this.setPatternWarnLatex(pattern);
        }
    }

    public class PatternErrLatex {
        public void addText(String pattern) {
            Settings.this.setPatternErrLatex(pattern);
        }
    }

    public class Latex2pdfOptions {
        public void addText(String args) {
            Settings.this.setLatex2pdfOptions(args);
        }
    }

    public class MetapostOptions {
        public void addText(String args) {
            Settings.this.setMetapostOptions(args);
        }
    }

    public class PatternCreatedFromLatexMain {
        public void addText(String pattern) {
            Settings.this.setPatternCreatedFromLatexMain(pattern);
        }
    }

    public class PatternLatexMainFile {
        public void addText(String pattern) {
            Settings.this.setPatternLatexMainFile(pattern);
        }
    }
}

