/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.DirNode;
import eu.simuline.m2latex.core.LogWrapper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

class TexFileUtils {
    private static final String PATTERN_INS_LATEX_MAIN = "T\\$T";
    private final LogWrapper log;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String INKSCAPE_PREAMBLE = "%% LatexMavenPlugin (version unknown) modified two of the following lines\n";
    static File EMPTY_IDX;

    TexFileUtils(LogWrapper log) {
        this.log = log;
    }

    File[] listFilesOrWarn(File dir) {
        assert (dir != null && dir.isDirectory()) : "Expected folder found " + dir;
        File[] files = dir.listFiles();
        this.warnIfNull(files, dir);
        return files;
    }

    File[] listFilesOrWarn(File dir, FileFilter filter) {
        assert (dir != null && dir.isDirectory()) : "Expected folder found " + dir;
        File[] files = dir.listFiles(filter);
        this.warnIfNull(files, dir);
        return files;
    }

    private void warnIfNull(File[] files, File dir) {
        if (files == null) {
            this.log.warn("WFU01: Cannot read directory '" + dir + "'; build may be incomplete. ");
        }
    }

    File getTargetDirectory(File srcFile, File srcBaseDir, File targetBaseDir) throws BuildFailureException {
        Path srcParentPath = srcFile.getParentFile().toPath();
        Path srcBasePath = srcBaseDir.toPath();
        assert (srcParentPath.startsWith(srcBasePath));
        srcParentPath = srcBasePath.relativize(srcParentPath);
        File targetDir = new File(targetBaseDir, srcParentPath.toString());
        targetDir.mkdirs();
        if (!targetDir.isDirectory()) {
            throw new BuildFailureException("TFU01: Cannot create destination directory '" + targetDir + "'. ");
        }
        assert (targetDir.isDirectory());
        return targetDir;
    }

    static File getPdfFileDiff(File pdfFileAct, File artifactBaseDir, File diffBaseDir) {
        Path pdfFileActPath = pdfFileAct.toPath();
        Path artifactBasePath = artifactBaseDir.toPath();
        assert (pdfFileActPath.startsWith(artifactBasePath));
        pdfFileActPath = artifactBasePath.relativize(pdfFileActPath);
        return new File(diffBaseDir, pdfFileActPath.toString());
    }

    static FileFilter getFileFilter(final File texFile, String pattern, final boolean allowsDirs) {
        final String patternAccept = pattern.replaceAll(PATTERN_INS_LATEX_MAIN, TexFileUtils.getFileNameWithoutSuffix(texFile));
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory() && !allowsDirs || file.equals(texFile)) {
                    return false;
                }
                return file.getName().matches(patternAccept);
            }
        };
    }

    FileFilter getFileFilterReplace(File idxFile, String pattern) {
        final String patternAccept = TexFileUtils.getFileNameWithoutSuffix(idxFile) + pattern + TexFileUtils.getSuffix(idxFile);
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return file.getName().matches(patternAccept);
            }
        };
    }

    Set<File> copyOutputToTargetFolder(File texFile, FileFilter fileFilter, File targetDir) throws BuildFailureException {
        HashSet<File> targetFiles = new HashSet<File>();
        assert (texFile.exists() && !texFile.isDirectory()) : "Expected existing (regular) tex file " + texFile;
        assert (!targetDir.exists() || targetDir.isDirectory()) : "Expected existing target folder " + targetDir;
        File texFileDir = texFile.getParentFile();
        File[] outputFiles = this.listFilesOrWarn(texFileDir);
        if (outputFiles == null) {
            return targetFiles;
        }
        assert (outputFiles != null);
        for (int idx = 0; idx < outputFiles.length; ++idx) {
            File srcFile = outputFiles[idx];
            assert (srcFile.exists()) : "Missing " + srcFile;
            if (!fileFilter.accept(srcFile)) continue;
            assert (srcFile.exists() && !srcFile.isDirectory()) : "Expected existing (regular) tex file " + texFile;
            assert (!srcFile.equals(targetDir));
            assert (!srcFile.equals(texFile));
            File destFile = new File(targetDir, srcFile.getName());
            if (destFile.isDirectory()) {
                throw new BuildFailureException("TFU04: Cannot overwrite directory '" + destFile + "'. ");
            }
            this.log.debug("Copying '" + srcFile.getName() + "' to '" + targetDir + "'. ");
            try {
                this.doCopyFile(srcFile, destFile);
                targetFiles.add(destFile);
                continue;
            }
            catch (IOException e) {
                throw new BuildFailureException("TFU06: Cannot copy '" + srcFile.getName() + "' to '" + targetDir + "'. ", e);
            }
        }
        return targetFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyFile(File srcFile, File destFile) throws IOException {
        FileInputStream input = new FileInputStream(srcFile);
        try {
            FileOutputStream output = new FileOutputStream(destFile);
            try {
                TexFileUtils.copyStream(input, output);
            }
            finally {
                this.closeQuietly(output);
            }
        }
        finally {
            this.closeQuietly(input);
        }
        assert (!destFile.isDirectory() && destFile.canWrite()) : "Expected existing (regular) writable file " + destFile;
        destFile.setLastModified(srcFile.lastModified());
    }

    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    private void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException ioe) {
            this.log.warn("WFU03: Cannot close '" + closeable + "'. ", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterInkscapeIncludeFile(File srcFile) {
        assert (".eps_tex".equals(TexFileUtils.getSuffix(srcFile))) : "Expected suffix '.eps_tex' found '" + TexFileUtils.getSuffix(srcFile) + "'";
        File destFile = TexFileUtils.replaceSuffix(srcFile, ".ptx");
        File bareFile = TexFileUtils.replaceSuffix(srcFile, "");
        BufferedReader bufferedReader = null;
        FileWriter writer = null;
        try {
            FileReader reader = new FileReader(srcFile);
            bufferedReader = new BufferedReader(reader);
            writer = new FileWriter(destFile);
            writer.write(INKSCAPE_PREAMBLE);
            String line = bufferedReader.readLine();
            writer.write(line + "\n");
            line = bufferedReader.readLine();
            writer.write(line + "\n");
            line = bufferedReader.readLine();
            line = line.replace(bareFile.getName() + ".eps" + "' (pdf, eps, ps)", bareFile.getName() + ".pdf/eps/ps'\n");
            writer.write(line);
            for (int idx = 4; idx < 56; ++idx) {
                line = bufferedReader.readLine();
                writer.write(line + "\n");
            }
            line = bufferedReader.readLine();
            line = line.replace(bareFile.getName() + ".eps" + "}}%", bareFile.getName() + "}}%\n");
            writer.write(line);
            line = bufferedReader.readLine();
            do {
                writer.write(line + "\n");
            } while ((line = bufferedReader.readLine()) != null);
            this.closeQuietly(bufferedReader);
            this.closeQuietly(writer);
        }
        catch (IOException e) {
            block10: {
                block9: {
                    try {
                        if (bufferedReader != null) break block9;
                        this.log.error("EFU07: File '" + srcFile + "' to be filtered cannot be read. ");
                        this.closeQuietly(bufferedReader);
                        this.closeQuietly(writer);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.closeQuietly(bufferedReader);
                        this.closeQuietly(writer);
                        throw throwable;
                    }
                }
                if (writer != null) break block10;
                this.log.error("EFU08: Destination file '" + destFile + "' for filtering cannot be written. ");
                this.closeQuietly(bufferedReader);
                this.closeQuietly(writer);
                return;
            }
            this.log.error("EFU09: Cannot filter file '" + srcFile + "' into '" + destFile + "'. ");
            this.closeQuietly(bufferedReader);
            this.closeQuietly(writer);
        }
    }

    static String getFileNameWithoutSuffix(File file) {
        String nameFile = file.getName();
        int idxDot = nameFile.lastIndexOf(".");
        return idxDot == -1 ? nameFile : nameFile.substring(0, idxDot);
    }

    static String getSuffix(File file) {
        String nameFile = file.getName();
        int idxDot = nameFile.lastIndexOf(".");
        return idxDot == -1 ? "" : nameFile.substring(idxDot, nameFile.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Boolean matchInFile(File file, String regex) {
        Pattern pattern = Pattern.compile(regex, 8);
        boolean fromStart = regex.startsWith("\\A");
        String lines = "";
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                Object line = bufferedReader.readLine();
                while (line != null) {
                    String string = lines = fromStart ? (lines = lines + "\n" + (String)line) : line;
                    if (pattern.matcher(lines).find()) {
                        Boolean bl = true;
                        return bl;
                    }
                    line = bufferedReader.readLine();
                }
                line = false;
                return line;
            }
            catch (IOException ioe) {
                Boolean bl = null;
                return bl;
            }
            finally {
                this.closeQuietly(bufferedReader);
            }
        }
        catch (FileNotFoundException ffe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> collectMatches(File file, String regex, int idxGroup) {
        TreeSet<String> res = new TreeSet<String>();
        Pattern pattern = Pattern.compile(regex);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.find()) {
                    res.add(matcher.group(idxGroup));
                }
                line = bufferedReader.readLine();
            }
            TreeSet<String> treeSet = res;
            this.closeQuietly(bufferedReader);
            return treeSet;
        }
        catch (IOException ioe) {
            try {
                Collection<String> collection = null;
                this.closeQuietly(bufferedReader);
                return collection;
            }
            catch (Throwable throwable) {
                try {
                    this.closeQuietly(bufferedReader);
                    throw throwable;
                }
                catch (FileNotFoundException ffe) {
                    return null;
                }
            }
        }
    }

    static File replaceSuffix(File file, String suffix) {
        return new File(file.getParentFile(), TexFileUtils.getFileNameWithoutSuffix(file) + suffix);
    }

    static File replacePrefix(String prefix, File file) {
        return new File(file.getParentFile(), prefix + file.getName());
    }

    void deleteX(File pFile, FileFilter filter, boolean allowsDirs) {
        assert (pFile.exists() && !pFile.isDirectory()) : "Expected existing (regular) file " + pFile;
        File dir = pFile.getParentFile();
        File[] found = this.listFilesOrWarn(dir);
        if (found == null) {
            return;
        }
        for (File delFile : found) {
            assert (delFile.exists());
            System.out.println("delFile: " + delFile);
            if (!filter.accept(delFile)) continue;
            assert (delFile.exists() && (!delFile.isDirectory() || allowsDirs)) : "Expected existing (regular) file " + delFile;
            this.deleteOrError(delFile, allowsDirs);
        }
    }

    void deleteOrError(File delFile, boolean allowsDirs) {
        assert (delFile.exists() && (!delFile.isDirectory() || allowsDirs)) : "Expected existing (regular) file " + delFile;
        if (!FileUtils.deleteQuietly((File)delFile)) {
            this.log.error("EFU05: Cannot delete file '" + delFile + "'. ");
        }
    }

    void moveOrError(File fromFile, File toFile) {
        assert (fromFile.exists() && !fromFile.isDirectory()) : "Expected existing (regular) source file " + fromFile;
        assert (!toFile.isDirectory()) : "Expected (regular) target file " + toFile;
        boolean success = fromFile.renameTo(toFile);
        if (!success) {
            this.log.error("EFU06: Cannot move file '" + fromFile + "' to '" + toFile + "'. ");
        }
    }

    void cleanUp(DirNode orgNode, File texDir) {
        this.cleanUpRec(texDir, orgNode, new DirNode(texDir, this));
    }

    private void cleanUpRec(File dir, DirNode origNode, DirNode currNode) {
        File file;
        Set<String> origSubdirs = origNode.getSubdirs().keySet();
        TreeSet<String> currSubdirs = new TreeSet<String>(currNode.getSubdirs().keySet());
        boolean containsAll = currSubdirs.containsAll(origSubdirs);
        assert (containsAll);
        currSubdirs.removeAll(origSubdirs);
        TreeSet<String> diffSet = currSubdirs;
        String regex = "pythontex-files-.+";
        for (String string : diffSet) {
            assert (string.matches(regex));
            System.out.println("del: " + new File(dir, string));
            this.deleteOrError(new File(dir, string), true);
        }
        for (String key : origNode.getSubdirs().keySet()) {
            file = new File(dir, key);
            this.cleanUpRec(file, origNode.getSubdirs().get(key), currNode.getSubdirs().get(key));
        }
        Set<String> set = currNode.getRegularFileNames();
        set.removeAll(origNode.getRegularFileNames());
        for (String fileName : set) {
            file = new File(dir, fileName);
            this.deleteOrError(file, false);
        }
    }

    static File getEmptyIdx() {
        if (EMPTY_IDX == null) {
            try {
                EMPTY_IDX = File.createTempFile("forMakeindex", ".idx");
                EMPTY_IDX.deleteOnExit();
                TexFileUtils.replaceSuffix(EMPTY_IDX, ".ind").deleteOnExit();
                TexFileUtils.replaceSuffix(EMPTY_IDX, ".ilg").deleteOnExit();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create temp file.");
            }
        }
        return EMPTY_IDX;
    }

    public static void main(String[] args) {
        String regex = args[0];
        String text = args[1];
        text = "xx\nyzzz";
        System.out.println("regex: " + regex);
        System.out.println("text: " + text);
        System.out.println("len: " + text.length());
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(text);
        matcher.useAnchoringBounds(true);
        System.out.println("find:   " + matcher.find());
        System.out.println("hitEnd: " + matcher.hitEnd());
        System.out.println("hitEnd: " + matcher.end());
    }
}

