/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.LatexProcessor;
import eu.simuline.m2latex.core.Settings;
import java.io.File;

public enum Target {
    rtf{
        private final String RTF_OUTPUT_FILES = "^T$T\\.rtf$";

        @Override
        public void processSource(LatexProcessor latexProcessor, File texFile) throws BuildFailureException {
            latexProcessor.processLatex2rtf(texFile);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.rtf$";
        }
    }
    ,
    dvi{
        private final String LATEX_OUTPUT_FILES = "^(T$T\\.dvi|.+(\\.(ptx|eps|jpg|png)|\\d+\\.mps))$";

        @Override
        public void processSource(LatexProcessor latexProcessor, File texFile) throws BuildFailureException {
            latexProcessor.processLatex2dvi(texFile);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^(T$T\\.dvi|.+(\\.(ptx|eps|jpg|png)|\\d+\\.mps))$";
        }
    }
    ,
    pdf{
        private final String LATEX_OUTPUT_FILES = "^T$T\\.pdf$";

        @Override
        public void processSource(LatexProcessor latexProcessor, File texFile) throws BuildFailureException {
            latexProcessor.processLatex2pdf(texFile);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.pdf$";
        }

        @Override
        public boolean hasDiffTool() {
            return true;
        }
    }
    ,
    html{

        @Override
        public void processSource(LatexProcessor latexProcessor, File texFile) throws BuildFailureException {
            latexProcessor.processLatex2html(texFile);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return settings.getPatternT4htOutputFiles();
        }
    }
    ,
    odt{
        private final String OOFFICE_OUTPUT_FILES = "^T$T\\.(odt|fodt|uot|uot)$";

        @Override
        public void processSource(LatexProcessor latexProcessor, File texFile) throws BuildFailureException {
            latexProcessor.processLatex2odt(texFile);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.(odt|fodt|uot|uot)$";
        }
    }
    ,
    docx{
        private final String MSWORD_OUTPUT_FILES = "^T$T\\.(doc(|6|.95|.x|.x7)|rtf)$";

        @Override
        public void processSource(LatexProcessor latexProcessor, File texFile) throws BuildFailureException {
            latexProcessor.processLatex2docx(texFile);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.(doc(|6|.95|.x|.x7)|rtf)$";
        }
    }
    ,
    txt{
        private final String TXT_OUTPUT_FILES = "^T$T\\.txt$";

        @Override
        public void processSource(LatexProcessor latexProcessor, File texFile) throws BuildFailureException {
            latexProcessor.processLatex2txt(texFile);
        }

        @Override
        public String getPatternOutputFiles(Settings settings) {
            return "^T$T\\.txt$";
        }
    };


    private Target() {
    }

    public abstract void processSource(LatexProcessor var1, File var2) throws BuildFailureException;

    public abstract String getPatternOutputFiles(Settings var1);

    public boolean hasDiffTool() {
        return false;
    }

    /* synthetic */ Target(String string, int n, Target target) {
        this();
    }
}

