/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.AbstractLatexProcessor;
import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.ConverterCategory;
import eu.simuline.m2latex.core.DirNode;
import eu.simuline.m2latex.core.LatexDev;
import eu.simuline.m2latex.core.LatexPreProcessor;
import eu.simuline.m2latex.core.LogWrapper;
import eu.simuline.m2latex.core.MetaInfo;
import eu.simuline.m2latex.core.ParameterAdapter;
import eu.simuline.m2latex.core.Settings;
import eu.simuline.m2latex.core.Target;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class LatexProcessor
extends AbstractLatexProcessor {
    static final String PATTERN_NEED_BIBTEX_RUN = "^\\\\bibdata";
    static final String PATTERN_OUFULL_HVBOX = "^(Ov|Und)erfull \\\\[hv]box \\(";
    static final String SUFFIX_TOC = ".toc";
    static final String SUFFIX_LOF = ".lof";
    static final String SUFFIX_LOT = ".lot";
    static final String SUFFIX_AUX = ".aux";
    static final String SUFFIX_DVI = ".dvi";
    static final String SUFFIX_BLG = ".blg";
    static final String SUFFIX_BBL = ".bbl";
    static final String SUFFIX_IDX = ".idx";
    static final String SUFFIX_IND = ".ind";
    static final String SUFFIX_ILG = ".ilg";
    static final String SUFFIX_GLO = ".glo";
    static final String SUFFIX_GLS = ".gls";
    static final String SUFFIX_GLG = ".glg";
    static final String SUFFIX_PYC = ".pytxcode";
    private static final String SUFFIX_RTF = ".rtf";
    private static final String SUFFIX_ODT = ".odt";
    static final String SUFFIX_HTML = ".html";
    private static final String SUFFIX_TXT = ".txt";
    private static final String SUFFIX_CLG = ".clg";
    private static final String IDX_EXPL = "^(\\\\indexentry)\\[([^]]*)\\](.*)$";
    private static final int GRP_IDENT_IDX = 2;
    private static final String IMPL_IDENT_IDX = "idx";
    private static final String SEP_IDENT_IDX = "-";
    private final ParameterAdapter paramAdapt;
    private final LatexPreProcessor preProc;
    private final MetaInfo metaInfo;

    LatexProcessor(Settings settings, CommandExecutor executor, LogWrapper log, TexFileUtils fileUtils, ParameterAdapter paramAdapt) {
        super(settings, executor, log, fileUtils);
        this.paramAdapt = paramAdapt;
        this.preProc = new LatexPreProcessor(this.settings, this.executor, this.log, this.fileUtils);
        this.metaInfo = new MetaInfo(this.settings, this.executor, this.log);
    }

    public LatexProcessor(Settings settings, LogWrapper log, ParameterAdapter paramAdapt) {
        this(settings, new CommandExecutor(log), log, new TexFileUtils(log), paramAdapt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws BuildFailureException {
        this.paramAdapt.initialize();
        this.log.info("-----------create-------------");
        this.log.debug("Settings: " + this.settings.toString());
        File texDir = this.settings.getTexSrcDirectoryFile();
        assert (texDir.exists() && texDir.isDirectory()) : "Expected existing tex folder " + texDir;
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texDir;
        DirNode node = new DirNode(texProcDir, this.fileUtils);
        try {
            Collection<File> latexMainFiles = this.preProc.processGraphicsSelectMain(texProcDir, node);
            for (File texFile : latexMainFiles) {
                File targetDir = this.fileUtils.getTargetDirectory(texFile, texDir, this.settings.getOutputDirectoryFile());
                assert (!targetDir.exists() || targetDir.isDirectory()) : "Expected target folder " + targetDir + " folder if exists. ";
                for (Target target : this.paramAdapt.getTargetSet()) {
                    target.processSource(this, texFile);
                    FileFilter fileFilter = TexFileUtils.getFileFilter(texFile, target.getPatternOutputFiles(this.settings));
                    Set<File> targetFiles = this.fileUtils.copyOutputToTargetFolder(texFile, fileFilter, targetDir);
                    this.log.debug(String.format("target %s has difftool %s", new Object[]{target, target.hasDiffTool()}));
                    if (!target.hasDiffTool()) {
                        this.log.debug(String.format("target %s has no difftool", new Object[]{target}));
                        continue;
                    }
                    if (!this.settings.isChkDiff()) {
                        this.log.debug("no artifact diff specified.");
                        continue;
                    }
                    this.log.debug("Preprare verification by diffing: ");
                    File diffRootDir = this.settings.getDiffDirectoryFile().getAbsoluteFile();
                    File artifactBaseDir = this.settings.getOutputDirectoryFile();
                    assert (targetFiles.size() == 1);
                    File pdfFileAct = targetFiles.iterator().next();
                    this.log.debug(String.format("act file %s", pdfFileAct));
                    File pdfFileCmp = TexFileUtils.getPdfFileDiff(pdfFileAct, artifactBaseDir, diffRootDir);
                    this.log.debug(String.format("cmp file %s", pdfFileCmp));
                    assert (pdfFileCmp.exists());
                    assert (pdfFileAct.exists());
                    boolean coincide = this.runDiffPdf(pdfFileCmp, pdfFileAct);
                    if (coincide) {
                        this.log.info("checked: coincides with expected artifact. ");
                        continue;
                    }
                    throw new BuildFailureException("TLP01: Artifact '" + pdfFileAct.getName() + "' of '" + texFile + "' could not be reproduced. ");
                }
            }
            if (this.settings.isCleanUp()) {
                this.fileUtils.cleanUp(node, texProcDir);
            }
            this.log.debug(this.settings.isCleanUp() ? "cleanup: " + texProcDir : "No cleanup");
        }
        catch (Throwable throwable) {
            if (this.settings.isCleanUp()) {
                this.fileUtils.cleanUp(node, texProcDir);
            }
            this.log.debug(this.settings.isCleanUp() ? "cleanup: " + texProcDir : "No cleanup");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAll() throws BuildFailureException {
        this.paramAdapt.initialize();
        this.log.debug("Settings: " + this.settings.toString());
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texProcDir;
        DirNode node = new DirNode(texProcDir, this.fileUtils);
        try {
            Collection<File> latexMainFiles = this.preProc.processGraphicsSelectMain(texProcDir, node);
            for (File latexMain : latexMainFiles) {
                this.runCheck(latexMain);
            }
        }
        finally {
            if (this.settings.isCleanUp()) {
                this.fileUtils.cleanUp(node, texProcDir);
            }
        }
    }

    public void processGraphics() throws BuildFailureException {
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texProcDir;
        DirNode node = new DirNode(texProcDir, this.fileUtils);
        this.preProc.processGraphicsSelectMain(texProcDir, node);
    }

    public void clearAll() throws BuildFailureException {
        this.paramAdapt.initialize();
        this.log.debug("Settings: " + this.settings.toString());
        File texProcDir = this.settings.getTexSrcProcDirectoryFile();
        assert (texProcDir.exists() && texProcDir.isDirectory()) : "Expected existing tex processing folder " + texProcDir;
        this.preProc.clearCreated(texProcDir);
    }

    private LatexMainDesc getLatexMainDesc(File texFile) {
        return new LatexMainDesc(texFile, this.fileUtils, this.settings.getPdfViaDvi());
    }

    private int preProcessLatex2dev(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        this.runLatex2dev(desc, dev);
        File texFile = desc.texFile;
        boolean hasBib = this.runBibtexByNeed(texFile);
        boolean hasIdxGls = this.runMakeIndexByNeed(desc) | this.runMakeGlossaryByNeed(desc);
        if (hasBib) {
            return 2;
        }
        boolean hasToc = TexFileUtils.replaceSuffix(texFile, SUFFIX_TOC).exists();
        if (hasIdxGls) {
            return hasToc ? 2 : 1;
        }
        boolean needLatexReRun = hasToc || TexFileUtils.replaceSuffix(texFile, SUFFIX_LOF).exists() || TexFileUtils.replaceSuffix(texFile, SUFFIX_LOT).exists();
        return needLatexReRun ? 1 : 0;
    }

    private void processLatex2devCore(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        int numLatexReRuns = this.preProcessLatex2dev(desc, dev);
        String latexCmd = this.settings.getCommand(ConverterCategory.LaTeX);
        assert (numLatexReRuns == 0 || numLatexReRuns == 1 || numLatexReRuns == 2);
        if (numLatexReRuns > 0) {
            this.log.debug("Rerun " + latexCmd + " to update table of contents, ... bibliography, index, or that like. ");
            this.runLatex2dev(desc, dev);
            --numLatexReRuns;
        }
        assert (numLatexReRuns == 0 || numLatexReRuns == 1);
        boolean needLatexReRun = numLatexReRuns == 1 || this.needRun(true, latexCmd, desc.logFile, this.settings.getPatternReRunLatex());
        int maxNumReruns = this.settings.getMaxNumReRunsLatex();
        for (int num = 0; maxNumReruns == -1 || num < maxNumReruns; ++num) {
            boolean needMakeIndexReRun = this.needRun(true, this.settings.getCommand(ConverterCategory.MakeIndex), desc.logFile, this.settings.getPatternReRunMakeIndex());
            if (!(needLatexReRun |= needMakeIndexReRun)) {
                return;
            }
            this.log.debug("Latex must be rerun. ");
            if (needMakeIndexReRun) {
                this.runMakeIndexByNeed(desc);
            }
            this.runLatex2dev(desc, dev);
            needLatexReRun = this.needRun(true, latexCmd, desc.logFile, this.settings.getPatternReRunLatex());
        }
        this.log.warn("WLP01: LaTeX requires rerun but maximum number " + maxNumReruns + " reached. ");
    }

    private boolean needRun(boolean another, String cmdStr, File logFile, String pattern) {
        Boolean needRun = this.fileUtils.matchInFile(logFile, pattern);
        if (needRun == null) {
            this.log.warn("WLP02: Cannot read log file '" + logFile.getName() + "'; " + cmdStr + " may require " + (another ? "re" : "") + "run. ");
            return false;
        }
        return needRun;
    }

    private void processLatex2dev(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        this.processLatex2devCore(desc, dev);
        this.logWarns(desc.logFile, this.settings.getCommand(ConverterCategory.LaTeX));
    }

    void processLatex2dvi(File texFile) throws BuildFailureException {
        this.log.info("Converting into dvi:  LaTeX file '" + texFile + "'. ");
        LatexMainDesc desc = this.getLatexMainDesc(texFile);
        this.processLatex2dev(desc, LatexDev.dvips);
    }

    void processLatex2pdf(File texFile) throws BuildFailureException {
        this.log.info("Converting into pdf:  LaTeX file '" + texFile + "'. ");
        LatexMainDesc desc = this.getLatexMainDesc(texFile);
        LatexDev dev = this.settings.getPdfViaDvi();
        this.processLatex2dev(desc, dev);
        if (dev.isViaDvi()) {
            this.runDvi2pdf(desc);
        }
    }

    private void logErrs(File logFile, String command) {
        this.logErrs(logFile, command, this.settings.getPatternErrLatex());
    }

    private void logWarns(File logFile, String command) {
        if (!logFile.exists()) {
            return;
        }
        if (this.settings.getDebugBadBoxes() && this.hasErrsWarns(logFile, PATTERN_OUFULL_HVBOX)) {
            this.log.warn("WLP03: Running " + command + " created bad boxes logged in '" + logFile.getName() + "'. ");
        }
        if (this.settings.getDebugWarnings() && this.hasErrsWarns(logFile, this.settings.getPatternWarnLatex())) {
            this.logWarn(logFile, command);
        }
    }

    void processLatex2html(File texFile) throws BuildFailureException {
        this.log.info("Converting into html: LaTeX file '" + texFile + "'. ");
        LatexMainDesc desc = this.getLatexMainDesc(texFile);
        this.preProcessLatex2dev(desc, this.settings.getPdfViaDvi());
        this.runLatex2html(desc);
    }

    void processLatex2odt(File texFile) throws BuildFailureException {
        this.log.info("Converting into odt:  LaTeX file '" + texFile + "'. ");
        LatexMainDesc desc = this.getLatexMainDesc(texFile);
        this.preProcessLatex2dev(desc, this.settings.getPdfViaDvi());
        this.runLatex2odt(desc);
    }

    void processLatex2docx(File texFile) throws BuildFailureException {
        this.log.info("Converting into doc(x): LaTeX file '" + texFile + "'. ");
        LatexMainDesc desc = this.getLatexMainDesc(texFile);
        this.preProcessLatex2dev(desc, this.settings.getPdfViaDvi());
        this.runLatex2odt(desc);
        this.runOdt2doc(texFile);
    }

    void processLatex2rtf(File texFile) throws BuildFailureException {
        this.log.info("Converting into rtf:  LaTeX file '" + texFile + "'. ");
        this.runLatex2rtf(texFile);
    }

    void processLatex2txt(File texFile) throws BuildFailureException {
        this.log.info("Converting into txt:  LaTeX file '" + texFile + "'. ");
        LatexMainDesc desc = this.getLatexMainDesc(texFile);
        LatexDev dev = this.settings.getPdfViaDvi();
        this.processLatex2devCore(desc, dev);
        if (dev.isViaDvi()) {
            this.runDvi2pdf(desc);
        }
        this.runPdf2txt(texFile);
    }

    public boolean printMetaInfo(boolean includeVersionInfo) throws BuildFailureException {
        return this.metaInfo.printMetaInfo(includeVersionInfo);
    }

    private boolean runBibtexByNeed(File texFile) throws BuildFailureException {
        File auxFile = TexFileUtils.replaceSuffix(texFile, SUFFIX_AUX);
        String command = this.settings.getCommand(ConverterCategory.BibTeX);
        if (!this.needRun(false, command, auxFile, PATTERN_NEED_BIBTEX_RUN)) {
            return false;
        }
        this.log.debug("Running " + command + " on '" + auxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getBibtexOptions(), auxFile);
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(texFile, SUFFIX_BBL));
        File logFile = TexFileUtils.replaceSuffix(texFile, SUFFIX_BLG);
        this.logErrs(logFile, command, this.settings.getPatternErrBibtex());
        this.logWarns(logFile, command, this.settings.getPatternWarnBibtex());
        return true;
    }

    private boolean runMakeIndexByNeed(LatexMainDesc desc) throws BuildFailureException {
        boolean needRun = desc.idxFile.exists();
        this.log.debug("MakeIndex run required? " + needRun);
        Collection<String> explIdxIdent = null;
        if (needRun && (explIdxIdent = this.fileUtils.collectMatches(desc.idxFile, IDX_EXPL, 2)) == null) {
            this.log.warn("WLP04: Cannot read idx file '" + desc.idxFile.getName() + "'; skip creation of index. ");
            return false;
        }
        assert (explIdxIdent != null == needRun);
        FileFilter filter = this.fileUtils.getFileFilterReplace(desc.idxFile, "-.+");
        File[] idxFilesExtInDir = this.fileUtils.listFilesOrWarn(desc.idxFile.getParentFile(), filter);
        if (idxFilesExtInDir != null && idxFilesExtInDir.length > 0 && (!needRun || explIdxIdent.isEmpty())) {
            this.log.warn("WLP05: Use package 'splitidx' without option 'split' in '" + desc.texFile.getName() + "'. ");
        }
        if (needRun) {
            if (explIdxIdent.isEmpty()) {
                this.runMakeIndex(desc);
            } else {
                this.runSplitIndex(desc, explIdxIdent);
            }
        }
        return needRun;
    }

    private void runMakeIndex(LatexMainDesc desc) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.MakeIndex);
        File idxFile = desc.idxFile;
        this.log.debug("Running " + command + " on '" + idxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getMakeIndexOptions(), idxFile);
        this.executor.execute(idxFile.getParentFile(), this.settings.getTexPath(), command, args, desc.indFile);
        this.logErrs(desc.ilgFile, command, this.settings.getPatternErrMakeIndex());
        this.logWarns(desc.ilgFile, command, this.settings.getPatternWarnMakeIndex());
    }

    private File[] files(String filePrefix, Collection<String> variant, String suffix) {
        File[] res = new File[variant.size()];
        int idx = 0;
        for (String idxIdent : variant) {
            StringBuilder strb = new StringBuilder();
            strb.append(filePrefix);
            strb.append(idxIdent);
            strb.append(suffix);
            res[idx++] = new File(strb.toString());
        }
        return res;
    }

    private void runSplitIndex(LatexMainDesc desc, Collection<String> explIdxIdent) throws BuildFailureException {
        String splitInxCmd = this.settings.getCommand(ConverterCategory.SplitIndex);
        File idxFile = desc.idxFile;
        this.log.debug("Running " + splitInxCmd + " on '" + idxFile.getName() + "'. ");
        String[] argsDefault = new String[]{"-m " + this.settings.getCommand(ConverterCategory.MakeIndex), "-i ^(\\\\indexentry)\\[([^]]*)\\](.*)$", "-r $1$3", "-s -$2"};
        String argsOption = this.settings.getMakeIndexOptions();
        String[] args = argsOption.isEmpty() ? new String[argsDefault.length + 1] : new String[argsDefault.length + 2];
        System.arraycopy(argsDefault, 0, args, 0, argsDefault.length);
        if (!argsOption.isEmpty()) {
            args[args.length - 2] = argsOption;
        }
        args[args.length - 1] = desc.xxxFile.getName();
        String optionsMakeIndex = this.settings.getMakeIndexOptions();
        if (!optionsMakeIndex.isEmpty()) {
            String[] optionsMake_IndexArr = optionsMakeIndex.split(" ");
            String[] optionsSplitIndexArr = args;
            args = new String[optionsMake_IndexArr.length + 1 + optionsSplitIndexArr.length];
            System.arraycopy(optionsSplitIndexArr, 0, args, 0, optionsSplitIndexArr.length);
            args[optionsSplitIndexArr.length] = "--";
            System.arraycopy(optionsMake_IndexArr, 0, args, optionsSplitIndexArr.length + 1, optionsMake_IndexArr.length);
        }
        explIdxIdent.add(IMPL_IDENT_IDX);
        String filePrefix = desc.xxxFile.toString() + SEP_IDENT_IDX;
        File[] indFiles = this.files(filePrefix, explIdxIdent, SUFFIX_IND);
        this.executor.execute(idxFile.getParentFile(), this.settings.getTexPath(), splitInxCmd, args, indFiles);
        File[] ilgFiles = this.files(filePrefix, explIdxIdent, SUFFIX_ILG);
        splitInxCmd = this.settings.getCommand(ConverterCategory.MakeIndex);
        for (int idx = 0; idx < explIdxIdent.size(); ++idx) {
            this.logErrs(ilgFiles[idx], splitInxCmd, this.settings.getPatternErrMakeIndex());
            this.logWarns(ilgFiles[idx], splitInxCmd, this.settings.getPatternWarnMakeIndex());
        }
    }

    private boolean runMakeGlossaryByNeed(LatexMainDesc desc) throws BuildFailureException {
        boolean needRun = desc.gloFile.exists();
        this.log.debug("MakeGlossaries run required? " + needRun);
        if (!needRun) {
            return false;
        }
        File xxxFile = desc.xxxFile;
        String command = this.settings.getCommand(ConverterCategory.MakeGlossaries);
        this.log.debug("Running " + command + " on '" + xxxFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getMakeGlossariesOptions(), xxxFile);
        this.executor.execute(xxxFile.getParentFile(), this.settings.getTexPath(), command, args, desc.glsFile);
        File glgFile = desc.glgFile;
        this.logErrs(glgFile, command, this.settings.getPatternErrMakeGlossaries());
        this.logWarns(glgFile, command, this.settings.getPatternWarnMakeIndex() + "|" + this.settings.getPatternWarnXindy());
        return true;
    }

    private void runLatex2dev(LatexMainDesc desc, LatexDev dev) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getCommand(ConverterCategory.LaTeX);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildLatexArguments(this.settings, dev, texFile);
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, dev.latexTargetFile(desc));
        this.logErrs(desc.logFile, command);
    }

    protected static String[] buildLatexArguments(Settings settings, LatexDev dev, File texFile) {
        return LatexProcessor.buildArguments(settings.getLatex2pdfOptions() + " -output-format=" + dev.getLatexOutputFormat(), texFile);
    }

    private void runDvi2pdf(LatexMainDesc desc) throws BuildFailureException {
        assert (this.settings.getPdfViaDvi().isViaDvi());
        String command = this.settings.getCommand(ConverterCategory.Dvi2Pdf);
        this.log.debug("Running " + command + " on '" + desc.dviFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getDvi2pdfOptions(), desc.dviFile);
        this.executor.execute(desc.texFile.getParentFile(), this.settings.getTexPath(), command, args, desc.pdfFile);
    }

    private void runLatex2html(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getTex4htCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildHtlatexArguments(this.settings, texFile);
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(texFile, SUFFIX_HTML));
        this.logErrs(desc.logFile, command);
        this.logWarns(desc.logFile, command);
    }

    protected static String[] buildHtlatexArguments(Settings settings, File texFile) {
        return new String[]{texFile.getName(), settings.getTex4htStyOptions(), settings.getTex4htOptions(), settings.getT4htOptions(), settings.getLatex2pdfOptions()};
    }

    private void runLatex2rtf(File texFile) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.LaTeX2Rtf);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getLatex2rtfOptions(), texFile);
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(texFile, SUFFIX_RTF));
    }

    private void runLatex2odt(LatexMainDesc desc) throws BuildFailureException {
        File texFile = desc.texFile;
        String command = this.settings.getTex4htCommand();
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = new String[]{texFile.getName(), "xhtml,ooffice", "ooffice/! -cmozhtf", "-coo -cvalidate"};
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(texFile, SUFFIX_ODT));
        this.logErrs(desc.logFile, command);
        this.logWarns(desc.logFile, command);
    }

    private void runOdt2doc(File texFile) throws BuildFailureException {
        File odtFile = TexFileUtils.replaceSuffix(texFile, SUFFIX_ODT);
        String command = this.settings.getCommand(ConverterCategory.Odt2Doc);
        this.log.debug("Running " + command + " on '" + odtFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getOdt2docOptions(), odtFile);
        String suffix = null;
        for (int idx = 0; idx < args.length - 1; ++idx) {
            if (!args[idx].startsWith("-f")) continue;
            assert (suffix == null);
            suffix = args[idx].substring(2, args[idx].length());
        }
        assert (suffix != null);
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(texFile, suffix));
    }

    private void runPdf2txt(File texFile) throws BuildFailureException {
        File pdfFile = TexFileUtils.replaceSuffix(texFile, ".pdf");
        String command = this.settings.getCommand(ConverterCategory.Pdf2Txt);
        this.log.debug("Running " + command + " on '" + pdfFile.getName() + "'. ");
        String[] args = LatexProcessor.buildArguments(this.settings.getPdf2txtOptions(), pdfFile);
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, TexFileUtils.replaceSuffix(texFile, SUFFIX_TXT));
    }

    private void runCheck(File texFile) throws BuildFailureException {
        File clgFile = TexFileUtils.replaceSuffix(texFile, SUFFIX_CLG);
        String command = this.settings.getCommand(ConverterCategory.LatexChk);
        this.log.debug("Running " + command + " on '" + texFile.getName() + "'. ");
        String[] args = LatexProcessor.buildChkTexArguments(this.settings.getChkTexOptions(), texFile, clgFile);
        this.executor.execute(texFile.getParentFile(), this.settings.getTexPath(), command, args, clgFile);
        if (!clgFile.exists()) {
            return;
        }
        if (clgFile.length() != 0L) {
            this.log.warn("WLP06: Running " + command + " found issues logged in '" + texFile.getName() + "'. ");
        }
    }

    protected static String[] buildChkTexArguments(String options, File texFile, File clgFile) {
        if (options.isEmpty()) {
            return new String[]{"-o", clgFile.getName(), texFile.getName()};
        }
        String[] optionsArr = options.split(" ");
        String[] args = Arrays.copyOf(optionsArr, optionsArr.length + 3);
        args[optionsArr.length] = "-o";
        args[optionsArr.length + 1] = clgFile.getName();
        args[optionsArr.length + 2] = texFile.getName();
        return args;
    }

    boolean runDiffPdf(File pdfFileCmp, File pdfFileAct) throws BuildFailureException {
        String command = this.settings.getCommand(ConverterCategory.DiffPdf);
        this.log.debug("Running " + command + " diffing '" + pdfFileCmp.getName() + "' and '" + pdfFileAct.getName() + "''. ");
        String[] args = new String[]{pdfFileCmp.toString(), pdfFileAct.toString()};
        return this.executor.execute(null, (File)this.settings.getTexPath(), (String)command, (String[])args, (File[])new File[0]).success;
    }

    static class LatexMainDesc {
        private final File texFile;
        final File pdfFile;
        final File dviFile;
        private final File logFile;
        private final File idxFile;
        private final File indFile;
        private final File ilgFile;
        private final File glsFile;
        private final File gloFile;
        private final File glgFile;
        private final File pycFile;
        private final File xxxFile;

        LatexMainDesc(File texFile, TexFileUtils fileUtils, LatexDev dev) {
            this.texFile = texFile;
            this.xxxFile = TexFileUtils.replaceSuffix(texFile, "");
            this.pdfFile = TexFileUtils.replaceSuffix(texFile, ".pdf");
            this.dviFile = TexFileUtils.replaceSuffix(texFile, LatexProcessor.SUFFIX_DVI);
            this.logFile = TexFileUtils.replaceSuffix(texFile, ".log");
            this.idxFile = TexFileUtils.replaceSuffix(texFile, LatexProcessor.SUFFIX_IDX);
            this.indFile = TexFileUtils.replaceSuffix(texFile, LatexProcessor.SUFFIX_IND);
            this.ilgFile = TexFileUtils.replaceSuffix(texFile, LatexProcessor.SUFFIX_ILG);
            this.glsFile = TexFileUtils.replaceSuffix(texFile, LatexProcessor.SUFFIX_GLS);
            this.gloFile = TexFileUtils.replaceSuffix(texFile, LatexProcessor.SUFFIX_GLO);
            this.glgFile = TexFileUtils.replaceSuffix(texFile, LatexProcessor.SUFFIX_GLG);
            this.pycFile = TexFileUtils.replaceSuffix(texFile, LatexProcessor.SUFFIX_PYC);
        }
    }
}

