/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DirNode {
    private final Set<String> regularFileNames;
    private final Map<String, DirNode> name2node;

    public DirNode(File dir, TexFileUtils fileUtils) {
        assert (dir.isDirectory()) : "The file '" + dir + "' is no directory. ";
        File[] files = fileUtils.listFilesOrWarn(dir);
        if (files == null) {
            this.regularFileNames = null;
            this.name2node = null;
            return;
        }
        this.regularFileNames = new TreeSet<String>();
        this.name2node = new TreeMap<String, DirNode>();
        for (File file : files) {
            assert (file.exists()) : "The file '" + file + "' does not exist. ";
            if (file.isDirectory()) {
                DirNode node = new DirNode(file, fileUtils);
                if (!node.isValid()) continue;
                this.name2node.put(file.getName(), node);
                continue;
            }
            this.regularFileNames.add(file.getName());
        }
    }

    boolean isValid() {
        assert (this.regularFileNames == null == (this.name2node == null));
        return this.regularFileNames != null;
    }

    Set<String> getRegularFileNames() {
        return this.regularFileNames;
    }

    Map<String, DirNode> getSubdirs() {
        return this.name2node;
    }
}

