/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.TexFileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

enum Converter {
    PdfLatex{

        @Override
        String getCommand() {
            return "pdflatex";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^pdfTeX 3\\.[0-9]*-[0-9]+\\.[0-9]+-%s \\(TeX Live";
        }
    }
    ,
    LuaLatex{

        @Override
        String getCommand() {
            return "lualatex";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is LuaHBTeX, Version %s \\(TeX Live";
        }
    }
    ,
    XeLatex{

        @Override
        String getCommand() {
            return "xelatex";
        }

        @Override
        String getVersionPattern() {
            return "((0\\.[0-9]*))";
        }

        @Override
        String getVersionEnvironment() {
            return "^XeTeX 3\\.[0-9]*-[0-9]+\\.[0-9]+-%s \\(TeX Live";
        }
    }
    ,
    Latex2rtf{

        @Override
        String getCommand() {
            return "latex2rtf";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]+)\\.([0-9]+)\\.([0-9]+) r([0-9]+))";
        }

        @Override
        String getVersionEnvironment() {
            return "^latex2rtf %s \\(released";
        }
    }
    ,
    Odt2doc{

        @Override
        String getCommand() {
            return "odt2doc";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^unoconv %s\n";
        }
    }
    ,
    Pdf2txt{

        @Override
        String getCommand() {
            return "pdftotext";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^pdftotext version %s\n";
        }
    }
    ,
    Dvips{

        @Override
        String getCommand() {
            return "dvips";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9\\.]{4})\\.([0-9]))";
        }

        @Override
        String getVersionEnvironment() {
            return "^This is dvips\\(k\\) %s Copyright [0-9]+ Radical Eye Software \\(www\\.radicaleye\\.com\\)\n";
        }
    }
    ,
    Dvipdfm{

        @Override
        String getCommand() {
            return "dvipdfm";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        String getVersionPattern() {
            return Converter.YYYYMMDD;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is xdvipdfmx Version %s by the DVIPDFMx project team,\n";
        }
    }
    ,
    Dvipdfmx{

        @Override
        String getCommand() {
            return "dvipdfmx";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        String getVersionPattern() {
            return Converter.YYYYMMDD;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is dvipdfmx Version %s by the DVIPDFMx project team,\n";
        }
    }
    ,
    XDvipdfmx{

        @Override
        String getCommand() {
            return "xdvipdfmx";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        String getVersionPattern() {
            return Converter.YYYYMMDD;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is xdvipdfmx Version %s by the DVIPDFMx project team,\n";
        }
    }
    ,
    Dvipdft{

        @Override
        String getCommand() {
            return "dvipdft";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]{4})([0-9]{2})([0-9]{2})\\.([0-9]{4}))";
        }

        @Override
        String getVersionEnvironment() {
            return "^dvipdft version %s by Thomas Esser and others\n";
        }
    }
    ,
    GS{

        @Override
        String getCommand() {
            return "gs";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]+)\\.([0-9]+)(?:\\.([0-9]+))?)";
        }

        @Override
        String getVersionEnvironment() {
            return "^GPL Ghostscript %s \\([0-9]{4}-[0-9]{2}-[0-9]{2}\\)\n";
        }
    }
    ,
    Chktex{

        @Override
        String getCommand() {
            return "chktex";
        }

        @Override
        String getVersionOption() {
            return "-W";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^ChkTeX v%s - Copyright [0-9]{4}-[0-9]{2} Jens T. Berger Thielemann.\n";
        }
    }
    ,
    Bibtex{

        @Override
        String getCommand() {
            return "bibtex";
        }

        @Override
        String getVersionPattern() {
            return "((0\\.[0-9]*)([a-z]))";
        }

        @Override
        String getVersionEnvironment() {
            return "^BibTeX %s \\(TeX Live ";
        }
    }
    ,
    Bibtexu{

        @Override
        String getCommand() {
            return "bibtexu";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^[^\n]*\n[^\n]*\nRelease version: %s \\([0-9]{2} [a-z]{3} [0-9]{4}\\)\n";
        }
    }
    ,
    Bibtex8{

        @Override
        String getCommand() {
            return "bibtex8";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^[^\n]*\n[^\n]*\nRelease version: %s \\([0-9]{2} [a-z]{3} [0-9]{4}\\)\n";
        }
    }
    ,
    Makeindex{

        @Override
        String getCommand() {
            return "makeindex";
        }

        @Override
        String getVersionOption() {
            return TexFileUtils.getEmptyIdx().getName().toString();
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^This is makeindex, version %s \\[TeX Live 2020\\] \\(kpathsea \\+ Thai support\\).\n";
        }
    }
    ,
    Upmendex{

        @Override
        String getCommand() {
            return "upmendex";
        }

        @Override
        String getVersionOption() {
            return "-h";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^upmendex - index processor, version %s \\(TeX Live [0-9]{4}\\).\n";
        }
    }
    ,
    Splitindex{

        @Override
        String getCommand() {
            return "splitindex";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^splitindex.pl %s\n";
        }
    }
    ,
    Xindy{

        @Override
        String getCommand() {
            return "xindy";
        }

        @Override
        String getVersionOption() {
            return "-V";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^xindy release: %s\n";
        }
    }
    ,
    Makeglossaries{

        @Override
        String getCommand() {
            return "makeglossaries";
        }

        @Override
        String getVersionOption() {
            return "--help";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^Makeglossaries Version %s \\([0-9]{4}-[0-9]{2}-[0-9]{2}\\)\n";
        }
    }
    ,
    Mpost{

        @Override
        String getCommand() {
            return "mpost";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^MetaPost %s \\(TeX Live ";
        }
    }
    ,
    Ebb{

        @Override
        String getCommand() {
            return "ebb";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        String getVersionPattern() {
            return Converter.YYYYMMDD;
        }

        @Override
        String getVersionEnvironment() {
            return "^[^\n]*\nThis is ebb Version %s\n";
        }
    }
    ,
    Gnuplot{

        @Override
        String getCommand() {
            return "gnuplot";
        }

        @Override
        String getVersionOption() {
            return "-V";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]+)\\.([0-9]+) patchlevel ([0-9]+))";
        }

        @Override
        String getVersionEnvironment() {
            return "^gnuplot %s\n";
        }
    }
    ,
    Inkscape{

        @Override
        String getCommand() {
            return "inkscape";
        }

        @Override
        String getVersionOption() {
            return "-V";
        }

        @Override
        String getVersionPattern() {
            return Converter.X_X_X;
        }

        @Override
        String getVersionEnvironment() {
            return "^(?:[^\n]*\n)?Inkscape %s \\([0-9a-f]+, [0-9]{4}-[0-9]{2}-[0-9]{2}\\)\n";
        }
    }
    ,
    Fig2Dev{

        @Override
        String getCommand() {
            return "fig2dev";
        }

        @Override
        String getVersionOption() {
            return "-V";
        }

        @Override
        String getVersionPattern() {
            return "(([0-9]+)\\.([0-9]+)\\.([0-9]+)([a-z]))";
        }

        @Override
        String getVersionEnvironment() {
            return "^fig2dev Version %s\n";
        }
    };

    private static final String X_X_X = "(([0-9]+)\\.([0-9]+)\\.([0-9]+))";
    private static final String X_X = "(([0-9]+)\\.([0-9]+))";
    private static final String YYYYMMDD = "(([0-9]{4})([0-9]{2})([0-9]{2}))";
    static final Map<String, Converter> cmd2conv;

    abstract String getCommand();

    String getVersionOption() {
        return "-v";
    }

    abstract String getVersionPattern();

    abstract String getVersionEnvironment();

    String getVersionInfo(CommandExecutor executor) throws BuildFailureException {
        return executor.execute(TexFileUtils.getEmptyIdx().getParentFile(), null, this.getCommand(), new String[]{this.getVersionOption()}, new File[0]);
    }

    static {
        cmd2conv = new HashMap<String, Converter>();
        for (Converter conv : Converter.values()) {
            cmd2conv.put(conv.getCommand(), conv);
        }
    }
}

