/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

enum Converter {
    PdfLatex{

        @Override
        String getCommand() {
            return "pdflatex";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^pdfTeX ([0-9\\.-]*) \\(TeX Live");
        }
    }
    ,
    LuaLatex{

        @Override
        String getCommand() {
            return "lualatex";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^This is LuaHBTeX, Version ([0-9\\.]*) \\(TeX Live");
        }
    }
    ,
    XeLatex{

        @Override
        String getCommand() {
            return "xelatex";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^XeTeX ([0-9\\.-]*) \\(TeX Live");
        }
    }
    ,
    Latex2rtf{

        @Override
        String getCommand() {
            return "latex2rtf";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^latex2rtf ([0-9\\.]* r[0-9]+) \\(released");
        }
    }
    ,
    Odt2doc{

        @Override
        String getCommand() {
            return "odt2doc";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^unoconv ([0-9\\.]*)\n");
        }
    }
    ,
    Pdf2txt{

        @Override
        String getCommand() {
            return "pdftotext";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^pdftotext version ([0-9\\.]*)\n");
        }
    }
    ,
    Dvips{

        @Override
        String getCommand() {
            return "dvips";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^This is dvips\\(k\\) ([0-9\\.]*) Copyright [0-9]+ Radical Eye Software \\(www\\.radicaleye\\.com\\)\n");
        }
    }
    ,
    Dvipdfm{

        @Override
        String getCommand() {
            return "dvipdfm";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^This is xdvipdfmx Version ([0-9]{8}) by the DVIPDFMx project team,\n");
        }
    }
    ,
    Dvipdfmx{

        @Override
        String getCommand() {
            return "dvipdfmx";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^This is dvipdfmx Version ([0-9]{8}) by the DVIPDFMx project team,\n");
        }
    }
    ,
    XDvipdfmx{

        @Override
        String getCommand() {
            return "xdvipdfmx";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^This is xdvipdfmx Version ([0-9]{8}) by the DVIPDFMx project team,\n");
        }
    }
    ,
    Dvipdft{

        @Override
        String getCommand() {
            return "dvipdft";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^dvipdft version ([0-9\\.]*) by Thomas Esser and others\n");
        }
    }
    ,
    GS{

        @Override
        String getCommand() {
            return "gs";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^GPL Ghostscript ([0-9\\.]*) \\([0-9]{4}-[0-9]{2}-[0-9]{2}\\)\n");
        }
    }
    ,
    Chktex{

        @Override
        String getCommand() {
            return "chktex";
        }

        @Override
        String getVersionOption() {
            return "-W";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^ChkTeX v([0-9\\.]*) - Copyright [0-9]{4}-[0-9]{2} Jens T. Berger Thielemann.\n");
        }
    }
    ,
    Bibtex{

        @Override
        String getCommand() {
            return "bibtex";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^BibTeX ([0-9\\.]*[a-z]) \\(TeX Live ");
        }
    }
    ,
    Bibtexu{

        @Override
        String getCommand() {
            return "bibtexu";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^This is BibTeXu: a UTF-8 Big BibTeX version ([0-9\\.]*[a-z])\n");
        }
    }
    ,
    Bibtex8{

        @Override
        String getCommand() {
            return "bibtex8";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^This is 8-bit Big BibTeX version ([0-9\\.]*[a-z])\n");
        }
    }
    ,
    Upmendex{

        @Override
        String getCommand() {
            return "upmendex";
        }

        @Override
        String getVersionOption() {
            return "-h";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^upmendex - index processor, version ([0-9\\.]*) \\(TeX Live [0-9]{4}\\).\n");
        }
    }
    ,
    Splitindex{

        @Override
        String getCommand() {
            return "splitindex";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^splitindex.pl ([0-9\\.]*)\n");
        }
    }
    ,
    Xindy{

        @Override
        String getCommand() {
            return "xindy";
        }

        @Override
        String getVersionOption() {
            return "-V";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^xindy release: ([0-9\\.]*)\n");
        }
    }
    ,
    Makeglossaries{

        @Override
        String getCommand() {
            return "makeglossaries";
        }

        @Override
        String getVersionOption() {
            return "--help";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^Makeglossaries Version ([0-9\\.]*) \\([0-9]{4}-[0-9]{2}-[0-9]{2}\\)(.*)\n");
        }
    }
    ,
    Mpost{

        @Override
        String getCommand() {
            return "mpost";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^MetaPost ([0-9\\.]*) \\(TeX Live ");
        }
    }
    ,
    Ebb{

        @Override
        String getCommand() {
            return "ebb";
        }

        @Override
        String getVersionOption() {
            return "--version";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^.*\nThis is ebb Version ([0-9]+)\n");
        }
    }
    ,
    Gnuplot{

        @Override
        String getCommand() {
            return "gnuplot";
        }

        @Override
        String getVersionOption() {
            return "-V";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^gnuplot ([0-9\\.]*) patchlevel 0\n");
        }
    }
    ,
    Inkscape{

        @Override
        String getCommand() {
            return "inkscape";
        }

        @Override
        String getVersionOption() {
            return "-V";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^Inkscape ([0-9\\.]*) \\([0-9a-f]+, [0-9]{4}-[0-9]{2}-[0-9]{2}\\)\n");
        }
    }
    ,
    Fig2Dev{

        @Override
        String getCommand() {
            return "fig2dev";
        }

        @Override
        String getVersionOption() {
            return "-V";
        }

        @Override
        Pattern getVersionPattern() {
            return Pattern.compile("^fig2dev Version ([0-9\\.]*[a-z])\n");
        }
    };

    static final Map<String, Converter> cmd2conv;

    abstract String getCommand();

    String getVersionOption() {
        return "-v";
    }

    abstract Pattern getVersionPattern();

    static {
        cmd2conv = new HashMap<String, Converter>();
        for (Converter conv : Converter.values()) {
            cmd2conv.put(conv.getCommand(), conv);
        }
    }
}

