/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.CommandExecutor;
import eu.simuline.m2latex.core.Converter;
import eu.simuline.m2latex.core.LogWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;

public class MetaInfo {
    private static final String META_FOLDER = "META-INF/";
    private final CommandExecutor executor;
    private final LogWrapper log;
    private static final String VERSION_PROPS_FILE = "version.properties";
    private static final String TOOL_VERSION_FORMAT = "%-15s '%s'/'%s'";

    static InputStream getStream(String fileName) throws BuildFailureException {
        try {
            URL url = MetaInfo.class.getClassLoader().getResource(fileName);
            return url.openStream();
        }
        catch (IOException e) {
            throw new BuildFailureException("could not get stream to file '" + fileName + "'");
        }
    }

    static Properties getProperties(String fileName) throws BuildFailureException {
        try {
            Properties properties = new Properties();
            properties.load(MetaInfo.getStream(fileName));
            return properties;
        }
        catch (IOException e) {
            throw new BuildFailureException("could not load properties from file '" + fileName + "'");
        }
    }

    MetaInfo(CommandExecutor executor, LogWrapper log) {
        this.executor = executor;
        this.log = log;
    }

    public void printMetaInfo() throws BuildFailureException {
        ManifestInfo manifestInfo = new ManifestInfo();
        this.log.info("Manifest properties: ");
        for (String line : manifestInfo.toStringArr()) {
            this.log.info(line);
        }
        String mavenDir = "META-INF/maven/";
        URL url = MetaInfo.class.getClassLoader().getResource(mavenDir);
        String propertyFileName = "META-INF/maven/eu.simuline.m2latex/latex-maven-plugin/pom.properties";
        this.log.info("pom properties:");
        Properties properties = MetaInfo.getProperties(propertyFileName);
        assert ("[groupId, artifactId, version]".equals(properties.stringPropertyNames().toString())) : "Found unexpected properties ";
        String coordGroupId = properties.getProperty("groupId");
        String coordArtifactId = properties.getProperty("artifactId");
        String coordVersion = properties.getProperty("version");
        this.log.info("coordinate.groupId:    '" + coordGroupId + "'");
        this.log.info("coordinate.artifactId: '" + coordArtifactId + "'");
        this.log.info("coordinate.version:    '" + coordVersion + "'");
        GitProperties gitProperties = new GitProperties();
        this.log.info("git properties: ");
        gitProperties.log();
        String gitBuildVersion = gitProperties.getBuildVersion();
        assert (gitBuildVersion.equals(manifestInfo.getImplVersion()));
        this.log.info("tool versions: ");
        this.log.info(String.format(TOOL_VERSION_FORMAT, "command:", "actual version", "expected version"));
        Properties versionProperties = MetaInfo.getProperties(VERSION_PROPS_FILE);
        for (Converter conv : Converter.values()) {
            String actVersion;
            boolean doWarn = false;
            String cmd = conv.getCommand();
            String line = this.executor.execute(null, null, cmd, new String[]{conv.getVersionOption()}, new File[0]);
            Matcher matcher = conv.getVersionPattern().matcher(line);
            if (matcher.find()) {
                actVersion = matcher.group(1);
            } else {
                doWarn = true;
                this.log.warn((Object)((Object)conv) + ": Version string '" + line + "' did not match ");
                actVersion = "????";
            }
            String expVersion = versionProperties.getProperty(cmd);
            if (expVersion == null) {
                this.log.warn((Object)((Object)conv) + ": found no expected version");
                expVersion = "????";
                doWarn = true;
            }
            if (!expVersion.equals(actVersion)) {
                doWarn = true;
            }
            String logMsg = String.format(TOOL_VERSION_FORMAT, cmd + ":", actVersion, expVersion);
            if (doWarn) {
                this.log.warn(logMsg);
                continue;
            }
            this.log.info(logMsg);
        }
    }

    class GitProperties {
        private static final String GIT_PROPS_FILE = "git.properties";
        private static final String GIT_BUILD_VERSION = "git.build.version";
        private static final String GIT_COMMIT_ID_DESCRIBE = "git.commit.id.describe";
        private static final String GIT_CLOSEST_TAG_NAME = "git.closest.tag.name";
        private static final String GIT_CLOSEST_TAG_COMMIT_COUNT = "git.closest.tag.commit.count";
        private static final String GIT_COMMIT_ID_ABBREV = "git.commit.id.abbrev";
        private static final String GIT_DIRTY = "git.dirty";
        private static final String GIT_BUILD_TIME = "git.build.time";
        private final Properties properties = MetaInfo.getProperties("git.properties");

        GitProperties() throws BuildFailureException {
            String gitBuildVersion = this.getBuildVersion();
            String gitCommitIdDescribe = this.getCommitIdDescribe();
        }

        private String getAttrValue(String key) {
            return this.properties.get(key).toString();
        }

        String getBuildVersion() {
            return this.getAttrValue(GIT_BUILD_VERSION);
        }

        String getCommitIdDescribe() {
            return this.getAttrValue(GIT_COMMIT_ID_DESCRIBE);
        }

        String getClosestTagName() {
            return this.getAttrValue(GIT_CLOSEST_TAG_NAME);
        }

        String getClosestTagCommitCount() {
            return this.getAttrValue(GIT_CLOSEST_TAG_COMMIT_COUNT);
        }

        String getCommitIdAbbrev() {
            return this.getAttrValue(GIT_COMMIT_ID_ABBREV);
        }

        String getDirty() {
            return this.getAttrValue(GIT_DIRTY);
        }

        String getBuildTime() {
            return this.getAttrValue(GIT_BUILD_TIME);
        }

        public String toString() {
            StringBuilder stb = new StringBuilder();
            stb.append("build version:  '" + this.getBuildVersion() + "'\n");
            stb.append("commit id desc: '" + this.getCommitIdDescribe() + "'\n");
            stb.append("buildTime:      '" + this.getBuildTime() + "'\n");
            return stb.toString();
        }

        void log() {
            MetaInfo.this.log.info("build version:  '" + this.getBuildVersion() + "'");
            MetaInfo.this.log.info("commit id desc: '" + this.getCommitIdDescribe() + "'");
            MetaInfo.this.log.info("buildTime:      '" + this.getBuildTime() + "'");
        }
    }

    static class ManifestInfo {
        private static final String MANIFEST_VERSION = "1.0";
        private static final String MVN_JAR_PLUGIN = "Maven Jar Plugin 3.2.0";
        private static final String MANIFEST_FILE = "MANIFEST.MF";
        private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
        private static final Attributes.Name BUILD_JDK_SPEC = new Attributes.Name("Build-Jdk-Spec");
        private final Manifest manifest;
        private final Attributes mAtts;

        ManifestInfo() throws BuildFailureException {
            try {
                this.manifest = new Manifest(MetaInfo.getStream("META-INF/MANIFEST.MF"));
            }
            catch (IOException e) {
                throw new BuildFailureException("could not read properties" + e);
            }
            this.mAtts = this.manifest.getMainAttributes();
            if (!MANIFEST_VERSION.equals(this.getManifestVersion())) {
                throw new IllegalStateException("Found manifest with version '" + this.getManifestVersion() + " where expected version " + MANIFEST_VERSION + ". ");
            }
            if (!MVN_JAR_PLUGIN.equals(this.mAtts.get(CREATED_BY))) {
                throw new IllegalStateException("Found manifest not created by 'Maven Jar Plugin 3.2.0'. ");
            }
            System.out.println("value for invalid manifest attribute: " + this.mAtts.get(CREATED_BY));
        }

        private String getAttrValue(Object name) {
            return this.mAtts.get(name).toString();
        }

        protected String getImplVersion() {
            return this.getAttrValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }

        protected String getImplVendor() {
            return this.getAttrValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        }

        protected String getManifestVersion() {
            return this.getAttrValue(Attributes.Name.MANIFEST_VERSION);
        }

        protected String getSpecVersion() {
            return this.getAttrValue(Attributes.Name.SPECIFICATION_VERSION);
        }

        protected String getCreatedBy() {
            return this.getAttrValue(CREATED_BY);
        }

        protected String getBuildJdkSpec() {
            return this.getAttrValue(BUILD_JDK_SPEC);
        }

        protected String getPackageImplVersion() {
            return this.getClass().getPackage().getImplementationVersion();
        }

        public String toString() {
            StringBuilder stb = new StringBuilder();
            for (String line : this.toStringArr()) {
                stb.append(line);
                stb.append('\n');
            }
            return stb.toString();
        }

        public String[] toStringArr() {
            return new String[]{"MANIFEST: (" + this.getManifestVersion() + ")", "Implementation-Version: '" + this.getImplVersion() + "'", "Implementation-Version: '" + this.getPackageImplVersion() + "'"};
        }
    }
}

