/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.m2latex.core;

import eu.simuline.m2latex.core.BuildFailureException;
import eu.simuline.m2latex.core.LogWrapper;
import java.io.File;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

class CommandExecutor {
    private final LogWrapper log;

    CommandExecutor(LogWrapper log) {
        this.log = log;
    }

    String execute(File workingDir, File pathToExecutable, String command, String[] args, File ... resFile) throws BuildFailureException {
        assert (resFile.length > 0);
        boolean[] existsTarget = new boolean[resFile.length];
        long[] lastModifiedTarget = new long[resFile.length];
        long currentTime = System.currentTimeMillis();
        long minTimePast = Long.MAX_VALUE;
        for (int idx = 0; idx < resFile.length; ++idx) {
            existsTarget[idx] = resFile[idx].exists();
            lastModifiedTarget[idx] = resFile[idx].lastModified();
            assert (lastModifiedTarget[idx] <= currentTime);
            minTimePast = Math.min(minTimePast, currentTime - lastModifiedTarget[idx]);
        }
        if (minTimePast < 1001L) {
            try {
                Thread.sleep(1001L - minTimePast);
            }
            catch (InterruptedException ie) {
                this.log.warn("WEX05: Update control may emit false warnings. ");
            }
        }
        String res = this.execute(workingDir, pathToExecutable, command, args);
        for (int idx = 0; idx < resFile.length; ++idx) {
            this.isUpdatedOrWarn(command, resFile[idx], existsTarget[idx], lastModifiedTarget[idx]);
        }
        return res;
    }

    private boolean isUpdatedOrWarn(String command, File target, boolean existedBefore, long lastModifiedBefore) {
        if (!target.exists()) {
            this.log.error("EEX02: Running " + command + " failed: No target file '" + target.getName() + "' written. ");
            return false;
        }
        assert (target.exists());
        if (!existedBefore) {
            return true;
        }
        assert (existedBefore && target.exists());
        long lastModifiedAfter = target.lastModified();
        if (lastModifiedBefore == 0L || lastModifiedAfter == 0L) {
            this.log.warn("WEX04: Cannot read target file '" + target.getName() + "'; may be outdated. ");
            return false;
        }
        assert (lastModifiedBefore > 0L && lastModifiedAfter > 0L);
        if (lastModifiedAfter <= lastModifiedBefore) {
            assert (lastModifiedAfter == lastModifiedBefore);
            this.log.error("EEX03: Running " + command + " failed: Target file '" + target.getName() + "' is not updated. ");
            return false;
        }
        return true;
    }

    private String execute(File workingDir, File pathToExecutable, String command, String[] args) throws BuildFailureException {
        String executable = new File(pathToExecutable, command).getPath();
        Commandline cl = new Commandline(executable);
        cl.getShell().setQuotedArgumentsEnabled(true);
        cl.addArguments(args);
        cl.setWorkingDirectory(workingDir.getPath());
        CommandLineUtils.StringStreamConsumer output = new CommandLineUtils.StringStreamConsumer();
        this.log.debug("Executing: " + cl + " in: " + workingDir + ". ");
        try {
            int returnCode = CommandLineUtils.executeCommandLine(cl, output, output);
            if (returnCode != 0) {
                this.log.error("EEX01: Running " + command + " failed with return code " + returnCode + ". ");
            }
        }
        catch (CommandLineException e) {
            throw new BuildFailureException("TEX01: Error running " + command + ". ", e);
        }
        this.log.debug("Output:\n" + output.getOutput() + "\n");
        return output.getOutput();
    }
}

