/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import eu.simuline.testhelpers.Editor;
import eu.simuline.testhelpers.ExtRunListener;
import eu.simuline.testhelpers.GUIRunner;
import eu.simuline.testhelpers.SeqRunListener;
import eu.simuline.testhelpers.TestCaseClassLoader;
import eu.simuline.util.JavaPath;
import eu.simuline.util.images.GifResource;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.javalobby.icons20x20.Delete;
import org.javalobby.icons20x20.ExecuteProject;
import org.javalobby.icons20x20.Hammer;
import org.javalobby.icons20x20.Open;
import org.javalobby.icons20x20.Stop;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

public final class Actions {
    private static final Pattern OPTION_PATTERN = Pattern.compile("-?-editor=(?<editor>(?<emacs>emacs)|(?<code>code))|(?<version>-?-version)|(?<help>-?-help)");
    private static final String SOURCE_PATH = System.getProperty("sourcepath");
    static final String TEST_CLASS_PATH = System.getProperty("chooseClasspath");
    private static final String TESTED_CLASS_PATH = System.getProperty("tbTestedClasspath");
    private final OpenAction openAction = new OpenAction();
    private final StartAction startAction = new StartAction();
    private final StopAction stopAction = new StopAction();
    private final BreakAction breakAction = new BreakAction();
    private final GUIRunner guiRunner;
    private CoreRunner coreRunner;
    private final ExtRunListener listener;
    private boolean isRunning;
    private Description filter;

    public Actions(String testClassName, Editor editor) {
        this.guiRunner = new GUIRunner(this, editor, SOURCE_PATH);
        this.listener = new SeqRunListener(this.guiRunner);
        this.coreRunner = new CoreRunner(testClassName);
        this.isRunning = false;
        this.filter = null;
    }

    private static boolean descShouldRun(Description desc, Description desiredDesc) {
        assert (desc.isTest());
        if (desiredDesc.isTest()) {
            return desiredDesc.equals((Object)desc);
        }
        for (Description each : desiredDesc.getChildren()) {
            if (!Actions.descShouldRun(desc, each)) continue;
            return true;
        }
        return false;
    }

    public static Filter desc2filter(final Description desiredDesc) {
        return new Filter(){

            public boolean shouldRun(Description desc) {
                return Actions.descShouldRun(desc, desiredDesc);
            }

            public String describe() {
                return String.format("Methods %s", desiredDesc.getDisplayName());
            }
        };
    }

    static void runTestClass(final String testClassName, final Editor editor) {
        Runnable guiCreator = new Runnable(){

            @Override
            public void run() {
                new Actions((String)testClassName, (Editor)editor).startAction.actionPerformed(null);
            }
        };
        SwingUtilities.invokeLater(guiCreator);
    }

    static String versionOrNa(boolean isLong) {
        String versionStr = Actions.class.getPackage().getImplementationVersion();
        if (versionStr == null) {
            return isLong ? "No version avaliable. Self-test? " : "version N.A.";
        }
        return isLong ? "Testhelpers version " + versionStr + ". " : "version " + versionStr;
    }

    public static void runFromMain(String ... args) {
        Editor editor = Editor.code;
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                Matcher m = OPTION_PATTERN.matcher(args[0]);
                if (!m.matches()) {
                    throw new IllegalArgumentException("Expected '--editor=(emacs|code)' or '--version' or '--help' but found '" + args[0] + "'. ");
                }
                if (m.group("version") != null) {
                    System.out.println(Actions.versionOrNa(true));
                    assert (m.group("editor") == null && m.group("help") == null);
                    return;
                }
                if (m.group("help") != null) {
                    System.out.println("Usage:  runTests.sh class [options]\nOptions is at most one of the following\n--help      Displays this help on command line options and exits.\n--version   Displays version information and exists.\n            Caution: not available in testhelpers self-test.\n--editor=e  Specifies an editor\n            which may be 'emacs' signifying emacsclient or (VS) 'code'.\n\nAll options are valid with a single '-' also.\nWith '-version' or '-help' class does not make sense and is ignored.\n");
                    assert (m.group("editor") == null && m.group("version") == null);
                    return;
                }
                assert (m.group("help") == null && m.group("version") == null);
                assert (m.group("emacs") == null ^ m.group("code") == null);
                if (m.group("emacs") == null) {
                    assert ("code".equals(m.group("code")));
                    editor = Editor.code;
                    break;
                }
                assert ("emacs".equals(m.group("emacs")));
                editor = Editor.emacsclient;
                break;
            }
            default: {
                throw new RuntimeException("Found more than one option.");
            }
        }
        Actions.runTestClass(new Throwable().getStackTrace()[1].getClassName(), editor);
    }

    GUIRunner getRunner() {
        return this.guiRunner;
    }

    void setFilter(Description filter) {
        assert (filter != null);
        this.filter = filter;
    }

    void setEnableForRun(boolean isRunning) {
        assert (this.isRunning ^ isRunning);
        this.isRunning = isRunning;
        this.openAction.setEnabled(!this.isRunning);
        this.startAction.setEnabled(!this.isRunning);
        this.stopAction.setEnabled(this.isRunning);
        this.breakAction.setEnabled(this.isRunning);
    }

    AbstractAction getOpenAction() {
        return this.openAction;
    }

    AbstractAction getStartAction() {
        return this.startAction;
    }

    AbstractAction getStopAction() {
        return this.stopAction;
    }

    AbstractAction getBreakAction() {
        return this.breakAction;
    }

    AbstractAction getExitAction() {
        return new ExitAction();
    }

    public static void main(String ... args) {
        Actions.runFromMain(args);
    }

    private class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = -589L;

        OpenAction() {
            super("Open", GifResource.getIcon(Open.class));
            this.putValue("ShortDescription", "Opens a class and executes run. ");
            this.putValue("MnemonicKey", 79);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String clsName = Actions.this.guiRunner.openClassChooser();
            if (clsName == null) {
                System.out.println("Warning: no class choosen");
                return;
            }
            assert (clsName != null);
            System.out.println("Info: class `" + clsName + "' choosen");
            Actions.this.coreRunner = new CoreRunner(clsName);
            Actions.this.filter = null;
            Actions.this.getStartAction().actionPerformed(null);
        }
    }

    private class StartAction
    extends AbstractAction {
        private static final long serialVersionUID = -589L;

        StartAction() {
            super("Run", GifResource.getIcon(ExecuteProject.class));
            this.putValue("ShortDescription", "Runs the testcases. ");
            this.putValue("MnemonicKey", 82);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Actions.this.coreRunner = new CoreRunner(Actions.this.coreRunner);
            Actions.this.coreRunner.start();
        }
    }

    private class StopAction
    extends AbstractAction {
        private static final long serialVersionUID = -589L;

        StopAction() {
            super("Stop", GifResource.getIcon(Stop.class));
            this.putValue("ShortDescription", "Stops after having executed the current testcase. ");
            this.putValue("MnemonicKey", 83);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Actions.this.coreRunner.pleaseStop();
        }
    }

    private class BreakAction
    extends AbstractAction {
        private static final long serialVersionUID = -589L;

        BreakAction() {
            super("Break", GifResource.getIcon(Hammer.class));
            this.putValue("ShortDescription", "Tries to break execution of current testcases. ");
            this.putValue("MnemonicKey", 66);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            System.out.println("Break...");
            Actions.this.coreRunner.pleaseStop();
            Actions.this.coreRunner.stop();
        }
    }

    private class CoreRunner
    extends Thread {
        private final RunNotifier notifier = new RunNotifier();
        private final String testClassName;

        CoreRunner(String testClassName) {
            this.notifier.addListener((RunListener)Actions.this.listener);
            this.testClassName = testClassName;
        }

        CoreRunner(CoreRunner other) {
            this(other.testClassName);
        }

        private void updateTestClassFileByNeed() {
            System.out.println("Check file up to date. ");
            File clsFile = null;
            File srcFile = null;
            try {
                clsFile = new JavaPath(TEST_CLASS_PATH).getFile(this.testClassName, JavaPath.ClsSrc.Class);
                srcFile = new JavaPath(SOURCE_PATH).getFile(this.testClassName, JavaPath.ClsSrc.Source);
                if (clsFile.lastModified() >= srcFile.lastModified()) {
                    System.out.println("class file is up to date. ");
                    return;
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException("No class file for '" + this.testClassName + "' found. ");
            }
            System.out.println("dummy compile class file. ");
            System.out.println(" classpath: " + System.getProperty("java.class.path"));
            System.out.println("targetpath: " + TEST_CLASS_PATH);
            System.out.println("sourcepath: " + srcFile);
            String cmdLine = "javac -classpath " + System.getProperty("java.class.path") + " -d " + TEST_CLASS_PATH + " " + srcFile;
            System.out.println("compilation command: " + cmdLine);
            try {
                Runtime.getRuntime().exec(cmdLine, null, null);
                clsFile = new JavaPath(TEST_CLASS_PATH).getFile(this.testClassName, JavaPath.ClsSrc.Class);
            }
            catch (IOException ioe) {
                System.err.println("Failed to invoke compiler. ");
                ioe.printStackTrace();
            }
            System.out.println("updated: " + (clsFile.lastModified() >= srcFile.lastModified()));
        }

        @Override
        public void run() {
            this.updateTestClassFileByNeed();
            Class<?> newTestClass = null;
            try {
                newTestClass = new TestCaseClassLoader(TESTED_CLASS_PATH, TEST_CLASS_PATH).loadClass(this.testClassName, true);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Testclass '" + this.testClassName + "' disappeared. ");
            }
            assert (newTestClass != null);
            Request request = Request.aClass(newTestClass);
            if (Actions.this.filter != null && Actions.this.filter.isTest()) {
                request = request.filterWith(Actions.this.filter);
            } else {
                Actions.this.listener.testClassStructureLoaded(request.getRunner().getDescription());
            }
            try {
                this.run(request);
            }
            catch (StoppedByUserException ee) {
                Actions.this.listener.testRunAborted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Request request) {
            Runner runner = request.getRunner();
            Result result = new Result();
            RunListener listener = result.createListener();
            this.notifier.addFirstListener(listener);
            try {
                this.notifier.fireTestRunStarted(runner.getDescription());
                runner.run(this.notifier);
                this.notifier.fireTestRunFinished(result);
            }
            finally {
                this.notifier.removeListener(listener);
            }
        }

        public void pleaseStop() {
            this.notifier.pleaseStop();
        }
    }

    private static class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = -589L;

        ExitAction() {
            super("Exit", GifResource.getIcon(Delete.class));
            this.putValue("ShortDescription", "Quits this application immediately. ");
            this.putValue("MnemonicKey", 69);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 2));
        }

        @Override
        @SuppressWarnings(value={"DM_EXIT"}, justification="To ensure safe exit not reached by throwing exception. Also Actions is not invoked by other code. ")
        public void actionPerformed(ActionEvent event) {
            System.exit(0);
        }
    }
}

