/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.junit.AssumptionFailure;
import eu.simuline.junit.Error;
import eu.simuline.junit.Failure;
import eu.simuline.junit.Ignored;
import eu.simuline.junit.New;
import eu.simuline.junit.Ok;
import eu.simuline.sun.gtk.File;
import eu.simuline.util.Benchmarker;
import eu.simuline.util.images.GifResource;
import java.awt.Color;
import javax.swing.ImageIcon;
import junit.framework.AssertionFailedError;

enum Quality {
    Scheduled(Deficiency.SoFarOk, Phase.Waiting){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(File.class);
        }

        @Override
        Quality setStarted() {
            return Started;
        }

        @Override
        Quality setFinished() {
            throw new IllegalStateException("Found testcase finished before started. ");
        }

        @Override
        Quality setIgnored() {
            return Ignored;
        }

        @Override
        String getMessage() {
            return "Scheduled";
        }
    }
    ,
    Started(Deficiency.SoFarOk, Phase.Running){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(New.class);
        }

        @Override
        Quality setFinished() {
            return Success;
        }

        @Override
        Quality setIgnored() {
            throw new IllegalStateException("Found testcase to be ignored while running. ");
        }

        @Override
        Quality setScheduled() {
            throw new IllegalStateException("Found testcase scheduled before started. ");
        }

        @Override
        Quality setStarted() {
            throw new IllegalStateException("Found testcase started while running. ");
        }

        @Override
        String getMessage() {
            return "started";
        }

        @Override
        Quality setAssumptionFailure() {
            return Invalidated;
        }

        @Override
        Quality setFailure(Throwable thrw) {
            return thrw instanceof AssertionFailedError || thrw instanceof AssertionError ? Failure : Error;
        }
    }
    ,
    Success(Deficiency.SoFarOk, Phase.Completed){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(Ok.class);
        }

        @Override
        Quality setFinished() {
            throw new IllegalStateException("Found testcase successful before finished. ");
        }

        @Override
        String getMessage() {
            return "succeeded";
        }
    }
    ,
    Invalidated(Deficiency.Indifferent, Phase.Incomplete){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(AssumptionFailure.class);
        }

        @Override
        String getMessage() {
            return "invalidated by failed assumption";
        }

        @Override
        boolean hasFailure() {
            return true;
        }
    }
    ,
    Ignored(Deficiency.Indifferent, Phase.Incomplete){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(Ignored.class);
        }

        @Override
        Quality setFinished() {
            throw new IllegalStateException("Found testcase finished and ignored. ");
        }

        @Override
        String getMessage() {
            return "was ignored";
        }
    }
    ,
    Failure(Deficiency.Failed, Phase.Completed){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(Failure.class);
        }

        @Override
        String getMessage() {
            return "failed";
        }

        @Override
        boolean hasFailure() {
            return true;
        }
    }
    ,
    Error(Deficiency.Failed, Phase.Completed){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(Error.class);
        }

        @Override
        String getMessage() {
            return "had an error";
        }

        @Override
        boolean hasFailure() {
            return true;
        }
    };

    private Deficiency deficiency;
    private Phase lifePhase;

    private Quality(Deficiency deficiency, Phase lifePhase) {
        this.deficiency = deficiency;
        this.lifePhase = lifePhase;
    }

    Quality setScheduled() {
        return Scheduled;
    }

    Quality setStarted() {
        throw new IllegalStateException("Found testcase started but not scheduled. ");
    }

    Quality setIgnored() {
        throw new IllegalStateException("Found testcase ignored but not scheduled. ");
    }

    Quality setFinished() {
        return this;
    }

    Quality setAssumptionFailure() {
        throw new IllegalStateException("Found testcase with assumption failure which is not started. ");
    }

    Quality setFailure(Throwable thrw) {
        throw new IllegalStateException("Found testcase with failure which is not started. ");
    }

    abstract ImageIcon getIcon();

    abstract String getMessage();

    Quality max(Quality other) {
        return this.deficiency.ordinal() > other.deficiency.ordinal() ? this : other;
    }

    Phase lifePhase() {
        return this.lifePhase;
    }

    Color getColor() {
        return this.deficiency.getColor();
    }

    boolean isNeutral() {
        return this.deficiency == Deficiency.SoFarOk;
    }

    boolean isCompleted() {
        return this.lifePhase.isCompleted();
    }

    boolean hasFailure() {
        return false;
    }

    static enum Deficiency {
        SoFarOk{

            @Override
            Color getColor() {
                return Color.green;
            }
        }
        ,
        Indifferent{

            @Override
            Color getColor() {
                return Color.yellow;
            }
        }
        ,
        Failed{

            @Override
            Color getColor() {
                return Color.red;
            }
        };


        abstract Color getColor();
    }

    static enum Phase {
        Waiting{

            @Override
            String timeMemString(Benchmarker.Snapshot snap) {
                assert (snap == null);
                return "\u231b";
            }
        }
        ,
        Running{

            @Override
            String timeMemString(Benchmarker.Snapshot snap) {
                assert (snap == null);
                return "\u23f3";
            }
        }
        ,
        Completed{

            @Override
            String timeMemString(Benchmarker.Snapshot snap) {
                return String.format("%.0fms/%.3fMB", snap.getTimeMs(), snap.getMemoryMB());
            }

            @Override
            boolean isCompleted() {
                return true;
            }
        }
        ,
        Incomplete{

            @Override
            String timeMemString(Benchmarker.Snapshot snap) {
                return "??ms/??MB";
            }

            @Override
            boolean isCompleted() {
                return true;
            }
        };


        abstract String timeMemString(Benchmarker.Snapshot var1);

        boolean isCompleted() {
            return false;
        }
    }
}

